/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.pattern;

import java.lang.reflect.Array;
import java.util.ArrayList;
import jp.jasminesoft.jfc.core.pattern.ArrayFilter;

public abstract class DecorativeArrayFilter<T>
implements ArrayFilter<T> {
    private final ArrayFilter<T> innerFilter;

    public DecorativeArrayFilter() {
        this.innerFilter = new EmptyFilter();
    }

    public DecorativeArrayFilter(DecorativeArrayFilter<T> filter) {
        this.innerFilter = filter == null ? new EmptyFilter() : filter;
    }

    @Override
    public T[] filter(T[] targets) {
        if ((targets = this.innerFilter.filter(targets)) == null) {
            return null;
        }
        Object[] emptyArray = (Object[])Array.newInstance(this.getComponentType(targets), 0);
        if (targets.length == 0) {
            return emptyArray;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T target : targets) {
            if (!this.accept(target)) continue;
            list.add(target);
        }
        return list.toArray(emptyArray);
    }

    protected Class<? extends T> getComponentType(T[] targets) {
        Class<?> clazz = targets.getClass().getComponentType();
        return clazz;
    }

    protected abstract boolean accept(T var1);

    public class EmptyFilter
    implements ArrayFilter<T> {
        @Override
        public T[] filter(T[] targets) {
            return targets;
        }
    }
}

