/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.pattern;

import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.core.pattern.Converter;

public class MappingTableConverter<S, T>
extends Converter<S, T> {
    private final Map<S, T> mappingTable;
    private final Class<T> targetComponentType;

    public MappingTableConverter(Map<S, T> mappingTable, Class<T> targetComponentType) {
        if (mappingTable.isEmpty()) {
            throw new IllegalArgumentException("mappingTable parameter is empty.");
        }
        this.targetComponentType = targetComponentType;
        this.mappingTable = mappingTable;
    }

    public MappingTableConverter(S[] sourceTable, T[] targetTable) {
        if (sourceTable == null) {
            throw new NullPointerException("sourceTable parameter is null.");
        }
        if (targetTable == null) {
            throw new NullPointerException("sourceTable parameter is null.");
        }
        if (sourceTable.length != targetTable.length) {
            throw new IllegalArgumentException("sourceTable array size and targetTable array size must be the same.");
        }
        Class<?> clazz = targetTable.getClass().getComponentType();
        this.targetComponentType = clazz;
        this.mappingTable = new HashMap<S, T>();
        for (int i = 0; i < sourceTable.length; ++i) {
            this.mappingTable.put(sourceTable[i], targetTable[i]);
        }
    }

    @Override
    public T convert(S source) {
        return this.mappingTable.get(source);
    }

    @Override
    protected Class<T> getTargetComponentType() {
        return this.targetComponentType;
    }
}

