/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import jp.jasminesoft.jfc.core.charset.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyUtils {
    private static final Logger logger = LogManager.getLogger(PropertyUtils.class);

    protected PropertyUtils() {
    }

    public static Properties load(Reader reader) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }

    public static Properties loadQuietly(Reader reader) {
        Properties properties = null;
        try {
            properties = PropertyUtils.load(reader);
        }
        catch (IOException ioe) {
            logger.debug(ioe.getMessage());
        }
        return properties;
    }

    public static Properties load(InputStream inputstream) throws IOException {
        return PropertyUtils.load(inputstream, Charsets.UTF8.charset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(InputStream inputstream, Charset charset) throws IOException {
        InputStreamReader reader = null;
        Properties properties = null;
        try {
            reader = new InputStreamReader(inputstream, charset);
            properties = PropertyUtils.load(reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return properties;
    }

    public static Properties load(File file) throws IOException {
        return PropertyUtils.load(file, Charsets.UTF8.charset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(File file, Charset charset) throws IOException {
        FileInputStream inputstream = null;
        Properties properties = null;
        try {
            inputstream = new FileInputStream(file);
            properties = PropertyUtils.load(inputstream, charset);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputstream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return properties;
    }

    public static Properties loadQuietly(File file) throws IOException {
        return PropertyUtils.loadQuietly(file, Charsets.UTF8.charset());
    }

    public static Properties loadQuietly(File file, Charset charset) throws IOException {
        Properties properties = null;
        try {
            properties = PropertyUtils.load(file, charset);
        }
        catch (FileNotFoundException fnfe) {
            logger.debug(fnfe.getMessage());
        }
        return properties;
    }

    public static Properties load(String filePath) throws IOException {
        return PropertyUtils.load(filePath, Charsets.UTF8.charset());
    }

    public static Properties load(String filePath, Charset charset) throws IOException {
        return PropertyUtils.load(new File(filePath), charset);
    }

    public static Properties loadQuietly(String filePath) throws IOException {
        return PropertyUtils.loadQuietly(filePath, Charsets.UTF8.charset());
    }

    public static Properties loadQuietly(String filePath, Charset charset) throws IOException {
        return PropertyUtils.loadQuietly(new File(filePath), charset);
    }

    public static Properties loadResource(String filePath) throws IOException {
        return PropertyUtils.loadResource(filePath, Charsets.UTF8.charset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadResource(String filePath, Charset charset) throws IOException {
        InputStream inputstream = null;
        Properties properties = null;
        if (filePath != null && !((String)filePath).startsWith("/")) {
            filePath = "/" + (String)filePath;
        }
        try {
            inputstream = PropertyUtils.class.getResourceAsStream((String)filePath);
            if (inputstream == null) {
                throw new FileNotFoundException((String)filePath);
            }
            properties = PropertyUtils.load(inputstream, charset);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
        return properties;
    }

    public static Properties loadResourceQuietly(String filePath) throws IOException {
        return PropertyUtils.loadResourceQuietly(filePath, Charsets.UTF8.charset());
    }

    public static Properties loadResourceQuietly(String filePath, Charset charset) throws IOException {
        Properties properties = null;
        try {
            properties = PropertyUtils.loadResource(filePath, charset);
        }
        catch (FileNotFoundException fnfe) {
            logger.debug(fnfe.getMessage());
        }
        return properties;
    }

    public static void store(Properties properties, String filePath) throws IOException {
        PropertyUtils.store(properties, new File(filePath), Charsets.UTF8.charset());
    }

    public static void store(Properties properties, String filePath, Charset charset) throws IOException {
        PropertyUtils.store(properties, new File(filePath), charset);
    }

    public static void store(Properties properties, File file) throws IOException {
        PropertyUtils.store(properties, file, Charsets.UTF8.charset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Properties properties, File file, Charset charset) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            PropertyUtils.store(properties, outputStream, charset);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void store(Properties properties, OutputStream outputStream) throws IOException {
        PropertyUtils.store(properties, outputStream, Charsets.UTF8.charset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Properties properties, OutputStream outputStream, Charset charset) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(outputStream, charset);
            properties.store(writer, null);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public static Properties combine(Properties ... properties) {
        Properties base = null;
        for (Properties merge : properties) {
            if (merge == null) continue;
            if (base == null) {
                base = new Properties();
            }
            base.putAll((Map<?, ?>)merge);
        }
        return base;
    }
}

