/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.ehcache;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import jp.jasminesoft.jfc.core.support.ehcache.JMSCachePeer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.jms.AcknowledgementMode;
import net.sf.ehcache.distribution.jms.JMSUtil;

public class JMSCacheManagerPeerProvider
extends net.sf.ehcache.distribution.jms.JMSCacheManagerPeerProvider {
    private static final Logger LOG = Logger.getLogger(JMSCacheManagerPeerProvider.class.getName());

    public JMSCacheManagerPeerProvider(CacheManager cacheManager, TopicConnection replicationTopicConnection, Topic replicationTopic, QueueConnection getQueueConnection, Queue getQueue, AcknowledgementMode acknowledgementMode, boolean listenToTopic) {
        super(cacheManager, replicationTopicConnection, replicationTopic, getQueueConnection, getQueue, acknowledgementMode, listenToTopic);
    }

    public void init() {
        try {
            this.topicPublisherSession = this.replicationTopicConnection.createTopicSession(false, this.acknowledgementMode.toInt());
            this.replicationTopicConnection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                    LOG.log(Level.SEVERE, "Exception on replication Connection: " + e.getMessage(), (Throwable)e);
                }
            });
            this.topicPublisher = this.topicPublisherSession.createPublisher(this.replicationTopic);
            if (this.listenToTopic) {
                LOG.fine("Listening for message on topic " + this.replicationTopic.getTopicName());
                TopicSession topicSubscriberSession = this.replicationTopicConnection.createTopicSession(false, this.acknowledgementMode.toInt());
                this.topicSubscriber = topicSubscriberSession.createSubscriber(this.replicationTopic, null, true);
                this.replicationTopicConnection.start();
            }
            this.getQueueSession = this.getQueueConnection.createQueueSession(false, this.acknowledgementMode.toInt());
            String messageSelector = "cacheManagerUniqueId <> " + JMSUtil.localCacheManagerUid((CacheManager)this.cacheManager);
            this.getQueueRequestReceiver = this.getQueueSession.createReceiver(this.getQueue, messageSelector);
            this.getQueueConnection.start();
        }
        catch (JMSException e) {
            throw new CacheException("Exception while creating JMS connections: " + e.getMessage(), (Throwable)e);
        }
        this.cachePeer = new JMSCachePeer(this.cacheManager, (MessageProducer)this.topicPublisher, (Session)this.topicPublisherSession, this.getQueueSession);
        this.remoteCachePeers.add(this.cachePeer);
        try {
            if (this.listenToTopic) {
                this.topicSubscriber.setMessageListener((MessageListener)this.cachePeer);
            }
            this.getQueueRequestReceiver.setMessageListener((MessageListener)this.cachePeer);
        }
        catch (JMSException e) {
            LOG.log(Level.SEVERE, "Cannot register " + this.cachePeer + " as messageListener", e);
        }
    }
}

