/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.velocity;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import jp.jasminesoft.jfc.core.support.velocity.JFCVelocityEngine;
import jp.jasminesoft.jfc.core.support.velocity.VelocityEngineFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class VelocityUtils {
    private static final Logger logger = LogManager.getLogger(VelocityUtils.class);

    protected VelocityUtils() {
    }

    public static String merge(JFCVelocityEngine engine, String templatePath, Map<String, Object> context) {
        Template template = engine.getTemplate(templatePath);
        VelocityContext vcontext = new VelocityContext(context);
        StringWriter writer = new StringWriter();
        template.merge((Context)vcontext, (Writer)writer);
        return writer.toString();
    }

    public static String merge(Properties properties, String templatePath, Map<String, Object> context) {
        JFCVelocityEngine engine = (JFCVelocityEngine)((Object)VelocityEngineFactory.getInstance().get(properties));
        return VelocityUtils.merge(engine, templatePath, context);
    }

    public static String merge(String templatePath, Map<String, Object> context) {
        return VelocityUtils.merge((Properties)null, templatePath, context);
    }

    public static String evaluate(JFCVelocityEngine engine, String template, Map<String, Object> context) {
        VelocityContext vcontext = new VelocityContext(context);
        StringWriter writer = new StringWriter();
        String logTag = VelocityUtils.class.getName() + "#evaluate()";
        engine.evaluate((Context)vcontext, writer, logTag, template);
        return writer.toString();
    }

    public static String evaluate(Properties properties, String template, Map<String, Object> context) {
        JFCVelocityEngine engine = (JFCVelocityEngine)((Object)VelocityEngineFactory.getInstance().get(properties));
        return VelocityUtils.evaluate(engine, template, context);
    }

    public static String evaluate(String template, Map<String, Object> context) {
        return VelocityUtils.evaluate((Properties)null, template, context);
    }
}

