/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.app.HibernateUtil;
import jp.jasminesoft.jfc.core.resources.PropertyUtils;
import jp.jasminesoft.jfc.model.jfcjob.IJfcjob;
import jp.jasminesoft.jfc.model.jfcmodel.IJfcmodel;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class AbstractDomainSupport
implements Serializable {
    private static final Logger logger = LogManager.getLogger(AbstractDomainSupport.class);
    public static final int SYSTEM_DOMAIN_ID = 1;
    public static final int COMMON_DOMAIN_ID = 2;
    public static final String DOMAIN_ID_PROPNAME = "wagby.domain.id";

    protected AbstractDomainSupport() {
    }

    public Integer id() {
        Environment env = AbstractDomainSupport.getApplicationContext().map(appctx -> (Environment)appctx.getBean(Environment.class)).orElse(null);
        String id = null;
        if (env != null) {
            id = env.getProperty(DOMAIN_ID_PROPNAME);
        } else {
            Properties properties;
            try {
                properties = PropertyUtils.loadResourceQuietly("application.properties");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            id = properties.getProperty(DOMAIN_ID_PROPNAME);
        }
        if (NumberUtils.isCreatable((String)id)) {
            return NumberUtils.toInt((String)id);
        }
        return null;
    }

    public String domainId() {
        return this.domainId(this.id());
    }

    public abstract String domainId(Integer var1);

    public String domainName() {
        return this.domainName(this.id());
    }

    public abstract String domainName(Integer var1);

    public abstract Map<String, int[]> getModelDomainInfo();

    static Optional<HttpServletRequest> getRequest() {
        RequestAttributes request = RequestContextHolder.getRequestAttributes();
        if (!(request instanceof ServletRequestAttributes)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((ServletRequestAttributes)request).getRequest());
    }

    static Optional<ApplicationContext> getApplicationContext() {
        return AbstractDomainSupport.getRequest().map(req -> Optional.ofNullable((ApplicationContext)ApplicationContext.class.cast(RequestContextUtils.findWebApplicationContext((HttpServletRequest)req)))).orElse(Optional.empty());
    }

    public abstract Map<String, String> domainUrls();

    public abstract int[] allIds();

    public boolean isCommonDomain(int id) {
        return id == 1 || id == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<Integer> getExecutableDomainid(String jobname) {
        if (jobname == null) {
            throw new IllegalStateException("jobname is null");
        }
        try (Session session = HibernateUtil.openSession();){
            SimpleExpression cri = Restrictions.eq((String)"name_", (Object)jobname);
            Map<String, SortedSet<Integer>> map = this.selectJfcjobAndJfcmodel(session, (Criterion)cri);
            SortedSet<Integer> sortedSet = map.get(jobname);
            return sortedSet;
        }
    }

    private Map<String, SortedSet<Integer>> selectJfcjobAndJfcmodel(Session session, Criterion cri) {
        HashMap<String, ArrayList<String>> jobnameTargetmodelsMap = new HashMap<String, ArrayList<String>>();
        HashMap modelnameDomainMap = new HashMap();
        Criteria criteria = session.createCriteria(IJfcjob.class);
        if (cri != null) {
            criteria = criteria.add(cri);
        }
        List jobresult = criteria.setFetchMode("targetmodels", FetchMode.JOIN).list();
        Iterator jobit = jobresult.iterator();
        ArrayList<String> modelnames = new ArrayList<String>();
        while (jobit.hasNext()) {
            IJfcjob o = (IJfcjob)jobit.next();
            if (logger.isDebugEnabled()) {
                logger.debug("jfcjob " + o);
            }
            String[] modelids = o.getTargetmodels();
            ArrayList<String> targetmodels = (ArrayList<String>)jobnameTargetmodelsMap.get(o.getName());
            if (targetmodels == null) {
                targetmodels = new ArrayList<String>();
                jobnameTargetmodelsMap.put(o.getName(), targetmodels);
            }
            targetmodels.addAll(Arrays.asList(modelids));
            modelnames.addAll(Arrays.asList(modelids));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("jobnameTargetmodelsMap " + jobnameTargetmodelsMap);
        }
        if (modelnames.size() != 0) {
            List modelresult = session.createCriteria(IJfcmodel.class).add(Restrictions.in((String)"nameEn_", modelnames)).setFetchMode("domain", FetchMode.JOIN).list();
            for (IJfcmodel o : modelresult) {
                ArrayList<Integer> domain;
                if (logger.isDebugEnabled()) {
                    logger.debug("IJfcmodel " + o);
                }
                if ((domain = (ArrayList<Integer>)modelnameDomainMap.get(o.getNameEn())) == null) {
                    domain = new ArrayList<Integer>();
                    modelnameDomainMap.put(o.getNameEn(), domain);
                }
                for (int d : o.getDomain()) {
                    domain.add(d);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("modelnameDomainMap " + modelnameDomainMap);
        }
        TreeMap<String, SortedSet<Integer>> jobnameDomainIdMap = new TreeMap<String, SortedSet<Integer>>();
        block3: for (String jobname : jobnameTargetmodelsMap.keySet()) {
            List modelids = (List)jobnameTargetmodelsMap.get(jobname);
            if (modelids.size() == 0) {
                jobnameDomainIdMap.put(jobname, Collections.emptySortedSet());
                continue;
            }
            TreeSet<Integer> domainIdSet = null;
            block4: for (String modelid : modelids) {
                int domain;
                List domains = (List)modelnameDomainMap.get(modelid);
                if (domains == null) {
                    logger.error("model " + modelid + " is not found in job " + jobname);
                    continue block3;
                }
                Iterator iterator = domains.iterator();
                while (iterator.hasNext()) {
                    domain = (Integer)iterator.next();
                    if (!this.isCommonDomain(domain)) continue;
                    if (domainIdSet != null) continue block4;
                    domainIdSet = new TreeSet();
                    continue block4;
                }
                if (domainIdSet == null) {
                    domainIdSet = new TreeSet<Integer>();
                    iterator = domains.iterator();
                    while (iterator.hasNext()) {
                        domain = (Integer)iterator.next();
                        domainIdSet.add(domain);
                    }
                    continue;
                }
                if (domainIdSet.isEmpty()) {
                    iterator = domains.iterator();
                    while (iterator.hasNext()) {
                        domain = (Integer)iterator.next();
                        domainIdSet.add(domain);
                    }
                    continue;
                }
                TreeSet<Integer> set = new TreeSet<Integer>();
                Iterator iterator2 = domains.iterator();
                while (iterator2.hasNext()) {
                    int domain2 = (Integer)iterator2.next();
                    set.add(domain2);
                }
                domainIdSet.retainAll(set);
            }
            jobnameDomainIdMap.put(jobname, domainIdSet);
        }
        return jobnameDomainIdMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SortedSet<Integer>> getExecutableDomainIdForJobnames(Collection<String> jobnames) {
        if (jobnames.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("jobname is empty");
            }
            return Collections.emptyMap();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("jobnames " + jobnames);
        }
        try (Session session = HibernateUtil.openSession();){
            Criterion cri = Restrictions.in((String)"name_", jobnames);
            Map<String, SortedSet<Integer>> map = this.selectJfcjobAndJfcmodel(session, cri);
            return map;
        }
    }
}

