/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import javax.persistence.PessimisticLockException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LockObjectWrapper;
import jp.jasminesoft.jfc.core.util.ReleasableCollection;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.dao.DaoHelper;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.util.StringUtil;

public class PageLock {
    private String lockobjectContainerAppmapKey;

    protected PageLock() {
    }

    protected PageLock(String lockobjectContainerAppmapKey) {
        this.lockobjectContainerAppmapKey = lockobjectContainerAppmapKey;
    }

    protected String getLockobjectContainerAppmapKey(ActionParameter p) {
        return this.lockobjectContainerAppmapKey;
    }

    public <E extends ContainerBase<E>, PK extends Serializable> void lock(E entity, DaoHelper<E, PK> helper) {
        this.lock(helper.getLockName(), helper.getLockKey(entity), helper.getActionParameterContainer().get());
    }

    public void lock(String lockName, String lockKey, ActionParameter p) {
        this.lock(lockName, lockKey, false, p);
    }

    public void lock(final String lockName, final String lockKey, boolean isReleaseSelfLock, final ActionParameter p) {
        if (StringUtils.isBlank((CharSequence)lockName) || StringUtils.isBlank((CharSequence)lockKey)) {
            JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
            String errorMessage = errorManager.getJfcerror("error.parameter.invalid", new Object[]{p.user.getUsername()}, p.locale).getContent();
            throw new IllegalStateException(errorMessage);
        }
        Function<LockManager, LockObject> function = new Function<LockManager, LockObject>(){

            @Override
            public LockObject apply(LockManager lman) {
                return lman.createLockObject(lockName, (Object)lockKey, p.request.getSession().getId(), p);
            }
        };
        this.lock(function, isReleaseSelfLock, p);
    }

    private void lock(Function<LockManager, LockObject> function, boolean isReleaseSelfLock, ActionParameter p) {
        LockManager lman;
        LockManager lockManager = lman = LockManagerFactory.getLockManager(p);
        synchronized (lockManager) {
            LockObject newLockObject = function.apply(lman);
            LockObject oldLockObject = lman.addLockObject(newLockObject);
            if (oldLockObject == null || newLockObject.equals(oldLockObject)) {
                if (oldLockObject == null) {
                    this.getLockObjectContainer(p).add(new LockObjectWrapper(newLockObject, p));
                }
                return;
            }
            if (isReleaseSelfLock && this.releaseSelfLock(oldLockObject, p) && ((oldLockObject = lman.addLockObject(newLockObject)) == null || newLockObject.equals(oldLockObject))) {
                this.getLockObjectContainer(p).add(new LockObjectWrapper(newLockObject, p));
                return;
            }
            throw new PessimisticLockException(this.getPessimisticLockMessage(oldLockObject, p));
        }
    }

    public void modelLock(String modelId, ActionParameter p) {
        this.modelLock(modelId, false, p);
    }

    public void modelLock(final String modelId, boolean isReleaseSelfLock, final ActionParameter p) {
        if (StringUtils.isBlank((CharSequence)modelId)) {
            JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
            String errorMessage = errorManager.getJfcerror("error.parameter.invalid", new Object[]{p.user.getUsername()}, p.locale).getContent();
            throw new IllegalStateException(errorMessage);
        }
        Function<LockManager, LockObject> function = new Function<LockManager, LockObject>(){

            @Override
            public LockObject apply(LockManager lman) {
                return lman.createLockObjectForAll(modelId, p.request.getSession().getId(), p.user);
            }
        };
        this.lock(function, isReleaseSelfLock, p);
    }

    protected ReleasableCollection<LockObjectWrapper> getLockObjectContainer(ActionParameter p) {
        String lockobject_container_appmap_key = this.getLockobjectContainerAppmapKey(p);
        ReleasableCollection lockObjectContainer = (ReleasableCollection)p.appMap.get(lockobject_container_appmap_key);
        if (lockObjectContainer == null) {
            lockObjectContainer = new ReleasableCollection();
            p.appMap.put(lockobject_container_appmap_key, lockObjectContainer);
        }
        return lockObjectContainer;
    }

    private String getPessimisticLockMessage(LockObject oldLockObject, ActionParameter p) {
        JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        String username = oldLockObject.getUsername();
        String modelid = oldLockObject.getModelname();
        Object pkey = oldLockObject.getPrimaryKey();
        String modeldesc = modelid;
        String modeldescrkey = "__jfc_tablename." + StringUtil.capFirst((String)modelid) + "ModelId";
        String value = JFCUtils.getRValue(modeldescrkey, p.locale);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            modeldesc = value;
        }
        return errorManager.getJfcerror("error.dbaccess.pessimisticlock", new Object[]{username, modelid, pkey, modeldesc}, p.locale).getContent();
    }

    public boolean releaseSelfLock(LockObject oldLockObject, ActionParameter p) {
        if (p.user == null || StringUtils.isBlank((CharSequence)oldLockObject.getUsername()) || !oldLockObject.getUsername().equals(p.user.getUsername())) {
            return false;
        }
        new LockObjectWrapper(oldLockObject, p).release();
        return true;
    }

    public <E extends ContainerBase<E>, PK extends Serializable> void isLocked(E entity, DaoHelper<E, PK> helper) {
        this.isLocked(helper.getLockName(), helper.getLockKey(entity), helper.getActionParameterContainer().get());
    }

    public void isLocked(final String lockName, final String lockKey, final ActionParameter p) {
        JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        if (StringUtils.isBlank((CharSequence)lockName) || StringUtils.isBlank((CharSequence)lockKey)) {
            String errorMessage = errorManager.getJfcerror("error.parameter.invalid", new Object[]{p.user.getUsername()}, p.locale).getContent();
            throw new IllegalStateException(errorMessage);
        }
        Function<LockManager, LockObject> function = new Function<LockManager, LockObject>(){

            @Override
            public LockObject apply(LockManager lman) {
                return lman.createLockObject(lockName, (Object)lockKey, p.request.getSession().getId(), p);
            }
        };
        this.isLocked(function, p);
    }

    public void isLocked(final String modelId, final ActionParameter p) {
        JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        if (StringUtils.isBlank((CharSequence)modelId)) {
            String errorMessage = errorManager.getJfcerror("error.parameter.invalid", new Object[]{p.user.getUsername()}, p.locale).getContent();
            throw new IllegalStateException(errorMessage);
        }
        Function<LockManager, LockObject> function = new Function<LockManager, LockObject>(){

            @Override
            public LockObject apply(LockManager lman) {
                return lman.createLockObjectForAll(modelId, p.request.getSession().getId(), p.user);
            }
        };
        this.isLocked(function, p);
    }

    public void isLocked(Function<LockManager, LockObject> function, ActionParameter p) {
        LockObject lockObject;
        JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        LockManager lman = LockManagerFactory.getLockManager(p);
        if (lman.isLocked(lockObject = function.apply(lman))) {
            return;
        }
        String errorMessage = errorManager.getJfcerror("error.dbaccess.nolock", p.locale).getContent();
        throw new IllegalStateException(errorMessage);
    }

    public <E extends ContainerBase<E>, PK extends Serializable> void release(E entity, DaoHelper<E, PK> helper) {
        this.release(helper.getLockName(), helper.getLockKey(entity), helper.getActionParameterContainer().get());
    }

    public void release(String lockName, String lockKey, ActionParameter p) {
        if (StringUtils.isBlank((CharSequence)lockName) || StringUtils.isBlank((CharSequence)lockKey)) {
            JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
            String errorMessage = errorManager.getJfcerror("error.parameter.invalid", new Object[]{p.user.getUsername()}, p.locale).getContent();
            throw new IllegalStateException(errorMessage);
        }
        LockManager lman = LockManagerFactory.getLockManager(p);
        LockObject lockObject = lman.createLockObject(lockName, (Object)lockKey, p.request.getSession().getId(), p);
        this.release(lockObject, p);
    }

    public void releaseModelLock(String modelId, ActionParameter p) {
        if (StringUtils.isBlank((CharSequence)modelId)) {
            JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
            String errorMessage = errorManager.getJfcerror("error.parameter.invalid", new Object[]{p.user.getUsername()}, p.locale).getContent();
            throw new IllegalStateException(errorMessage);
        }
        LockManager lman = LockManagerFactory.getLockManager(p);
        LockObject lockObject = lman.createLockObjectForAll(modelId, p.request.getSession().getId(), p.user);
        this.release(lockObject, p);
    }

    public void release(LockObject lockObject, ActionParameter p) {
        LockManager lman = LockManagerFactory.getLockManager(p);
        lman.releaseLockObject(lockObject);
        Iterator<LockObjectWrapper> iterator = this.getLockObjectContainer(p).iterator();
        while (iterator.hasNext()) {
            if (!lockObject.equals(iterator.next().getLockObject())) continue;
            iterator.remove();
        }
    }

    public void release(Collection<LockObject> lockObjects, ActionParameter p) {
        for (LockObject lockObject : lockObjects) {
            this.release(lockObject, p);
        }
    }

    public void releaseAll(ActionParameter p) {
        if (p == null) {
            return;
        }
        String lockobject_container_appmap_key = this.getLockobjectContainerAppmapKey(p);
        ReleasableCollection lockObjectContainer = (ReleasableCollection)p.appMap.remove(lockobject_container_appmap_key);
        if (lockObjectContainer != null) {
            lockObjectContainer.release();
        }
    }
}

