/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.validator;

import java.nio.charset.Charset;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.core.charset.Charsets;
import jp.jasminesoft.jfc.core.validator.JFCValidator;
import jp.jasminesoft.jfc.core.validator.LimitValidator;
import jp.jasminesoft.jfc.core.validator.RangeValidator;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;

public class ValidatorUtils {
    protected ValidatorUtils() {
    }

    public static JFCValidator limitMax(long max) {
        return ValidatorUtils.limitMax(max, null);
    }

    public static JFCValidator limitByteMax(long max) {
        return ValidatorUtils.limitMax(max, Charsets.UTF8.charset());
    }

    public static JFCValidator limitMax(final long max, final Charset charset) {
        System.out.println("limitMax");
        return new LimitValidator(){

            @Override
            public void validate(PropertyMetaBase<?> meta, String value, ActionParameter p) {
                this.validateMax(meta, value, p, max, charset);
            }
        };
    }

    public static JFCValidator limitMin(long min) {
        return ValidatorUtils.limitMin(min, null);
    }

    public static JFCValidator limitByteMin(long min) {
        return ValidatorUtils.limitMin(min, Charsets.UTF8.charset());
    }

    public static JFCValidator limitMin(final long min, final Charset charset) {
        System.out.println("limitMin");
        return new LimitValidator(){

            @Override
            public void validate(PropertyMetaBase<?> meta, String value, ActionParameter p) {
                this.validateMin(meta, value, p, min, charset);
            }
        };
    }

    public static JFCValidator range(final String range) {
        return new RangeValidator(){

            @Override
            public void validate(PropertyMetaBase<?> meta, String value, ActionParameter p) {
                this.validate(meta, value, p, range);
            }
        };
    }

    public static JFCValidator range(final String range, final String rangeSeparator) {
        return new RangeValidator(){

            @Override
            public void validate(PropertyMetaBase<?> meta, String value, ActionParameter p) {
                this.validate(meta, value, p, range, rangeSeparator);
            }
        };
    }
}

