/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.dao;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlElement;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.ConditionHelper;
import jp.jasminesoft.jfc.core.util.ArrayUtils;
import jp.jasminesoft.jfc.core.util.ModelUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.dao.SortKey;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.hibernate.AbstractWorkflowRestrictions;
import jp.jasminesoft.jfc.hibernate.CriteriaUtils;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.hibernate.OrderById;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.ClassUtils;

public class CriteriaConverter<C>
implements Serializable {
    private static final Logger logger = LogManager.getLogger(CriteriaConverter.class);
    private static final String NOSELECTION_MODELITEMNAME = "noselection_jshparam";
    protected Class<?> entityClass;
    protected ConditionHelper<C> conditionHelper;
    @Autowired
    @Qualifier(value="WorkflowRestrictions")
    protected AbstractWorkflowRestrictions workflowRestrictions;
    @Autowired
    @Qualifier(value="ActionParameterContainer")
    private ActionParameterContainer actionParameterContainer;

    public CriteriaConverter(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public void setConditionHelper(ConditionHelper<C> conditionHelper) {
        this.conditionHelper = conditionHelper;
    }

    public ActionParameterContainer getActionParameterContainer() {
        return this.actionParameterContainer;
    }

    public void setActionParameterContainer(ActionParameterContainer actionParameterContainer) {
        this.actionParameterContainer = actionParameterContainer;
    }

    public DetachedCriteria convert(C condition, SortKey sortKey) {
        if (condition == null) {
            return null;
        }
        boolean isRowCountQuery = false;
        if (sortKey != null && sortKey.isRowCountQuery()) {
            isRowCountQuery = true;
        }
        DetachedCriteria criteria = this.initializedCtiteria(isRowCountQuery);
        condition = this.copyCondition(condition);
        this.beforeSearch(condition);
        criteria = this.convert(criteria, condition, false);
        this.log(condition);
        criteria = this.convert(criteria, sortKey);
        return criteria;
    }

    protected void beforeSearch(C condition) {
        this.conditionHelper.beforeSearch(condition, this.getActionParameterContainer().get());
    }

    protected C copyCondition(C c) {
        return jp.jasminesoft.jfc.core.util.ClassUtils.newInstanceByCopyConstructor(c);
    }

    private DetachedCriteria convert(DetachedCriteria criteria, C condition, boolean defaultCriteria) {
        this.script(criteria, condition, defaultCriteria, this.getActionParameterContainer().get(), new Object(){}.getClass().getEnclosingMethod().getName());
        return this.convert(criteria, condition);
    }

    protected DetachedCriteria convert(DetachedCriteria criteria, C condition) {
        return criteria;
    }

    protected void log(C condition) {
        if (condition == null) {
            return;
        }
        ActionParameter p = this.getActionParameterContainer().get();
        if (p != null && p.cmd == CommandType.GetJson) {
            return;
        }
        if (!Boolean.parseBoolean(PropertyManager.getProperty("jp.jasminesoft.jfc.ProcessBean.isOutputConditionToLog"))) {
            return;
        }
        String logMessage = this.logMessage(condition);
        String key = "jp.jasminesoft.jfc.ProcessBean.isOutputAllSearchMessage";
        if (StringUtils.isBlank((CharSequence)logMessage)) {
            if (!Boolean.parseBoolean(PropertyManager.getProperty(key))) {
                return;
            }
            logMessage = "all search";
        }
        Class clazz = ClassUtils.getUserClass(this.getClass());
        LogManager.getLogger((Class)clazz).info(JFCUtils.logmsg(p, logMessage));
    }

    protected String logMessage(C condition) {
        StringBuilder logMessage = new StringBuilder();
        for (Field field : condition.getClass().getDeclaredFields()) {
            XmlElement xmlElement = field.getAnnotation(XmlElement.class);
            if (xmlElement == null) continue;
            try {
                field.setAccessible(true);
                Object value = field.get(condition);
                if (value == null || value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value)) || NOSELECTION_MODELITEMNAME.equals(xmlElement.name())) continue;
                logMessage.append(" [").append(xmlElement.name()).append("=").append(value).append("]");
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return logMessage.toString();
    }

    public boolean isBlankCondition(C condition) {
        String logMessage = this.logMessage(condition);
        return StringUtils.isBlank((CharSequence)logMessage);
    }

    protected DetachedCriteria convert(DetachedCriteria criteria, SortKey sortKey) {
        return criteria.addOrder(this.orderBy(sortKey));
    }

    protected DetachedCriteria initializedCtiteria() {
        return this.initializedCtiteria(false);
    }

    protected DetachedCriteria initializedCtiteria(boolean isRowCountQuery) {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.entityClass);
        if (isRowCountQuery) {
            criteria.setRowCountQuery(true);
        }
        return criteria;
    }

    public DetachedCriteria convert(SortKey sortKey) {
        return this.initializedCtiteria().addOrder(this.orderBy(sortKey));
    }

    public DetachedCriteria defaultCriteria() {
        return this.defaultCriteria(false);
    }

    public DetachedCriteria defaultCriteria(boolean isRowCountQuery) {
        return this.defaultCriteria(isRowCountQuery, (Order[])null);
    }

    public DetachedCriteria defaultCriteria(SortKey sortKey) {
        return this.defaultCriteria(sortKey, false);
    }

    public DetachedCriteria defaultCriteria(SortKey sortKey, boolean isRowCountQuery) {
        return this.defaultCriteria(isRowCountQuery, this.orderByWithCheck(sortKey));
    }

    public DetachedCriteria defaultCriteria(Order ... orders) {
        return this.defaultCriteria(false, orders);
    }

    public DetachedCriteria defaultCriteria(boolean isRowCountQuery, Order ... orders) {
        DetachedCriteria criteria = this.initializedCtiteria(isRowCountQuery);
        criteria.addOrder(this.orderBy(orders));
        if (CriteriaConverter.class.equals(this.getClass())) {
            return criteria;
        }
        C condition = this.newCondition();
        criteria = this.convert(criteria, condition, true);
        return criteria;
    }

    protected C newCondition() {
        Class<?> subClass = this.getClass();
        Object condition = jp.jasminesoft.jfc.core.util.ClassUtils.newInstance(jp.jasminesoft.jfc.core.util.ClassUtils.getCriteriaConverterConditionClass(subClass));
        return (C)condition;
    }

    public Order[] getDefaultOrders() {
        return new Order[]{new OrderById()};
    }

    public Order[] orderBy(SortKey sortKey) {
        return this.orderBy(this.orderByWithCheck(sortKey));
    }

    private <E extends ContainerBase<E>> Order[] orderByWithCheck(SortKey sortKey) {
        return CriteriaUtils.orderBy(sortKey, this.entityClass);
    }

    public Order[] orderBy(Order ... orders) {
        if (ArrayUtils.isEmpty((Object[])orders)) {
            return this.getDefaultOrders();
        }
        ArrayList<Order> list = new ArrayList<Order>();
        list.addAll(Arrays.asList(orders));
        for (Order order : this.getDefaultOrders()) {
            if (CriteriaUtils.contains(list, order)) continue;
            list.add(order);
        }
        return list.toArray(new Order[list.size()]);
    }

    public User user() {
        return this.getActionParameterContainer().get().user;
    }

    protected String[] getNoselectionJshparam(Object condition) {
        try {
            Method method = condition.getClass().getDeclaredMethod("getNoselectionJshparam", null);
            String[] value = (String[])method.invoke(condition, (Object[])null);
            return value;
        }
        catch (NoSuchMethodException e) {
            return new String[0];
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void script(DetachedCriteria criteria, C condition, boolean defaultCriteria, ActionParameter p, String methodName) {
        if (StringUtils.isBlank((CharSequence)methodName) || condition == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("criteria", (Object)criteria);
        params.put("defaultCriteria", defaultCriteria);
        if (condition instanceof ContainerBase) {
            params.put(ModelUtils.getModelId(condition.getClass()), condition);
        } else {
            params.put("condition", condition);
        }
        String status = new ScriptCodeRunner(ModelUtils.getModelId(this.entityClass)).process(this.getClass().getName(), methodName, params, p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            Jfcerror _error = new Jfcerror();
            _error.setContent(status);
            p.errors.addJfcerror(_error);
            logger.warn(status);
        }
    }
}

