/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.dao;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.FilterManager;
import jp.jasminesoft.jfc.core.filter.NullFilter;
import jp.jasminesoft.jfc.core.util.ArrayUtils;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.dao.CriteriaConverter;
import jp.jasminesoft.jfc.hibernate.AbstractWorkflowRestrictions;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.MultiPropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.meta.ReferenceMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ReactAdminRestBaseCriteriaConverter<E extends ContainerBase<E>>
extends CriteriaConverter<MultiValueMap<String, String>> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(ReactAdminRestBaseCriteriaConverter.class);
    private EntityMeta<E> entityMeta;
    private FilterManager filterManager;

    public ReactAdminRestBaseCriteriaConverter(EntityMeta<E> entityMeta) {
        super(entityMeta.entityClass());
        this.entityMeta = entityMeta;
    }

    public void setWorkflowRestrictions(AbstractWorkflowRestrictions workflowRestrictions) {
        this.workflowRestrictions = workflowRestrictions;
    }

    @Override
    protected MultiValueMap<String, String> copyCondition(MultiValueMap<String, String> c) {
        if (c == null) {
            return null;
        }
        return new LinkedMultiValueMap(c);
    }

    @Override
    public DetachedCriteria convert(DetachedCriteria criteria, MultiValueMap<String, String> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("condition must not be null.");
        }
        for (String key : condition.keySet()) {
            List values = (List)condition.get((Object)key);
            if (CollectionUtils.isEmpty((Collection)values)) continue;
            String itemName = key;
            SearchType searchType = SearchType.EQ;
            for (SearchType stype : SearchType.values()) {
                if (!key.endsWith(stype.getFooter())) continue;
                itemName = StringUtils.removeEnd((String)key, (String)stype.getFooter());
                searchType = stype;
                break;
            }
            this.addCriteria(criteria, itemName, searchType, values);
        }
        return criteria;
    }

    private <T> void addCriteria(DetachedCriteria criteria, String itemName, SearchType searchType, List<String> values) {
        PropertyMetaBase<?> meta = null;
        try {
            meta = this.entityMeta.propertyMeta(itemName);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (meta instanceof MultiPropertyMeta) {
            MultiPropertyMeta multiMeta = (MultiPropertyMeta)meta;
            Object[] array = StoreModelUtils.convertTypeValue(multiMeta, this.filterManager().filter(multiMeta, values)).toArray();
            this.addCriteria(criteria, multiMeta, searchType, array);
        } else {
            PropertyMetaBase<?> singleMeta = meta;
            this.addCriteria(criteria, singleMeta, searchType, values.stream().map(value -> StoreModelUtils.convertTypeValue(singleMeta, this.filterManager().filter(singleMeta, (String)value))).toArray());
        }
    }

    protected <T> void addCriteria(DetachedCriteria criteria, PropertyMetaBase<T> meta, SearchType searchType, T ... values) {
        String[] arrays = null;
        switch (searchType) {
            case LIKE: {
                arrays = this.stringArrays(values);
                if (meta instanceof MultiPropertyMeta) {
                    criteria.like((MultiPropertyMeta<String>)((MultiPropertyMeta)meta), arrays);
                    break;
                }
                if (meta instanceof ReferenceMeta) {
                    criteria.like((ReferenceMeta<String>)((ReferenceMeta)meta), arrays);
                    break;
                }
                criteria.like((PropertyMeta<String>)((PropertyMeta)meta), arrays);
                break;
            }
            case LIKEPREFIX: {
                arrays = this.stringArrays(values);
                if (meta instanceof MultiPropertyMeta) {
                    criteria.likePrefix((MultiPropertyMeta)meta, arrays);
                    break;
                }
                if (meta instanceof ReferenceMeta) {
                    criteria.likePrefix((ReferenceMeta)meta, arrays);
                    break;
                }
                criteria.likePrefix((PropertyMeta)meta, arrays);
                break;
            }
            case LIKESUFFIX: {
                arrays = this.stringArrays(values);
                if (meta instanceof MultiPropertyMeta) {
                    criteria.likeSuffix((MultiPropertyMeta)meta, arrays);
                    break;
                }
                if (meta instanceof ReferenceMeta) {
                    criteria.likeSuffix((ReferenceMeta)meta, arrays);
                    break;
                }
                criteria.likeSuffix((PropertyMeta)meta, arrays);
                break;
            }
            case LIKERUNTIME: {
                arrays = this.stringArrays(values);
                if (meta instanceof MultiPropertyMeta) {
                    criteria.likeRuntime((MultiPropertyMeta<String>)((MultiPropertyMeta)meta), arrays);
                    break;
                }
                if (meta instanceof ReferenceMeta) {
                    criteria.likeRuntime((ReferenceMeta<String>)((ReferenceMeta)meta), arrays);
                    break;
                }
                criteria.likeRuntime((PropertyMeta<String>)((PropertyMeta)meta), arrays);
                break;
            }
            case EQ: {
                if (meta instanceof MultiPropertyMeta) {
                    criteria.eq((MultiPropertyMeta)meta, values);
                    break;
                }
                if (meta instanceof ReferenceMeta) {
                    criteria.eq((ReferenceMeta)meta, values);
                    break;
                }
                criteria.eq((PropertyMeta)meta, values);
                break;
            }
            case GTE: {
                if (meta instanceof ReferenceMeta) {
                    criteria.ge((ReferenceMeta)meta, values[0]);
                    break;
                }
                criteria.ge((PropertyMeta)meta, values[0]);
                break;
            }
            case LTE: {
                if (meta instanceof ReferenceMeta) {
                    criteria.le((ReferenceMeta)meta, values[0]);
                    break;
                }
                criteria.le((PropertyMeta)meta, values[0]);
                break;
            }
            case GT: {
                if (meta instanceof ReferenceMeta) {
                    criteria.gt((ReferenceMeta)meta, values[0]);
                    break;
                }
                criteria.gt((PropertyMeta)meta, values[0]);
                break;
            }
            case LT: {
                if (meta instanceof ReferenceMeta) {
                    criteria.lt((ReferenceMeta)meta, values[0]);
                    break;
                }
                criteria.lt((PropertyMeta)meta, values[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown search type " + searchType);
            }
        }
    }

    private <T> String[] stringArrays(T[] values) {
        if (values instanceof String[]) {
            return (String[])values;
        }
        if (ArrayUtils.isEmpty((Object[])(values = new NullFilter<T>().filter(values)))) {
            return null;
        }
        return (String[])Stream.of(values).map(value -> value.toString()).toArray(String[]::new);
    }

    private FilterManager filterManager() {
        if (this.filterManager == null) {
            this.filterManager = (FilterManager)this.getActionParameterContainer().get().appctx.getBean("filterManager", FilterManager.class);
        }
        return this.filterManager;
    }

    static enum SearchType {
        EQ("_eq"),
        GTE("_gte"),
        LTE("_lte"),
        GT("_gt"),
        LT("_lt"),
        LIKE("_like"),
        LIKEPREFIX("_likePrefix"),
        LIKESUFFIX("_likeSuffix"),
        LIKERUNTIME("_likeRuntime");

        private String footer;

        private SearchType(String footer) {
            this.footer = footer;
        }

        public String getFooter() {
            return this.footer;
        }
    }
}

