/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiSessionUrlRewriteFilter
implements Filter {
    public static final Logger logger = LogManager.getLogger(MultiSessionUrlRewriteFilter.class);
    private final Pattern PATTERN = Pattern.compile("^/([0-9]*)(/.*)$");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String servletPath;
        Matcher matcher;
        logger.debug("called");
        HttpServletRequest req = (HttpServletRequest)request;
        if (logger.isDebugEnabled()) {
            logger.debug("request.getContextPath() " + req.getContextPath());
            logger.debug("request.getServletPath() " + req.getServletPath());
            logger.debug("request.getPathInfo() " + req.getPathInfo());
            logger.debug("request.getPathTranslated() " + req.getPathTranslated());
            logger.debug("request.getRequestURL() " + req.getRequestURL());
            logger.debug("request.getRequestURI() " + req.getRequestURI());
            logger.debug("request.getParameterMap() " + new HashMap(request.getParameterMap()));
        }
        if ((matcher = this.PATTERN.matcher(servletPath = req.getServletPath())).matches()) {
            String id = matcher.group(1);
            String newservletPath = matcher.group(2);
            HashMap<String, String[]> replaceparammap = new HashMap<String, String[]>();
            replaceparammap.put("_s", new String[]{id});
            request = new UrlRewriteHttpServletRequestWrapper(req, replaceparammap);
            String newurl = this.getNewRequestURL(req, newservletPath);
            if (logger.isDebugEnabled()) {
                logger.debug("id " + id);
                logger.debug("newservletPath " + newservletPath);
                logger.debug("newurl " + newurl);
            }
            RequestDispatcher rd = req.getRequestDispatcher(newurl);
            rd.forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public String getNewRequestURL(HttpServletRequest request, String newservletPath) {
        StringBuilder newurl = new StringBuilder();
        newurl.append(newservletPath);
        newurl.append(request.getPathInfo() != null ? request.getPathInfo() : "");
        return newurl.toString();
    }

    private static class UrlRewriteHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private Map<String, String[]> parammap;

        UrlRewriteHttpServletRequestWrapper(HttpServletRequest request, Map<String, String[]> replaceparammap) {
            super(request);
            this.parammap = new HashMap<String, String[]>(request.getParameterMap());
            this.parammap.putAll(replaceparammap);
        }

        public String getParameter(String name) {
            String[] v = this.parammap.get(name);
            if (v == null || v.length == 0) {
                return null;
            }
            return v[0];
        }

        public Map<String, String[]> getParameterMap() {
            return Collections.unmodifiableMap(this.parammap);
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.parammap.keySet());
        }

        public String[] getParameterValues(String name) {
            return this.parammap.get(name);
        }
    }
}

