/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jp.jasminesoft.util.KeyValueMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RequestCharacterEncodingFilter
implements Filter {
    public static final Logger logger = LogManager.getLogger((String)RequestCharacterEncodingFilter.class.getName());
    public static final String PROPERTYFILE_BROWSERTYPE = "browsertype";
    private KeyValueMapper browserMap;
    private String characterEncoding;
    private boolean isConvertParameterCharEncodingByGetMethod;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.browserMap = new KeyValueMapper(ResourceBundle.getBundle(PROPERTYFILE_BROWSERTYPE));
        this.browserMap.setValueProperty("encoding");
        this.characterEncoding = filterConfig.getInitParameter("characterEncoding");
        String s = filterConfig.getInitParameter("isConvertParameterCharEncodingByGetMethod");
        if (s != null) {
            this.isConvertParameterCharEncodingByGetMethod = Boolean.valueOf(s);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug("character encoding=" + this.characterEncoding);
            logger.debug("isConvertParameterCharEncodingByGetMethod=" + this.isConvertParameterCharEncodingByGetMethod);
            logger.debug("Method=" + ((HttpServletRequest)request).getMethod());
        }
        String charenc = null;
        String userAgent = null;
        if (request instanceof HttpServletRequest) {
            userAgent = ((HttpServletRequest)request).getHeader("user-agent");
        }
        if (userAgent != null) {
            try {
                charenc = this.browserMap.getValue(userAgent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (charenc.equals("default")) {
                charenc = null;
            }
        }
        if (charenc == null) {
            charenc = this.characterEncoding;
        }
        if (charenc == null) {
            logger.error("Nothing characterEncoding");
            chain.doFilter(request, response);
            return;
        }
        try {
            request.setCharacterEncoding(charenc);
            if (this.isConvertParameterCharEncodingByGetMethod && request instanceof HttpServletRequest && "GET".equalsIgnoreCase(((HttpServletRequest)request).getMethod())) {
                logger.debug("convert param char encoding");
                request = new ConvertParamCharEncHttpServletRequestWrapper((HttpServletRequest)request, charenc);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Illegal characterEncoding \"" + charenc + "\"");
        }
        chain.doFilter(request, response);
    }

    private static class ConvertParamCharEncHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private Map<String, String[]> parammap = new HashMap<String, String[]>();

        ConvertParamCharEncHttpServletRequestWrapper(HttpServletRequest request, String encoding) throws UnsupportedEncodingException {
            super(request);
            Enumeration enu = request.getParameterNames();
            while (enu.hasMoreElements()) {
                String[] newvalues;
                String name = (String)enu.nextElement();
                String[] values = request.getParameterValues(name);
                name = new String(name.getBytes("8859_1"), encoding);
                if (values == null) {
                    newvalues = null;
                } else {
                    newvalues = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("param name=" + name + " value[" + i + "]=" + values[i]);
                        }
                        newvalues[i] = new String(values[i].getBytes("8859_1"), encoding);
                    }
                }
                this.parammap.put(name, newvalues);
            }
        }

        public String getParameter(String name) {
            String[] values = this.getParameterValues(name);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }

        public Map<String, String[]> getParameterMap() {
            return Collections.unmodifiableMap(this.parammap);
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.parammap.keySet());
        }

        public String[] getParameterValues(String name) {
            return this.parammap.get(name);
        }
    }
}

