/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.ResultListWrapper;
import jp.jasminesoft.jfc.initdb.Cursor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.ScrollableResults;

class HibernateResultListWrapper
implements ResultListWrapper,
Releasable,
Cursor {
    private static final Logger logger = LogManager.getLogger(HibernateResultListWrapper.class);
    private ScrollableResults results;

    HibernateResultListWrapper(ScrollableResults results) {
        this.results = results;
    }

    @Override
    public boolean next() throws Exception {
        return this.results.next();
    }

    @Override
    public Object getObject() throws Exception {
        return this.results.get(0);
    }

    @Override
    public void release() {
        block2: {
            try {
                this.results.close();
            }
            catch (Exception e) {
                logger.debug("Failed to close results.", (Throwable)e);
                if (!logger.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    public List getResultList(int start, int end) {
        try {
            return this.getResultListE(start, end);
        }
        catch (Exception e) {
            logger.error("Failed to get result.", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    private List getResultListE(int start, int end) throws Exception {
        int len = end - start;
        if (len <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (!this.results.setRowNumber(start)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        do {
            Object obj;
            if ((obj = this.getObject()) == null) {
                return list;
            }
            list.add(obj);
        } while (++i < len && this.next());
        return list;
    }

    @Override
    public int getResultSize() {
        try {
            if (!this.results.last()) {
                return 0;
            }
            return this.results.getRowNumber() + 1;
        }
        catch (Exception e) {
            logger.debug("Failed to get result size.", (Throwable)e);
            return 0;
        }
    }

    @Override
    public boolean isIncludeResults(int start, int end) {
        return true;
    }
}

