/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.io.File;
import java.util.OptionalLong;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ApplicationPropertyManager;
import jp.jasminesoft.jfc.initdb.XML2DBLoader;
import jp.jasminesoft.jfc.initdb.XMLLoader;
import jp.jasminesoft.jfc.service.InitLoaderBaseService;

public class InitLoaderUtils {
    protected InitLoaderUtils() {
    }

    public static OptionalLong getSeqStartValue(String seqname, ActionParameter p) {
        XML2DBLoader loader = new XML2DBLoader();
        loader.load_config(InitLoaderUtils.configPath());
        loader.setExecuteEnvironmentType(XMLLoader.ExecuteEnvironmentType.webapp);
        Long value = loader.getExportedSequenceData(seqname, InitLoaderUtils.initDataPath(p));
        if (value != null) {
            return OptionalLong.of(value + 1L);
        }
        return OptionalLong.empty();
    }

    public static String initDataPath(ActionParameter p) {
        InitLoaderBaseService initLoaderBaseService = (InitLoaderBaseService)p.appctx.getBean("initLoaderService", InitLoaderBaseService.class);
        return initLoaderBaseService.getInitdataPath();
    }

    public static String configPath() {
        File catalinaBin = new File(System.getProperty("catalina.home"), "bin");
        String path = ApplicationPropertyManager.getProperty("configPath");
        if (!new File(path).isAbsolute()) {
            path = new File(catalinaBin, path).toString();
        }
        return path;
    }

    public static void createSequence(String seqname, ActionParameter p) {
        XML2DBLoader loader = new XML2DBLoader();
        String[] args = new String[]{"sequence", "-g", seqname, "-c", InitLoaderUtils.configPath()};
        loader.appctx = p.appctx;
        XML2DBLoader.execute(args, loader, null, XMLLoader.ExecuteEnvironmentType.webapp);
    }
}

