/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.initdb.XML2DBLoader;
import jp.jasminesoft.jfc.initdb.conf.Sql;
import jp.jasminesoft.jfc.migratedb.DDLHistFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MigrateInitdbIndex {
    private static final Logger logger = LogManager.getLogger(MigrateInitdbIndex.class);
    private static final String DROP_INDEX_GROUPNAME = "drop_index";
    private static final String CREATE_INDEX_GROUPNAME = "create_index";
    private XML2DBLoader initloader;
    private Path migratedbDir;
    private TablenameSqlMap nowsqls;
    private Set<String> createIndexTablenameSet;

    public MigrateInitdbIndex(XML2DBLoader initloader, Path migratedbDir) {
        this.initloader = initloader;
        this.migratedbDir = migratedbDir;
    }

    public void init(String version) {
        this.saveInitdb(version);
    }

    private void saveInitdb(String version) {
        Path initdbDir = this.migratedbDir.resolve("initdb");
        try {
            if (Files.notExists(initdbDir, new LinkOption[0])) {
                Files.createDirectory(initdbDir, new FileAttribute[0]);
            }
            Path c1 = initdbDir.resolve(version + "_initdb.xml");
            Path initdb = this.initloader.getProcessConfigFile().toPath();
            Files.copy(initdb, c1, new CopyOption[0]);
            Path c2 = initdbDir.resolve(version + "_initdb_ex.xml");
            Path initdbex = initdb.getParent().resolve("initdb_ex.xml");
            Files.copy(initdbex, c2, new CopyOption[0]);
        }
        catch (IOException e) {
            logger.error("io exception", (Throwable)e);
        }
    }

    public void migrateBefore() {
        logger.debug("migrateBefore");
        XML2DBLoader oldinitloader = this.loadOldInitdb();
        TablenameSqlMap now = this.createTablenameSqlMap(this.initloader);
        logger.debug("now tablename " + now.tablenames());
        if (oldinitloader == null) {
            logger.debug("nothing old initdb.xml");
            this.nowsqls = new TablenameSqlMap(new HashMap<String, Map<String, List<Sql>>>());
            this.createIndexTablenameSet = new HashSet<String>();
            return;
        }
        TablenameSqlMap old = this.createTablenameSqlMap(oldinitloader);
        logger.debug("old tablename " + old.tablenames());
        HashSet<String> deleteSet = new HashSet<String>(old.tablenames());
        deleteSet.removeAll(now.tablenames());
        HashSet<String> insertSet = new HashSet<String>(now.tablenames());
        insertSet.removeAll(old.tablenames());
        HashSet<String> retainSet = new HashSet<String>(now.tablenames());
        retainSet.retainAll(old.tablenames());
        for (String tablename : retainSet) {
            List<Sql> nowCreateIndex;
            List<Sql> oldCreateIndex = old.sqls(tablename, CREATE_INDEX_GROUPNAME);
            if (!this.isChangeSqlContent(oldCreateIndex, nowCreateIndex = now.sqls(tablename, CREATE_INDEX_GROUPNAME))) continue;
            deleteSet.add(tablename);
            insertSet.add(tablename);
        }
        this.nowsqls = now;
        this.createIndexTablenameSet = insertSet;
        if (deleteSet.size() > 0) {
            this.dropIndex(deleteSet, old);
        }
    }

    private XML2DBLoader loadOldInitdb() {
        Path path;
        XML2DBLoader oldinitloader = new XML2DBLoader();
        oldinitloader.setDeployHomeDir(this.initloader.getDeployHomeDir());
        try {
            path = MigrateInitdbIndex.findLast(this.migratedbDir);
        }
        catch (IOException e) {
            logger.error("io exception", (Throwable)e);
            throw new IllegalStateException("failed find path old initdb.xml", e);
        }
        if (path == null) {
            logger.debug("old initdb.xml is not found");
            return null;
        }
        logger.debug("initdb.xml path " + path);
        Object exfilename = path.getName(path.getNameCount() - 1).toString();
        exfilename = ((String)exfilename).substring(0, ((String)exfilename).length() - "_initdb.xml".length());
        exfilename = (String)exfilename + "_initdb_ex.xml";
        Path expath = path.getParent().resolve((String)exfilename);
        logger.debug("initdb_ex.xml path " + expath);
        try {
            Path expath1 = path.getParent().resolve("initdb_ex.xml");
            Files.copy(expath, expath1, new CopyOption[0]);
            oldinitloader.init(path.toString());
            Files.delete(expath1);
        }
        catch (IOException e) {
            logger.error("io exception", (Throwable)e);
            throw new IllegalStateException("failed load old initdb.xml", e);
        }
        return oldinitloader;
    }

    public void migrateAfter(String version) {
        logger.debug("migrateAfter " + version);
        if (this.nowsqls == null || this.createIndexTablenameSet == null) {
            throw new IllegalStateException("not execute migrateBefore");
        }
        if (this.createIndexTablenameSet.size() > 0) {
            this.createIndex(this.createIndexTablenameSet, this.nowsqls);
        }
        this.saveInitdb(version);
        this.nowsqls = null;
        this.createIndexTablenameSet = null;
    }

    private boolean isChangeSqlContent(List<Sql> old, List<Sql> now) {
        List oldsqlcnts = old.stream().map(sql -> sql.getContent()).sorted().collect(Collectors.toList());
        List nowsqlcnts = now.stream().map(sql -> sql.getContent()).sorted().collect(Collectors.toList());
        if (oldsqlcnts.size() != nowsqlcnts.size()) {
            logger.debug("1");
            return true;
        }
        for (int i = 0; i < oldsqlcnts.size(); ++i) {
            String nowsql;
            String oldsql = (String)oldsqlcnts.get(i);
            if (oldsql.equals(nowsql = (String)nowsqlcnts.get(i))) continue;
            logger.debug("2 " + oldsql + " " + nowsql);
            return true;
        }
        logger.debug("3");
        return false;
    }

    private void dropIndex(Set<String> tablenameSet, TablenameSqlMap map) {
        this.executeSql(tablenameSet, map, DROP_INDEX_GROUPNAME);
    }

    private void createIndex(Set<String> tablenameSet, TablenameSqlMap map) {
        this.executeSql(tablenameSet, map, CREATE_INDEX_GROUPNAME);
    }

    private void executeSql(Set<String> tablenameSet, TablenameSqlMap map, String groupname) {
        try (Connection con = this.initloader.createConnection();){
            for (String tablename : tablenameSet) {
                List<Sql> sqls = map.sqls(tablename, groupname);
                for (Sql sql : sqls) {
                    this.initloader.execute_sql(con, sql);
                }
            }
            con.commit();
        }
        catch (SQLException e) {
            logger.error("sql exception", (Throwable)e);
        }
    }

    private TablenameSqlMap createTablenameSqlMap(XML2DBLoader loader) {
        HashMap<String, Map<String, List<Sql>>> map = new HashMap<String, Map<String, List<Sql>>>();
        if (loader == null) {
            return new TablenameSqlMap(map);
        }
        for (Sql sql : loader.sql) {
            String tablename = sql.getTablename();
            String[] groups = sql.getGroup();
            HashMap<String, ArrayList<Sql>> map2 = (HashMap<String, ArrayList<Sql>>)map.get(tablename);
            if (map2 == null) {
                map2 = new HashMap<String, ArrayList<Sql>>();
                map.put(tablename, map2);
            }
            for (String group : groups) {
                ArrayList<Sql> sqls = (ArrayList<Sql>)map2.get(group);
                if (sqls == null) {
                    sqls = new ArrayList<Sql>();
                    map2.put(group, sqls);
                }
                sqls.add(sql);
            }
        }
        return new TablenameSqlMap(map);
    }

    public static Path findLast(Path migratedbDir) throws IOException {
        Path initdbDir = migratedbDir.resolve("initdb");
        if (Files.notExists(initdbDir, new LinkOption[0])) {
            return null;
        }
        String candidate = DDLHistFile.findLastPath(initdbDir, "glob:**/*_initdb.xml");
        if (candidate == null) {
            return null;
        }
        return initdbDir.resolve(candidate);
    }

    private static class TablenameSqlMap {
        Map<String, Map<String, List<Sql>>> map;

        TablenameSqlMap(Map<String, Map<String, List<Sql>>> map) {
            this.map = map;
        }

        Set<String> tablenames() {
            return this.map.keySet();
        }

        List<Sql> sqls(String tablename, String groupname) {
            Map<String, List<Sql>> map2 = this.map.get(tablename);
            if (map2 == null) {
                return Collections.emptyList();
            }
            List<Sql> sqls = map2.get(groupname);
            if (sqls == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(sqls);
        }
    }
}

