/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.text.ParseException;
import jp.jasminesoft.jfc.autoconfiguration.FilestoreS3Properties;
import jp.jasminesoft.jfc.job.AmazonS3FilestoreUploadJob;
import jp.jasminesoft.jfc.job.InitializeSchedulerListenerBase;
import jp.jasminesoft.jfc.job.Schedule;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;

public class AmazonS3FilestoreUploadInitializeSchedulerListener
extends InitializeSchedulerListenerBase {
    private static final Logger logger = LogManager.getLogger(AmazonS3FilestoreUploadInitializeSchedulerListener.class);
    public static final String JOBGROUP = "AmazonS3FilestoreUpload";
    public static final String JOBNAME = "AmazonS3FilestoreUpload";
    public static final String TRIGGERGROUP = "AmazonS3FilestoreUploadTrig";
    public static final String TRIGGERNAME = "AmazonS3FilestoreUploadTrig";
    public static final String SCHEDULE_SECOND = "18";
    @Autowired(required=false)
    private FilestoreS3Properties prop;

    @Override
    public void initializeScheduler(Scheduler sched, int id) {
        this.unscheduleJob(sched);
        if (this.isSchedule() && id == 1) {
            this.scheduleJob(sched);
        }
    }

    @Override
    protected Class<? extends Job> getJobClass() {
        return AmazonS3FilestoreUploadJob.class;
    }

    @Override
    protected String getTriggername() {
        return "AmazonS3FilestoreUploadTrig";
    }

    @Override
    protected String getTriggergroup() {
        return "AmazonS3FilestoreUploadTrig";
    }

    @Override
    protected String getJobname() {
        return "AmazonS3FilestoreUpload";
    }

    @Override
    protected String getJobgroup() {
        return "AmazonS3FilestoreUpload";
    }

    protected boolean isSchedule() {
        FilestoreS3Properties.Scheduler propsched = this.prop != null ? this.prop.getScheduler() : new FilestoreS3Properties.Scheduler();
        String propdchedCron = propsched.getCron();
        String propdchedMin = propsched.getMinute();
        return StringUtils.isNotBlank((CharSequence)propdchedCron) || StringUtils.isNotBlank((CharSequence)propdchedMin);
    }

    @Override
    protected Schedule getJobSchedule() {
        FilestoreS3Properties.Scheduler propsched = this.prop != null ? this.prop.getScheduler() : new FilestoreS3Properties.Scheduler();
        String propdchedCron = propsched.getCron();
        String propdchedMin = propsched.getMinute();
        if (StringUtils.isNotBlank((CharSequence)propdchedCron)) {
            try {
                Schedule sch = new Schedule();
                sch.setCronSchedule(propdchedCron);
                return sch;
            }
            catch (ParseException e) {
                logger.error("wagby.filestore.s3.scheduler.cron cron format is wrong. use minute setting. cron:" + propdchedCron + " minute:" + propdchedMin);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)propdchedMin)) {
            Schedule sch = new Schedule();
            sch.setSecond(SCHEDULE_SECOND);
            sch.setMinute(propdchedMin);
            return sch;
        }
        return null;
    }
}

