/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.initdb.PathUtil;
import jp.jasminesoft.jfc.initdb.XMLLoaderActionListener;
import jp.jasminesoft.jfc.job.TaskException;
import jp.jasminesoft.jfc.job.ZipArchiveTask;
import jp.jasminesoft.jfc.service.InitLoaderBaseService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExportTask {
    private static final Logger logger = LogManager.getLogger((String)ExportTask.class.getName());
    private String target;
    private String exclude;
    private String unlinkfile;
    private boolean useAsZip;
    private boolean debug;
    private String logHeader;

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public String getUnlinkfile() {
        return this.unlinkfile;
    }

    public void setUnlinkfile(String unlinkfile) {
        this.unlinkfile = unlinkfile;
    }

    public boolean getUseAsZip() {
        return this.useAsZip;
    }

    public void setUseAsZip(boolean useAsZip) {
        this.useAsZip = useAsZip;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected boolean isDebug() {
        return this.debug;
    }

    public String getLogHeader() {
        return this.logHeader;
    }

    public void setLogHeader(String logHeader) {
        this.logHeader = logHeader;
    }

    public String execute(ActionParameter p) {
        InitLoaderBaseService service = this.getInitLoaderBaseService(p);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String exportDirectory = service.getExportDirectoryPrefix() + sdf.format(new Date()) + "_schedule";
        String[][] tableList = service.getTableList(p);
        Set<String> targetSet = this.getTargetTableSet(this.target, tableList, this.exclude);
        Object[] args = new String[]{"export", "-t", this.getTargetTableString(targetSet), "-c", service.getConfigPath(), "-d", Paths.get(service.getExportParentPath(), exportDirectory).toString()};
        if (this.useAsZip && StringUtils.isBlank((CharSequence)this.unlinkfile)) {
            args = (String[])ArrayUtils.add((Object[])args, (Object)"-zip");
        }
        XMLLoaderActionListener listener = service.createXMLLoaderActionListener(p);
        service.do_execute((String[])args, listener);
        if (!this.useAsZip) {
            service.saveExportConfigFile(Paths.get(service.getExportParentPath(), exportDirectory).toString(), targetSet, p);
        }
        if (StringUtils.isNotBlank((CharSequence)this.unlinkfile)) {
            this.removeUnlinkFile(service, exportDirectory, targetSet);
            if (this.useAsZip) {
                String targetDirectory = Paths.get("..", "..", "export").toString();
                ZipArchiveTask ztask = new ZipArchiveTask();
                ztask.setDir(targetDirectory);
                ztask.setChooseLatest(true);
                ztask.setExclude(".*zip$");
                ztask.execute(p);
            }
        }
        return "Export task is finished.";
    }

    private void removeUnlinkFile(InitLoaderBaseService service, String exportDirectory, Set<String> targetSet) {
        Path d1 = Paths.get("..", "webapps");
        if (logger.isDebugEnabled()) {
            logger.debug("d1=" + d1);
        }
        if (!Files.isDirectory(d1, new LinkOption[0])) {
            return;
        }
        Optional<Object> d2 = Optional.empty();
        try (Stream<Path> stream = Files.list(d1);){
            d2 = stream.map(path -> path.resolve(Paths.get("WEB-INF", "classes", "savedir.properties"))).filter(Files::isReadable).findFirst();
        }
        catch (IOException e) {
            logger.error("Failed to read directory", (Throwable)e);
        }
        if (d2.isPresent()) {
            Properties savedirProperties = this.readProperties((Path)d2.get());
            if (logger.isDebugEnabled()) {
                logger.debug("props=" + savedirProperties);
            }
            this.removeUnlinkFile(service.getExportParentPath(), exportDirectory, savedirProperties, targetSet, this.unlinkfile);
        }
    }

    private Properties readProperties(Path d2) {
        Properties savedirProperties = new Properties();
        try (BufferedInputStream istream = new BufferedInputStream(Files.newInputStream(d2, new OpenOption[0]));){
            savedirProperties.load(istream);
        }
        catch (IOException e) {
            logger.error("Failed to read properties file", (Throwable)e);
        }
        return savedirProperties;
    }

    protected Set<String> getTargetTableSet(String target, String[][] tableList, String exclude) {
        LinkedHashSet<String> targetSet;
        block5: {
            HashSet<String> excludeSet;
            block4: {
                excludeSet = new HashSet<String>();
                if (StringUtils.isNotBlank((CharSequence)exclude)) {
                    String[] excludes;
                    for (String _s : excludes = exclude.split(" ")) {
                        excludeSet.add(_s);
                    }
                }
                targetSet = new LinkedHashSet<String>();
                if (!StringUtils.isNotBlank((CharSequence)target)) break block4;
                for (String tablename : target.split(" ")) {
                    if (excludeSet.contains(tablename)) continue;
                    targetSet.add(tablename);
                }
                break block5;
            }
            if (tableList == null || tableList.length <= 0) break block5;
            for (int i = 0; i < tableList.length; ++i) {
                String tablename = tableList[i][0];
                if (excludeSet.contains(tablename)) continue;
                targetSet.add(tablename);
            }
        }
        return targetSet;
    }

    protected String getTargetTableString(Set<String> targetSet) {
        StringBuilder sb = new StringBuilder();
        for (String tablename : targetSet) {
            sb.append(tablename);
            sb.append(" ");
        }
        return sb.toString();
    }

    protected InitLoaderBaseService getInitLoaderBaseService(ActionParameter p) {
        return (InitLoaderBaseService)p.appctx.getBean("initLoaderService");
    }

    private void removeUnlinkFile(String exportParentPath, String exportDirectory, Properties savedirProperties, Set<String> targetSet, String unlinkFileCommand) {
        Path exportDir = Paths.get(exportParentPath, exportDirectory, "init");
        if (logger.isDebugEnabled()) {
            logger.debug("exportDir=" + exportDir + ",targetSet=" + targetSet);
        }
        Path moveToDir = null;
        if (unlinkFileCommand != null && unlinkFileCommand.startsWith("move:")) {
            String moveTo = unlinkFileCommand.substring("move:".length()).trim();
            moveToDir = this.getMoveToDir(moveTo);
        }
        HashSet<Path> fileSet = new HashSet<Path>();
        if (Files.isDirectory(exportDir, new LinkOption[0])) {
            try {
                this.scanDirectory(exportDir, savedirProperties, targetSet, fileSet);
            }
            catch (IOException e) {
                logger.error(this.getLogHeader() + " Failed get directory list, " + exportDir, (Throwable)e);
                throw new TaskException("Failed get directory list, " + exportDir);
            }
        } else {
            Path exportDir2 = Paths.get(exportParentPath, exportDirectory + ".zip");
            if (Files.exists(exportDir2, new LinkOption[0])) {
                this.scanZip(exportDir2, savedirProperties, targetSet, fileSet);
            } else {
                logger.error(this.getLogHeader() + " No directory is found, " + exportDir);
                throw new TaskException("No directory is found, " + exportDir);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("remain=" + fileSet);
        }
        if (fileSet.size() == 0) {
            return;
        }
        if ("delete".equals(unlinkFileCommand)) {
            int processCount = 0;
            for (Path file : fileSet) {
                try {
                    Files.delete(file);
                    logger.info(this.getLogHeader() + " delete file : " + file);
                }
                catch (IOException e) {
                    logger.error("Failed to delete " + file, (Throwable)e);
                    int remain = fileSet.size() - processCount;
                    throw new TaskException("Failed to delete file " + file + ". Skipping the remaining " + remain + " files.");
                }
                ++processCount;
            }
        } else if (unlinkFileCommand != null && unlinkFileCommand.startsWith("move:") && moveToDir != null) {
            int processCount = 0;
            for (Path file : fileSet) {
                String modelId = file.getParent().getFileName().toString();
                Path dest = moveToDir.resolve(modelId);
                if (!Files.exists(dest, new LinkOption[0])) {
                    try {
                        Files.createDirectories(dest, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        logger.error("Failed to make directory, " + dest, (Throwable)e);
                    }
                }
                String fname = file.getFileName().toString();
                dest = dest.resolve(fname);
                try {
                    Files.move(file, dest, new CopyOption[0]);
                }
                catch (IOException e) {
                    logger.error("Failed to rename " + file + " to " + dest, (Throwable)e);
                    int remain = fileSet.size() - processCount;
                    throw new TaskException("Failed to rename file " + file + ". Skipping the remaining " + remain + " files.");
                }
                logger.info(this.getLogHeader() + " move file : " + dest);
                ++processCount;
            }
        } else {
            for (Path file : fileSet) {
                logger.info(this.getLogHeader() + " unlink file : " + file);
            }
        }
    }

    private Path getMoveToDir(String moveTo) {
        Path moveToDir = null;
        try {
            moveToDir = Paths.get(moveTo, new String[0]);
        }
        catch (InvalidPathException e) {
            logger.error("Illegal move unlink directory path " + moveTo, (Throwable)e);
            return null;
        }
        if (!Files.exists(moveToDir, new LinkOption[0])) {
            try {
                Files.createDirectories(moveToDir, new FileAttribute[0]);
                logger.warn(this.getLogHeader() + " move unlink directory " + moveTo + " is created.");
            }
            catch (IOException e) {
                logger.error("Failed to create move unlink directory " + moveToDir, (Throwable)e);
                return null;
            }
        }
        if (!Files.isDirectory(moveToDir, new LinkOption[0])) {
            logger.warn(this.getLogHeader() + " move unlink " + moveTo + " is not directory.");
            return null;
        }
        if (!Files.isWritable(moveToDir)) {
            logger.warn(this.getLogHeader() + " move unlink directory cannot write. " + moveTo);
            return null;
        }
        return moveToDir;
    }

    private void scanZip(Path exportDir, Properties savedirProperties, Set<String> targetSet, Set<Path> fileSet) {
        try (ZipFile zf = new ZipFile(exportDir.toFile().getAbsolutePath());){
            String target = null;
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                String name = zipEntry.getName();
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                String s = PathUtil.getModelIdFromDirectoryContent(name);
                if (zipEntry.isDirectory()) {
                    target = null;
                    if (!targetSet.contains(s)) continue;
                    String path = savedirProperties.getProperty("savedir." + s);
                    if (StringUtils.isBlank((CharSequence)path)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("savedir." + s + " is null. skip.");
                        continue;
                    }
                    Path dir = Paths.get(path, new String[0]);
                    if (logger.isDebugEnabled()) {
                        logger.debug("dir=" + dir);
                    }
                    if (Files.isDirectory(dir, new LinkOption[0])) {
                        try (Stream<Path> stream = Files.list(dir);){
                            stream.forEach(file -> fileSet.add((Path)file));
                        }
                    }
                    target = name;
                    continue;
                }
                if (target == null || !name.startsWith(target)) continue;
                this.scanZip(fileSet, zf, zipEntry);
            }
        }
        catch (IOException e) {
            logger.error(this.getLogHeader() + " failed to access zip file " + exportDir, (Throwable)e);
            throw new TaskException("Failed to access zip file " + exportDir + ", " + e.getMessage());
        }
    }

    private void scanZip(Set<Path> fileSet, ZipFile zf, ZipEntry zipEntry) {
        try (InputStream is = zf.getInputStream(zipEntry);){
            Document doc = this.readXML(is);
            this.removeExistFile(doc.getChildNodes(), fileSet);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error("Failed to read xml file in zip", (Throwable)e);
        }
    }

    private void scanDirectory(Path exportDir, Properties savedirProperties, Set<String> targetSet, Set<Path> fileSet) throws IOException {
        List savedirs;
        try (Stream<Path> stream = Files.list(exportDir);){
            savedirs = stream.map(path -> path.getFileName().toString()).filter(modelid -> targetSet.contains(modelid)).map(modelid -> savedirProperties.getProperty("savedir." + modelid)).filter(StringUtils::isNotBlank).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        for (Path savedir : savedirs) {
            Stream<Path> stream = Files.list(savedir);
            try {
                stream.forEach(file -> fileSet.add((Path)file));
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        stream = Files.list(exportDir);
        try {
            stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> this.removeUnlinkFile0((Path)path, fileSet));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void removeUnlinkFile0(Path targetDir, Set<Path> fileSet) {
        try (Stream<Path> stream = Files.list(targetDir);){
            stream.map(path -> this.readXML((Path)path)).filter(doc -> doc != null).forEach(doc -> this.removeExistFile(doc.getChildNodes(), fileSet));
        }
        catch (Exception e) {
            logger.error("Failed to read unlink directory", (Throwable)e);
        }
    }

    public void removeExistFile(NodeList nodeList, Set<Path> fileSet) {
        String sep = FileSystems.getDefault().getSeparator();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeName;
            Node node = nodeList.item(i);
            if (1 == node.getNodeType() && (nodeName = node.getNodeName()).endsWith("_jshfilename")) {
                String currentfilename = node.getTextContent();
                if (!sep.equals("\\")) {
                    currentfilename = currentfilename.replace("\\", sep);
                }
                if (!sep.equals("/")) {
                    currentfilename = currentfilename.replace("/", sep);
                }
                fileSet.remove(Paths.get(currentfilename, new String[0]));
            }
            if (!node.hasChildNodes()) continue;
            this.removeExistFile(node.getChildNodes(), fileSet);
        }
    }

    private Document readXML(Path f) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(f.toFile());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error("Failed to read xml file", (Throwable)e);
            return null;
        }
    }

    private Document readXML(InputStream istream) throws ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(istream);
    }
}

