/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppMode;
import jp.jasminesoft.jfc.JFCAppModeManager;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.job.JFCBaseJobBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionException;

public class MaintenanceModeJob
extends JFCBaseJobBean {
    private static final Logger logger = LogManager.getLogger((String)MaintenanceModeJob.class.getName());

    @Override
    public boolean useMaintenanceMode() {
        return false;
    }

    @Override
    public boolean isEnableStartInLimitBackgroundProcessStartMode() {
        return true;
    }

    @Override
    protected String executeInternal0(Map<String, Object> jobparamMap, Map<String, Object> dataMap, Map<String, Object> ctxMap, ActionParameter p) throws JobExecutionException {
        JFCAppMode mode;
        String appmodestr = (String)dataMap.get("appmode");
        if (StringUtils.isNotBlank((CharSequence)appmodestr)) {
            mode = JFCAppMode.valueOfIgnoreCase(appmodestr);
        } else {
            String modestr = (String)dataMap.get("mode");
            boolean isMaintenanceMode = modestr != null && "on".equals(modestr);
            mode = isMaintenanceMode ? JFCAppMode.Maintenance : JFCAppMode.Normal;
        }
        JFCAppModeManager appModeManager = (JFCAppModeManager)p.appctx.getBean(JFCAppModeManager.class);
        try {
            boolean isJobEnable = this.checkMaintenanceModeOption(dataMap, p, appModeManager);
            if (isJobEnable) {
                appModeManager.setLocalMode(mode);
                if (mode == JFCAppMode.Normal) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC90014), LogCodeManager.getMessage(LogCode.JFC90014, p.user, mode.toString()));
                } else {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC90013), LogCodeManager.getMessage(LogCode.JFC90013, p.user, mode.toString()));
                }
                ctxMap.put("jobComplete", new Boolean(true));
            }
        }
        catch (JobExecutionException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00911), LogCodeManager.getMessage(LogCode.JFC00911, p.user, StringUtils.defaultString((String)e.getMessage())), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00911), LogCodeManager.getMessage(LogCode.JFC00911, p.user, StringUtils.defaultString((String)e.getMessage())), e);
            throw new JobExecutionException(e.getMessage());
        }
        if (appModeManager.getMode() == JFCAppMode.Normal) {
            return "off";
        }
        return "on";
    }
}

