/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.ReportListService;
import jp.jasminesoft.jfc.app.ReportListServiceImpl;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.job.JFCBaseJobBean;
import jp.jasminesoft.jfc.job.JfcjobstatusRegistryService;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import jp.jasminesoft.jfc.repgen.JfcreporttemplateUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionException;

public class ReportListJob
extends JFCBaseJobBean {
    private static final Logger logger = LogManager.getLogger((String)ReportListJob.class.getName());
    private String reportListServiceBeanId;

    public String getReportListServiceBeanId() {
        return this.reportListServiceBeanId;
    }

    public void setReportListServiceBeanId(String beanid) {
        this.reportListServiceBeanId = beanid;
    }

    @Override
    protected String executeInternal0(Map<String, Object> jobparamMap, Map<String, Object> dataMap, Map<String, Object> ctxMap, ActionParameter p) throws JobExecutionException {
        ReportListService reportListService = (ReportListService)p.appctx.getBean(this.getReportListServiceBeanId(), ReportListService.class);
        Object ret = null;
        try {
            String outputdir;
            String action;
            String screentype;
            String templateid;
            int limit = 0;
            String limitStr = (String)dataMap.get("limit");
            if (limitStr != null) {
                try {
                    limit = Integer.parseInt(limitStr);
                }
                catch (NumberFormatException e) {
                    logger.error("failed execute. limit is number only");
                    throw new JobExecutionException();
                }
            }
            boolean printAllPage = false;
            String printAllPageStr = (String)dataMap.get("printAllPage");
            if (printAllPageStr != null && Boolean.valueOf(printAllPageStr).booleanValue()) {
                printAllPage = true;
            }
            if ((templateid = (String)dataMap.get("templateid")) != null) {
                ReportListService.ActionName actionName = reportListService.getActionName(templateid);
                if (actionName == null) {
                    logger.error("failed execute. nothing templateid action. use " + reportListService.getTemplateId());
                    throw new JobExecutionException();
                }
                screentype = actionName.getScreentype();
                action = actionName.getAction();
            } else {
                screentype = (String)dataMap.get("screentype");
                action = (String)dataMap.get("action");
                if (screentype == null || action == null) {
                    logger.error("failed execute. nothing templateid parameter. use " + reportListService.getTemplateId());
                    throw new JobExecutionException();
                }
            }
            JfcreporttemplateUtil.OutputType outputType = JfcreporttemplateUtil.OutputType.ServerFolderNoOverride;
            String override = (String)dataMap.get("override");
            if (override != null && Boolean.valueOf(override).booleanValue()) {
                outputType = JfcreporttemplateUtil.OutputType.ServerFolderOverride;
            }
            p.request.setAttribute(ReportListServiceImpl.OutputTypeAttributeName, (Object)outputType);
            HashMap<String, String> valueMap = new HashMap<String, String>();
            String outputfilename = (String)dataMap.get("outputfilename");
            if (outputfilename != null) {
                valueMap.put("outputfilename", outputfilename);
            }
            if ((outputdir = (String)dataMap.get("outputdir")) != null) {
                File odir = JFCUtils.createFile(outputdir);
                if (odir != null) {
                    outputdir = odir.toString();
                }
                valueMap.put("outputfolder", outputdir);
            }
            p.request.setAttribute(ReportListServiceImpl.ValueMapAttributeName, valueMap);
            String controllerBeanId = screentype + StringUtil.capFirst((String)reportListService.getModelId()) + "Controller";
            BaseController controller = (BaseController)p.appctx.getBean(controllerBeanId, BaseController.class);
            String controllerClassname = controller.getClass().getName();
            Object cond = dataMap.get("condition");
            FinderContext<Object> finderContext = reportListService.createFinderContext(p, screentype, cond);
            reportListService.do_print(p, finderContext, limit, printAllPage, controllerClassname, screentype, action);
            if (p.errors.sizeJfcerror() > 0) {
                logger.error("failed execute. occur error " + p.errors);
                throw new JobExecutionException();
            }
            File savedFile = (File)p.request.getAttribute("__jfc_report_ServerFolderSavedFile");
            IJfcjobstatus jobstatus = (IJfcjobstatus)p.request.getAttribute(IJfcjobstatus.class.getName());
            if (jobstatus != null && savedFile != null) {
                JfcjobstatusRegistryService service = (JfcjobstatusRegistryService)p.appctx.getBean(JfcjobstatusRegistryService.class);
                service.addInfoFilename(jobstatus, "outputfilename", savedFile.getName(), savedFile);
            }
            logger.info(JFCUtils.logmsg(p, "finished. outputfilename=" + savedFile));
        }
        catch (ServletException e) {
            logger.warn(JFCUtils.logmsg(p, e.getMessage()), (Throwable)e);
            throw new JobExecutionException();
        }
        catch (IOException e) {
            logger.warn(JFCUtils.logmsg(p, e.getMessage()), (Throwable)e);
            throw new JobExecutionException();
        }
        catch (JobExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn(JFCUtils.logmsg(p, e.getMessage()), (Throwable)e);
            throw e;
        }
        return ret == null ? null : ret.toString();
    }
}

