/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.master.app;

import java.security.Permission;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbProcessBean;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ProcessBean;
import jp.jasminesoft.jfc.TableConfigManager;
import jp.jasminesoft.jfc.model.master.Master;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class ShowListMasterProcessBean
extends DbProcessBean {
    private static final Logger logger = LogManager.getLogger((String)ShowListMasterProcessBean.class.getName());

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("all", "all");
    }

    public ShowListMasterProcessBean() {
    }

    public ShowListMasterProcessBean(ActionParameter p) {
        super(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run() {
        List<Master> list = null;
        StringBuffer errmsg = new StringBuffer();
        String tablename = (String)this.anotherParam.get("tablename");
        if (tablename == null) {
            return "tablename is null.";
        }
        Connection con = null;
        try {
            con = JFCUtils.getConnection();
        }
        catch (Exception e) {
            return errmsg.toString();
        }
        try {
            list = this.getMasterList(con, tablename);
        }
        catch (SQLException e) {
            errmsg.append(this.convertErrorMessage(e));
            logger.warn(errmsg.toString(), (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.warn("failed to close connection", (Throwable)e);
                }
            }
        }
        if (errmsg.length() > 0) {
            return errmsg.toString();
        }
        return list;
    }

    public List<Master> getMasterList(Connection con, String tablename) throws SQLException {
        String expression = this.createExpression(tablename);
        return this.getMasterListByExpression(con, expression);
    }

    protected String createExpression(String tablename) {
        TableConfigManager config = TableConfigManager.getInstance();
        String quoteid = config.getQuoteId();
        String whereexpression = ShowListMasterProcessBean.createSQL(config.getQuoteId(), config.getQuoteWhere(), config.getQuoteIdInWhere());
        String expression = "SELECT " + quoteid + "priority" + quoteid + "," + quoteid + "valid" + quoteid + "," + quoteid + "content" + quoteid + "," + quoteid + "id" + quoteid + " FROM " + quoteid + tablename + quoteid + whereexpression;
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Master> getMasterListByExpression(Connection con, String expression) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(expression);
            ArrayList<Master> list = new ArrayList<Master>();
            while (rs.next()) {
                Master master = new Master();
                int priority = rs.getInt(1);
                if (rs.wasNull()) {
                    master.setPriority(null);
                } else {
                    master.setPriority(priority);
                }
                master.setValid(rs.getString(2));
                master.setContent(rs.getString(3));
                master.setId(rs.getInt(4));
                list.add(master);
            }
            ArrayList<Master> arrayList = list;
            return arrayList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warn("failed to close resultset", (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warn("failed to close statement", (Throwable)e);
                }
            }
            StringBuffer debugmsg = new StringBuffer("expression:");
            debugmsg.append(expression);
            logger.debug(debugmsg.toString());
        }
    }

    protected static String createSQL(String quoteId, String quoteWhere, String quoteIdInWhere) {
        StringBuffer sb = new StringBuffer();
        boolean isfirstexpression = true;
        isfirstexpression = ShowListMasterProcessBean.outputWhereConjuction(isfirstexpression, sb, quoteWhere);
        sb.append(quoteIdInWhere);
        sb.append("id");
        sb.append(quoteIdInWhere);
        sb.append(" >= 0 ");
        ShowListMasterProcessBean.outputWhereEnd(isfirstexpression, sb, quoteWhere);
        sb.append("ORDER BY ");
        sb.append(quoteId);
        sb.append("id");
        sb.append(quoteId);
        return sb.toString();
    }

    private static boolean outputWhereConjuction(boolean isfirstexpression, StringBuffer sb, String quoteWhere) {
        if (isfirstexpression) {
            sb.append(" WHERE ");
            sb.append(quoteWhere);
            isfirstexpression = false;
        } else {
            sb.append("AND ");
        }
        return isfirstexpression;
    }

    private static void outputWhereEnd(boolean isfirstexpression, StringBuffer sb, String quoteWhere) {
        if (!isfirstexpression) {
            sb.append(quoteWhere);
            sb.append(" ");
        }
    }

    public static void main(String[] args) {
        ActionParameter p = null;
        try {
            p = DbProcessBean.createActionParameter(args[0], args[1]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("ant -f testpbean.xml");
            System.exit(1);
        }
        if (p == null) {
            System.err.println("Failed to create test parameter object.");
            System.exit(1);
        }
        ShowListMasterProcessBean pbean = new ShowListMasterProcessBean(p);
        pbean.prepare_test();
        Object o = ((ProcessBean)pbean).run();
        pbean.release();
        System.out.println(o);
        System.out.println("finished.");
    }
}

