/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.migratedb;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import jp.jasminesoft.jfc.migratedb.AbortException;
import jp.jasminesoft.jfc.migratedb.DBInfo;
import jp.jasminesoft.jfc.migratedb.command.CleanCommand;
import jp.jasminesoft.jfc.migratedb.command.Command;
import jp.jasminesoft.jfc.migratedb.command.InitCommand;
import jp.jasminesoft.jfc.migratedb.command.MigrateCommand;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class App {
    private static final Logger logger = LogManager.getLogger(App.class);

    public static void main(String[] args) {
        if (!App.isArgsValid(args)) {
            App.printUsage();
            System.exit(1);
        }
        try {
            DBInfo dbInfo = DBInfo.load();
            Path migratedbDir = Paths.get(args[1], new String[0]);
            Command command = App.getCommand(args[2]);
            command.execute(dbInfo, migratedbDir);
        }
        catch (AbortException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean isArgsValid(String[] args) {
        if (args.length < 3) {
            return false;
        }
        if (!"-d".equals(args[0])) {
            return false;
        }
        Path path = Paths.get(args[1], new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            logger.error("can't find migratedb_dir : " + path);
            return false;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            logger.error("migratedb_dir is not a directory : " + path);
            return false;
        }
        switch (args[2]) {
            case "init": 
            case "migrate": 
            case "clean": {
                return true;
            }
        }
        return false;
    }

    private static void printUsage() {
        System.out.println("usage : java -cp ... jp.jasminesoft.jfc.migratedb.App -d <migratedb_dir> <command>");
        System.out.println("command is :");
        System.out.println("    init - initialize migration history table.");
        System.out.println("    migrate - migrate database schema.");
        System.out.println("    clean - drop migration history table.");
    }

    private static Command getCommand(String command) {
        switch (command) {
            case "init": {
                return new InitCommand();
            }
            case "migrate": {
                return new MigrateCommand();
            }
            case "clean": {
                return new CleanCommand();
            }
        }
        throw new AbortException("unknown command: " + command);
    }
}

