/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.migratedb;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.core.charset.Charsets;
import jp.jasminesoft.jfc.core.util.FileUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.migratedb.AbortException;
import jp.jasminesoft.jfc.migratedb.Version;

public class DDLHistFile {
    private static final String ALL_SQL_FILE = "all.sql";
    private static final String DDL_HIST_DIR = "ddl_hist";
    private Path path;

    public static DDLHistFile create(Version version, Path migratedbDir, String allSQLContent) {
        IOExceptionRunner runner;
        Path ddlHistDir = migratedbDir.resolve(DDL_HIST_DIR);
        Path newHistFile = ddlHistDir.resolve(version.toString() + ".sql");
        if (StringUtils.isNotBlank((CharSequence)allSQLContent)) {
            runner = () -> FileUtils.write((File)newHistFile.toFile(), (CharSequence)allSQLContent, (String)Charsets.UTF8.toString());
        } else {
            Path allSQL = migratedbDir.resolve(ALL_SQL_FILE);
            if (Files.exists(allSQL, new LinkOption[0])) {
                runner = () -> Files.copy(allSQL, newHistFile, new CopyOption[0]);
            } else {
                throw new AbortException("Error: cannot found all.sql in " + migratedbDir);
            }
        }
        try {
            if (Files.notExists(ddlHistDir, new LinkOption[0])) {
                Files.createDirectory(ddlHistDir, new FileAttribute[0]);
            }
            runner.run();
        }
        catch (IOException ex) {
            throw new AbortException("Error: cannot write all SQL Content to " + newHistFile, ex);
        }
        return new DDLHistFile(newHistFile);
    }

    public static String findLastPath(Path ddlHistDir, String pathMatcher) throws IOException {
        String candidate = null;
        FileSystem fs = FileSystems.getDefault();
        PathMatcher matcher = fs.getPathMatcher(pathMatcher);
        try (Stream<Path> filelist = Files.list(ddlHistDir);){
            Optional<String> maxDDL = filelist.filter(matcher::matches).map(path -> path.getFileName().toString()).max(Comparator.naturalOrder());
            candidate = maxDDL.orElse(null);
        }
        return candidate;
    }

    public static DDLHistFile findLast(Path migratedbDir) {
        String candidate;
        Path ddlHistDir = migratedbDir.resolve(DDL_HIST_DIR);
        if (Files.notExists(ddlHistDir, new LinkOption[0])) {
            throw new AbortException("Error: can't find ddl_hist directory: " + ddlHistDir);
        }
        try {
            candidate = DDLHistFile.findLastPath(ddlHistDir, "glob:**/*.sql");
        }
        catch (IOException ex) {
            throw new AbortException("Error: can't find previous version", ex);
        }
        if (candidate == null) {
            throw new AbortException("Error: can't find previous version");
        }
        return new DDLHistFile(ddlHistDir.resolve(candidate));
    }

    private DDLHistFile(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    static interface IOExceptionRunner {
        public void run() throws IOException;
    }
}

