/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.migratedb.command;

import java.nio.file.Path;
import jp.jasminesoft.jfc.migratedb.AbortException;
import jp.jasminesoft.jfc.migratedb.DBInfo;
import jp.jasminesoft.jfc.migratedb.DDLHistFile;
import jp.jasminesoft.jfc.migratedb.Version;
import jp.jasminesoft.jfc.migratedb.command.Command;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;

public class InitCommand
implements Command {
    private static final Logger logger = LogManager.getLogger((String)InitCommand.class.getName());

    @Override
    public Version execute(DBInfo dbInfo, Path migratedbDir) {
        return this.execute(dbInfo, migratedbDir, null);
    }

    public Version execute(DBInfo dbInfo, Path migratedbDir, String allSQLContent) {
        logger.info("start init");
        Version version = new Version();
        logger.info("version: " + version);
        try {
            Flyway flyway = Flyway.configure().dataSource(dbInfo.dataSource()).table(dbInfo.table()).cleanDisabled(true).baselineVersion(version.toString()).load();
            flyway.baseline();
        }
        catch (FlywayException ex) {
            throw new AbortException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u79fb\u884c\u306e\u521d\u671f\u5316\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        DDLHistFile.create(version, migratedbDir, allSQLContent);
        logger.info("end init");
        return version;
    }
}

