/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RPathList {
    private RPathList parent_;
    private String context_ = "/";
    private Map paths_;

    public RPathList() {
        this.paths_ = new HashMap();
    }

    public RPathList(Map paths) {
        this.paths_ = paths;
    }

    public RPathList newContext(String context) {
        RPathList newPathList = new RPathList();
        newPathList.parent_ = this;
        newPathList.context_ = this.context_ + context + "/";
        return newPathList;
    }

    public RPathList[] getRPathLists(String key) {
        ArrayList list = new ArrayList();
        this._makeRPathList(key, list);
        RPathList[] result = new RPathList[list.size()];
        return list.toArray(result);
    }

    private void _makeRPathList(String key, List list) {
        String start = this.context_ + key + "[";
        int index = 1;
        while (true) {
            ArrayList pathNames = new ArrayList();
            this._findPathNames(start + index + "]", pathNames);
            if (pathNames.size() == 0) break;
            if (!this._isNullInput(pathNames)) {
                list.add(this._makeRPathList(pathNames, key));
            }
            ++index;
        }
    }

    private boolean _isNullInput(List pathNames) {
        int size = pathNames.size();
        for (int i = 0; i < size; ++i) {
            String value = this._findValue((String)pathNames.get(i));
            if (value == null || "".equals(value)) continue;
            return false;
        }
        return true;
    }

    private void _findPathNames(String start, List list) {
        this._findPathNames(start, list, false);
    }

    private void _findPathNames(String start, List list, boolean isCompleteMatch) {
        Set paths = this.paths_.keySet();
        for (String path : paths) {
            if (isCompleteMatch) {
                if (!path.equals(start)) continue;
                list.add(path);
                continue;
            }
            if (!path.startsWith(start)) continue;
            list.add(path);
        }
        if (this.parent_ != null) {
            this.parent_._findPathNames(start, list, isCompleteMatch);
        }
    }

    private RPathList _makeRPathList(List pathnames, String key) {
        RPathList newPathList = new RPathList();
        newPathList.parent_ = this;
        newPathList.context_ = this.context_;
        String basePath = this.context_ + key;
        int index1 = basePath.length();
        int index2 = index1 + "[".length();
        int size = pathnames.size();
        for (int i = 0; i < size; ++i) {
            String path = (String)pathnames.get(i);
            int index3 = path.indexOf(93, index2);
            String newPath = index3 + 1 == path.length() ? basePath : basePath + "/" + path.substring(index3 + "]/".length());
            newPathList.paths_.put(newPath, this._findValue(path));
        }
        return newPathList;
    }

    public boolean hasNode(String key) {
        ArrayList list = new ArrayList();
        this._findPathNames(this.context_ + key, list, true);
        return list.size() > 0;
    }

    public boolean hasValue(String key) {
        return this.getValue(key) != null;
    }

    public String getValue(String key) {
        String fullKey = this._getFullKey(key);
        Object value = this.paths_.get(fullKey);
        if ("".equals(value)) {
            value = null;
        }
        if (value == null) {
            if (this.parent_ != null) {
                return this.parent_._findValue(fullKey);
            }
            return null;
        }
        return value.toString();
    }

    private String _getFullKey(String key) {
        if ("".equals(key)) {
            return this.context_.substring(0, this.context_.length() - 1);
        }
        return this.context_ + key;
    }

    public String[] getValues(String key) {
        String numberedKey;
        String value = this.getValue(key);
        if (value != null) {
            return new String[]{value};
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        while ((value = this.getValue(numberedKey = key + "[" + i + "]")) != null) {
            list.add(value);
            ++i;
        }
        String[] result = new String[list.size()];
        return list.toArray(result);
    }

    public String[] getValues_NEW(String key) {
        String value = this.getValue(key);
        if (value != null) {
            return new String[]{value};
        }
        int maxIndex = this._findMaxIndex(key);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= maxIndex; ++i) {
            String numberedKey = key + "[" + i + "]";
            value = this.getValue(numberedKey);
            list.add(value);
        }
        String[] result = new String[list.size()];
        return list.toArray(result);
    }

    private int _findMaxIndex(String key) {
        String[] keys = this._getKeys();
        int maxIndex = 0;
        for (int i = 0; i < keys.length; ++i) {
            int pos;
            String tmp;
            String candidate = keys[i];
            if (!candidate.startsWith(key) || (tmp = candidate.substring(0, key.length())).charAt(0) != '[' || (pos = tmp.indexOf(93)) == -1 || tmp.length() != pos + 1) continue;
            try {
                int curIndex = Integer.parseInt(tmp.substring(1, pos));
                if (curIndex < maxIndex || this.getValue(key) == null) continue;
                maxIndex = curIndex;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return maxIndex;
    }

    private String[] _getKeys() {
        Object[] keyObjects = this.paths_.keySet().toArray();
        String[] keys = new String[keyObjects.length];
        for (int i = 0; i < keyObjects.length; ++i) {
            keys[i] = keyObjects[i].toString();
        }
        return keys;
    }

    private String _findValue(String key) {
        Object value = this.paths_.get(key);
        if ("".equals(value)) {
            value = null;
        }
        if (value == null) {
            if (this.parent_ != null) {
                return this.parent_._findValue(key);
            }
            return null;
        }
        return value.toString();
    }

    public static boolean isLeaf(String path) {
        return path.indexOf("/") == -1;
    }

    public static String getCurrentContext(String path) {
        int index = path.indexOf("/");
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String getCurrentContextName(String path) {
        int index = path.indexOf("[");
        if (index == -1) {
            index = path.indexOf("/");
        }
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public static int getCurrentContextIndex(String path) {
        String context = RPathList.getCurrentContext(path);
        int index = path.indexOf("[");
        if (index == -1) {
            return -1;
        }
        int index2 = path.indexOf("]");
        String number = path.substring(index + 1, index2);
        return Integer.parseInt(number) - 1;
    }

    public static String getNextPath(String path) {
        int index = path.indexOf("/");
        if (index == -1) {
            return null;
        }
        return path.substring(index + 1);
    }
}

