/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog;

import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.model.systemlog.IllegalSystemlogFormatException;
import jp.jasminesoft.jfc.model.systemlog.SystemlogCondition;

public class Systemlog
implements Serializable {
    private static final long serialVersionUID = 3992650404962659758L;
    private String dateTime;
    private Date dateTimeObj;
    private String type;
    private String classname;
    private String methodname;
    private String username;
    private String browser;
    private String message;
    private String command;
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public Systemlog(String line) throws IllegalSystemlogFormatException {
        this.parse(line);
    }

    protected void parse(String line) throws IllegalSystemlogFormatException {
        int index;
        if (line == null || line.length() == 0) {
            this.message = "";
            return;
        }
        int date_fmt_length = DATETIME_FORMAT.length();
        if (line.length() < date_fmt_length) {
            this.message = line;
            return;
        }
        SimpleDateFormat sf = new SimpleDateFormat(DATETIME_FORMAT);
        String p1 = line.substring(0, date_fmt_length);
        Date d = sf.parse(p1, new ParsePosition(0));
        if (d == null) {
            this.message = line;
            return;
        }
        this.dateTimeObj = d;
        this.dateTime = p1;
        int nextpoint = date_fmt_length + 1;
        if (line.length() < nextpoint) {
            this.message = line;
            return;
        }
        String p2 = line.substring(nextpoint);
        if (p2.charAt(0) != '[') {
            this.message = p2;
            return;
        }
        StringBuffer sb = new StringBuffer();
        boolean mode = false;
        for (int i = 0; i < p2.length(); ++i) {
            char c = p2.charAt(i);
            if (c == '[') {
                mode = true;
                continue;
            }
            if (c == ']') {
                mode = false;
                nextpoint += i + 1;
                break;
            }
            if (!mode) continue;
            sb.append(c);
        }
        StringTokenizer st = new StringTokenizer(sb.toString(), " ");
        try {
            this.type = st.nextToken();
            this.classname = st.nextToken();
            this.methodname = st.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        String p3 = line.substring(nextpoint).trim();
        if (p3.length() > 0 && p3.charAt(0) == '(') {
            StringBuffer usb = new StringBuffer();
            for (int i = 1; i < p3.length(); ++i) {
                char c = p3.charAt(i);
                if (c == ')') {
                    nextpoint = i + 1;
                    break;
                }
                usb.append(c);
            }
            this.username = usb.toString();
            int sep = this.username.lastIndexOf("|");
            if (sep > 0) {
                this.browser = this.username.substring(sep + 1);
                this.username = this.username.substring(0, sep);
            }
            p3 = p3.substring(nextpoint).trim();
        }
        if ((index = p3.indexOf("|CMD_")) > 0) {
            this.message = p3.substring(0, index);
            this.command = p3.substring(index + 1 + "CMD_".length());
        } else {
            this.message = p3;
        }
    }

    public String getDateTimeAsString() {
        return this.dateTime != null ? this.dateTime : "";
    }

    public Date getDateTime() {
        return this.dateTimeObj;
    }

    public String getType() {
        return this.type != null ? this.type : "";
    }

    public String getClassname() {
        return this.classname != null ? this.classname : "";
    }

    public String getMethodname() {
        return this.methodname != null ? this.methodname : "";
    }

    public String getUsername() {
        return this.username != null ? this.username : "";
    }

    public String getBrowser() {
        return this.browser != null ? this.browser : "";
    }

    public String getMessage() {
        return this.message != null ? this.message : "";
    }

    public String getCommand() {
        return this.command != null ? this.command : "";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.dateTime != null && this.dateTime.length() > 0) {
            sb.append(this.dateTime);
            sb.append(" ");
        }
        if (this.type != null && this.type.length() > 0) {
            sb.append("[");
            sb.append(this.type);
            sb.append(" ");
            if (this.classname != null && this.classname.length() > 0) {
                sb.append(this.classname);
                sb.append(" ");
            }
            if (this.methodname != null && this.methodname.length() > 0) {
                sb.append(this.methodname);
            }
            sb.append("] ");
        }
        if (this.username != null && this.username.length() > 0) {
            sb.append("(");
            sb.append(this.username);
            if (this.browser != null && this.browser.length() > 0) {
                sb.append("|").append(this.browser);
            }
            sb.append(") ");
        }
        if (this.message != null && this.message.length() > 0) {
            sb.append(this.message);
        }
        return sb.toString();
    }

    public boolean match(SystemlogCondition cond) {
        int i;
        String[] keywords;
        String currentDateStr;
        SimpleDateFormat sfdate;
        String targetDateStr;
        if (cond == null) {
            return true;
        }
        Date beginLogDate = cond.getBeginLogDate();
        if (beginLogDate != null && this.dateTimeObj != null && beginLogDate.compareTo(this.dateTimeObj) > 0) {
            return false;
        }
        Date endLogDate = cond.getEndLogDate();
        if (endLogDate != null && this.dateTimeObj != null && endLogDate.compareTo(this.dateTimeObj) < 0) {
            return false;
        }
        Date targetDate = cond.getTargetDay();
        if (targetDate != null && this.dateTimeObj != null && !(targetDateStr = (sfdate = new SimpleDateFormat(DATE_FORMAT)).format(targetDate)).equals(currentDateStr = sfdate.format(this.dateTimeObj))) {
            return false;
        }
        String logType = cond.getLogType();
        if (logType != null && logType.length() > 0) {
            if (logType.trim().indexOf(" ") > 0) {
                String[] logTypes = logType.split(" ");
                boolean bingo = false;
                for (String s : logTypes) {
                    if (!this.getType().equals(s)) continue;
                    bingo = true;
                    break;
                }
                return bingo;
            }
            if (!this.getType().equals(logType)) {
                return false;
            }
        }
        if ((keywords = cond.getKeywordAsStrArray()) == null || keywords.length == 0) {
            return true;
        }
        boolean OR = false;
        if (keywords[0].equals("OR")) {
            OR = true;
        }
        String target = null;
        boolean bingo = true;
        int n = i = OR ? 1 : 0;
        while (i < keywords.length) {
            String keyword = keywords[i];
            target = this.getClassname();
            if (target.indexOf(keyword) >= 0) {
                if (OR) {
                    break;
                }
            } else {
                target = this.getMethodname();
                if (target.indexOf(keyword) >= 0) {
                    if (OR) {
                        break;
                    }
                } else {
                    target = this.getUsername();
                    if (target.indexOf(keyword) >= 0) {
                        if (OR) {
                            break;
                        }
                    } else {
                        target = this.getMessage();
                        if (target.indexOf(keyword) >= 0) {
                            if (OR) {
                                break;
                            }
                        } else {
                            target = this.getCommand();
                            if (target.indexOf(keyword) >= 0) {
                                if (OR) {
                                    break;
                                }
                            } else {
                                if (!OR) {
                                    bingo = false;
                                    break;
                                }
                                if (i == keywords.length - 1) {
                                    bingo = false;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return bingo;
    }

    public static void main(String[] args) {
        String s = "2004-10-06 10:42:41 [WARN BatchLib] (user@user) java.util.MissingResourceException: Can't find resource for bundle java.util.PropertyResourceBundle, key MAIL_TITLE_RESTORE_ERROR";
        Systemlog log = new Systemlog(s);
        System.out.println("Date      :" + log.getDateTimeAsString());
        System.out.println("Type      :" + log.getType());
        System.out.println("Classname :" + log.getClassname());
        System.out.println("Methodname:" + log.getMethodname());
        System.out.println("Username  :" + log.getUsername());
        System.out.println("Message   :" + log.getMessage());
        System.out.println("Command   :" + log.getCommand());
    }
}

