/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog;

import java.io.Serializable;
import java.util.Date;
import jp.jasminesoft.jfc.model.systemlog.SystemlogKind;
import jp.jasminesoft.jfc.model.systemlog.filter.LogFilter;
import jp.jasminesoft.jfc.model.systemlog.filter.LogFilterChain;
import jp.jasminesoft.util.ExcelFunction;

public class SystemlogCondition
implements Serializable {
    private static final long serialVersionUID = 750605339066808912L;
    private int beginNumber;
    private int endNumber;
    private int count;
    private Date targetDay;
    private SystemlogKind logkind;
    private String logType;
    private String keyword;
    private Date beginLogDate;
    private Date endLogDate;
    private ReadStatus readstatus;
    private LogFilterChain logFilterChain = new LogFilterChain();

    public SystemlogCondition() {
        this.resetBeginEndNumbers();
    }

    private void resetBeginEndNumbers() {
        this.beginNumber = -1;
        this.endNumber = -1;
    }

    public final void setBeginNumber(int beginNumber) {
        this.beginNumber = beginNumber;
    }

    public final int getBeginNumber() {
        return this.beginNumber;
    }

    public final void setEndNumber(int endNumber) {
        this.endNumber = endNumber;
    }

    public final int getEndNumber() {
        return this.endNumber;
    }

    public final void setCount(int count) {
        this.count = count;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setLogKind(SystemlogKind logkind) {
        boolean updateFlag = false;
        if (logkind != null) {
            if (this.logkind != null) {
                if (!logkind.equals(this.logkind)) {
                    updateFlag = true;
                }
            } else {
                updateFlag = true;
            }
        }
        if (updateFlag) {
            this.logkind = logkind;
            this.resetBeginEndNumbers();
        }
    }

    public SystemlogKind getLogKind() {
        return this.logkind;
    }

    public final void setTargetDay(Date targetDay) {
        boolean updateFlag = false;
        if (targetDay != null) {
            if (this.targetDay != null) {
                if (!targetDay.equals(this.targetDay)) {
                    updateFlag = true;
                }
            } else {
                updateFlag = true;
            }
        }
        if (updateFlag && targetDay != null) {
            this.targetDay = (Date)targetDay.clone();
        }
    }

    public final Date getTargetDay() {
        if (this.targetDay != null) {
            return (Date)this.targetDay.clone();
        }
        return null;
    }

    public final void setLogType(String logType) {
        boolean updateFlag = false;
        if (logType != null) {
            if (this.logType != null) {
                if (!logType.equals(this.logType)) {
                    updateFlag = true;
                }
            } else {
                updateFlag = true;
            }
        }
        if (updateFlag) {
            this.logType = logType;
            this.resetBeginEndNumbers();
        }
    }

    public final String getLogType() {
        return this.logType;
    }

    public final void setKeyword(String keyword) {
        boolean updateFlag = false;
        if (keyword != null && keyword.length() > 0) {
            if (this.keyword != null) {
                if (!keyword.equals(this.keyword)) {
                    updateFlag = true;
                }
            } else {
                updateFlag = true;
            }
        } else {
            updateFlag = true;
        }
        if (updateFlag) {
            this.keyword = keyword;
        }
    }

    public final String getKeyword() {
        if (this.keyword == null || this.keyword.length() == 0) {
            return "";
        }
        return this.keyword;
    }

    public final String[] getKeywordAsStrArray() {
        if (this.keyword == null || this.keyword.length() == 0) {
            return new String[0];
        }
        return this.keyword.split(" ");
    }

    public final void setReadStatus(ReadStatus readstatus) {
        this.readstatus = readstatus;
    }

    public final ReadStatus getReadStatus() {
        return this.readstatus;
    }

    public final void setBeginLogDate(Date beginLogDate) {
        this.beginLogDate = beginLogDate;
    }

    public final Date getBeginLogDate() {
        return this.beginLogDate;
    }

    public final void setEndLogDate(Date endLogDate) {
        this.endLogDate = endLogDate;
    }

    public final Date getEndLogDate() {
        return this.endLogDate;
    }

    public void addLogFilter(LogFilter filter) {
        this.logFilterChain.addFilter(filter);
    }

    public LogFilter getLogFilter() {
        return this.logFilterChain;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<cond>").append("<logkind>").append(this.logkind).append("</logkind>").append("<targetDay>").append(ExcelFunction.TEXT((Date)this.targetDay, (String)"yyyy-MM-dd")).append("</targetDay>").append("<beginLogDate>").append(ExcelFunction.TEXT((Date)this.beginLogDate, (String)"yyyy-MM-dd hh:mm:ss")).append("</beginLogDate>").append("<endLogDate>").append(ExcelFunction.TEXT((Date)this.endLogDate, (String)"yyyy-MM-dd hh:mm:ss")).append("</endLogDate>").append("<beginNumber>").append(this.beginNumber).append("</beginNumber>").append("<endNumber>").append(this.endNumber).append("</endNumber>").append("<count>").append(this.count).append("</count>").append("<logType>").append(this.logType).append("</logType>");
        if (this.keyword != null && this.keyword.length() > 0) {
            sb.append("<keyword>").append(this.keyword).append("</keyword>");
        }
        sb.append("<status>").append((Object)this.readstatus).append("</status>").append("</cond>");
        return sb.toString();
    }

    public static enum ReadStatus {
        Success,
        UnsetFilename,
        NotExistsFile,
        CantReadFile,
        ReadError;

    }
}

