/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog;

import java.io.IOException;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.model.systemlog.LogCodeCondition;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.SystemlogCondition;
import jp.jasminesoft.jfc.model.systemlog.SystemlogKind;
import jp.jasminesoft.jfc.model.systemlog.analyzer.UserAction;

public interface SystemlogManager {
    public SystemlogKind createLogKind(Map<String, String> var1);

    public Date getNowDate();

    public List<String> getLogDataString(Date var1, int var2, SystemlogKind var3);

    public Systemlog[] getLogData(SystemlogCondition var1);

    public Systemlog[] getLogData(SystemlogCondition var1, int var2);

    public Stream<LogEntry> getLogEntry(Date var1, Date var2, SystemlogKind var3);

    public Stream<LogEntry> getLogEntry(Date var1, SystemlogKind var2);

    public List<UserAction> getActivities(String var1, LocalDate var2);

    public List<String> getUserIds(LocalDate var1);

    public int[] getCountByMonth(Date var1, Date var2, LogCodeCondition var3);

    public int[] getCountByDay(Date var1, Date var2, LogCodeCondition var3);

    public SystemlogKind getDefaultLogKinds();

    public SystemlogKind[] getLogKinds();

    public static interface LogEntry {
        public Date targetDate();

        public SystemlogKind systemlogKind();

        public String filename();

        public long length();

        public long lastModified();

        public boolean useCache();

        public Stream<Systemlog> stream() throws IOException;

        public void forEach(Consumer<Systemlog> var1) throws IOException;
    }
}

