/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.model.systemlog.IllegalSystemlogFormatException;
import jp.jasminesoft.jfc.model.systemlog.LogCodeCondition;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.SystemlogCondition;
import jp.jasminesoft.jfc.model.systemlog.SystemlogKind;
import jp.jasminesoft.jfc.model.systemlog.SystemlogManager;
import jp.jasminesoft.jfc.model.systemlog.analyzer.LogAnalyzer;
import jp.jasminesoft.jfc.model.systemlog.analyzer.UserAction;
import jp.jasminesoft.jfc.model.systemlog.util.TimeSpanUtil;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.appender.rolling.RolloverFrequency;
import org.apache.logging.log4j.core.config.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class SystemlogManagerLog4j2Impl
implements SystemlogManager {
    private static final Logger logger = LogManager.getLogger((String)SystemlogManagerLog4j2Impl.class.getName());
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final Charset DEFAULT_CHARSET = Charset.forName(DEFAULT_ENCODING);
    private static final String DEFAULT_FILENAME = ".." + File.separator + "logs" + File.separator + "system.log";
    private static final int DEFAULT_LIMIT_SIZE = 65536;
    private static final String DEFAULT_APPENDARID = "F";
    private static final String DEFAULT_ID = "webaccesslog";
    private static final String DEFAULT_LABELRKEY = "__jfc_common.logkind.webaccesslog";
    private static final SystemlogKindImpl DEFAULT_LOG_KIND = new SystemlogKindImpl("F", "webaccesslog", "__jfc_common.logkind.webaccesslog", DEFAULT_FILENAME, DEFAULT_FILENAME + ".%d{yyyy-MM-dd}_%i", StandardCharsets.UTF_8);
    @Autowired
    private LogAnalyzer logAnalyzer;
    @Value(value="${wagby.systemlogmanagerlog4j2impl.filenamepatterntype:1}")
    private int FILENAMEPATTERNTYPE;
    private SystemlogKindImpl[] logKinds;
    private SystemlogKindImpl defaultLogKinds;

    @PostConstruct
    private void postConstruct() {
        this.logKinds = this.readLogKinds();
        if (this.logKinds.length > 0) {
            SystemlogKindImpl logkind1 = null;
            for (SystemlogKindImpl logkind : this.logKinds) {
                if (!logkind.getAppendarId().equals(DEFAULT_LOG_KIND.getAppendarId())) continue;
                logkind1 = logkind;
                break;
            }
            if (logkind1 != null) {
                this.defaultLogKinds = logkind1;
            } else {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00105), LogCodeManager.getMessage(LogCode.JFC00105, DEFAULT_APPENDARID, "log4j2.xml"));
                this.defaultLogKinds = this.logKinds[0];
            }
        }
        this.logAnalyzer.setSystemlogManager(this);
        this.logAnalyzer.setSystemlogKind(this.getDefaultLogKinds());
    }

    private LogAnalyzer getLogAnalyzer() {
        return this.logAnalyzer;
    }

    public SystemlogKindImpl[] getLogKinds() {
        return this.logKinds;
    }

    @Override
    public SystemlogKindImpl getDefaultLogKinds() {
        return this.defaultLogKinds;
    }

    private SystemlogManagerLog4j2Impl() {
    }

    @Override
    public SystemlogKind createLogKind(Map<String, String> paramMap) {
        SystemlogKindImpl defaultLogKind;
        String filename = paramMap.get("filename");
        String filepattern = paramMap.get("filepattern");
        String charsets = paramMap.get("charset");
        Charset charset = DEFAULT_CHARSET;
        if (StringUtils.isNotBlank((CharSequence)charsets)) {
            charset = Charset.forName(charsets);
        }
        if (SystemlogManagerLog4j2Impl.compare((defaultLogKind = this.getDefaultLogKinds()).getLogfilename(), filename) && SystemlogManagerLog4j2Impl.compare(defaultLogKind.getFilepattern(), filepattern) && defaultLogKind.getCharset().equals(charset)) {
            return defaultLogKind;
        }
        String id = "default";
        return new SystemlogKindImpl("default", "default", null, filename, filepattern, charset);
    }

    @Override
    public Date getNowDate() {
        return this.getDate(new Date());
    }

    private Date getDate(Date d) {
        Calendar calnow = Calendar.getInstance();
        calnow.setTime(d);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, calnow.get(1));
        cal.set(2, calnow.get(2));
        cal.set(5, calnow.get(5));
        return cal.getTime();
    }

    @Override
    public List<String> getLogDataString(Date conddate, int limitSize, SystemlogKind logkind) {
        SystemlogCondition.ReadStatus readstatus;
        SystemlogKindImpl logkind1;
        logger.info("limitSize " + limitSize);
        logger.info("conddate " + conddate);
        if (limitSize < 0 || limitSize > 65536) {
            limitSize = 65536;
        }
        if (logkind == null) {
            logkind1 = this.getDefaultLogKinds();
        } else if (logkind instanceof SystemlogKindImpl) {
            logkind1 = (SystemlogKindImpl)logkind;
        } else {
            logger.warn("logkind is not SystemlogKindImpl.");
            return new ArrayList<String>();
        }
        ArrayList<File> logFileNames = new ArrayList<File>();
        File f = this.createLogFileNames(conddate, logkind1, logFileNames);
        if (logFileNames.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("No valid file is found.");
            }
            SystemlogCondition.ReadStatus readstatus2 = f == null ? SystemlogCondition.ReadStatus.UnsetFilename : (!f.exists() ? SystemlogCondition.ReadStatus.NotExistsFile : SystemlogCondition.ReadStatus.CantReadFile);
            logger.info("read status " + readstatus2);
            return new ArrayList<String>();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (File logFileName : logFileNames) {
            logger.debug("logFileName " + logFileName);
            try {
                this.readLogFileAsString(conddate, logFileName, logkind1.getCharset(), limitSize, results);
                if (limitSize <= 0 || results.size() < limitSize) continue;
                break;
            }
            catch (IOException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00240), LogCodeManager.getMessage(LogCode.JFC00240, logFileName.getName()));
                readstatus = SystemlogCondition.ReadStatus.ReadError;
            }
        }
        readstatus = SystemlogCondition.ReadStatus.Success;
        logger.info("read status " + readstatus);
        return results;
    }

    @Override
    public Systemlog[] getLogData(SystemlogCondition cond) {
        return this.getLogData(cond, 65536);
    }

    @Override
    public Systemlog[] getLogData(SystemlogCondition cond, int limitSize) {
        logger.debug("limitSize " + limitSize);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)cond);
        }
        Date conddate = cond.getTargetDay();
        logger.debug("conddate " + conddate);
        logger.debug("getBeginLogDate " + cond.getBeginLogDate());
        logger.debug("getEndLogDate " + cond.getEndLogDate());
        ArrayList<File> logFileNames = new ArrayList<File>();
        SystemlogKindImpl logkind = (SystemlogKindImpl)cond.getLogKind();
        File f = this.createLogFileNames(conddate, logkind, logFileNames);
        if (logFileNames.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("No valid file is found.");
            }
            if (f == null) {
                cond.setReadStatus(SystemlogCondition.ReadStatus.UnsetFilename);
            } else if (!f.exists()) {
                cond.setReadStatus(SystemlogCondition.ReadStatus.NotExistsFile);
            } else {
                cond.setReadStatus(SystemlogCondition.ReadStatus.CantReadFile);
            }
            cond.setCount(0);
            return new Systemlog[0];
        }
        ArrayList<Systemlog> results = new ArrayList<Systemlog>();
        cond.setCount(0);
        for (File logFileName : logFileNames) {
            logger.debug("logFileName " + logFileName);
            try {
                this.readLogFile(logFileName, cond, limitSize, results);
                if (limitSize <= 0 || results.size() < limitSize) continue;
            }
            catch (IOException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00240), LogCodeManager.getMessage(LogCode.JFC00240, logFileName.getName()));
                cond.setReadStatus(SystemlogCondition.ReadStatus.ReadError);
                cond.setCount(0);
            }
            break;
        }
        if (cond.getBeginNumber() < 0) {
            cond.setBeginNumber(1);
        }
        if (cond.getEndNumber() < 0) {
            cond.setEndNumber(cond.getCount());
        }
        cond.setReadStatus(SystemlogCondition.ReadStatus.Success);
        return results.toArray(new Systemlog[0]);
    }

    private File createLogFileNames(Date conddate, SystemlogKindImpl logkind, List<File> logFileNames) {
        Date nowdate;
        if ((conddate = conddate == null ? nowdate : this.getDate(conddate)).after(nowdate = this.getNowDate())) {
            return null;
        }
        String filepattern = logkind.getFilepattern();
        File f = this.addFilepatternFiles(conddate, logFileNames, filepattern);
        String filename = logkind.getLogfilename();
        if (filename != null && conddate.equals(nowdate) && (f = new File(filename)).exists() && f.canRead() && f.isFile()) {
            logFileNames.add(f);
        }
        return f;
    }

    private File addFilepatternFiles(Date conddate, List<File> logFileNames, String filepattern) {
        if (this.FILENAMEPATTERNTYPE == 1) {
            return this.addFilepatternFiles1(conddate, logFileNames, filepattern);
        }
        return this.addFilepatternFiles2(conddate, logFileNames, filepattern);
    }

    private File addFilepatternFiles1(Date conddate, List<File> logFileNames, String filepattern) {
        File f = null;
        if (filepattern == null) {
            return f;
        }
        PatternProcessor pp = new PatternProcessor(filepattern);
        if (pp.getFrequency() != RolloverFrequency.DAILY) {
            logger.error("log4j setting filepattern is not daily. skipped. " + filepattern);
            return f;
        }
        int maxindex = 1;
        if (filepattern.indexOf("%i") > 0) {
            maxindex = 1000;
        }
        pp.setCurrentFileTime(conddate.getTime());
        for (int i = 1; i <= maxindex; ++i) {
            StringBuilder sb = new StringBuilder();
            pp.formatFileName(sb, true, (Object)i);
            if (logger.isDebugEnabled()) {
                logger.debug("sb " + sb.toString());
            }
            if (!(f = new File(sb.toString())).exists() || !f.canRead() || !f.isFile()) break;
            logFileNames.add(f);
        }
        return f;
    }

    private File addFilepatternFiles2(Date conddate, List<File> logFileNames, String filepattern) {
        PatternProcessor pp;
        File f = null;
        if (filepattern == null) {
            return f;
        }
        int cnt = filepattern.indexOf("%i");
        if (cnt >= 0) {
            filepattern = filepattern.substring(0, cnt);
        }
        if ((pp = new PatternProcessor(filepattern)).getFrequency() != RolloverFrequency.DAILY) {
            logger.error("log4j setting filepattern is not daily. skipped. " + filepattern);
            return f;
        }
        pp.setCurrentFileTime(conddate.getTime());
        StringBuilder sb = new StringBuilder();
        pp.formatFileName(sb, true, (Object)1);
        if (logger.isDebugEnabled()) {
            logger.debug("sb " + sb.toString());
        }
        Path srcpath = Paths.get(sb.toString(), new String[0]);
        try (Stream<Path> stream = Files.list(srcpath.getParent());){
            TreeMap files = new TreeMap();
            String header = srcpath.getFileName().toString();
            stream.filter(path -> path.getFileName().toString().startsWith(header)).filter(path -> Files.isReadable(path) && Files.isRegularFile(path, new LinkOption[0])).forEach(path -> {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Files.getLastModifiedTime(path) " + Files.getLastModifiedTime(path, new LinkOption[0]).toString());
                        logger.debug("path " + path.toString());
                    }
                    files.put(Files.getLastModifiedTime(path, new LinkOption[0]), path.toFile());
                }
                catch (IOException e) {
                    logger.error("Failed get lastmodified time " + path, (Throwable)e);
                }
            });
            logFileNames.addAll(files.values());
            if (logFileNames.size() > 0) {
                f = logFileNames.get(logFileNames.size() - 1);
            }
        }
        catch (IOException e) {
            logger.error("Failed get file list " + srcpath.getParent(), (Throwable)e);
        }
        return f;
    }

    private void readLogFileAsString(Date targetdate, File logfilename, Charset charset, int limitSize, List<String> logList) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("reading " + logfilename + ", charset=" + charset);
        }
        try (InputStream is = this.getInputStreamFromZipFile(logfilename);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));){
            boolean isOutput = false;
            String line = null;
            while ((line = reader.readLine()) != null) {
                Systemlog slog = null;
                try {
                    slog = new Systemlog(line);
                }
                catch (IllegalSystemlogFormatException e) {
                    logger.debug("illegal systemlog format", (Throwable)e);
                    continue;
                }
                Date date = slog.getDateTime();
                if (!isOutput && (date == null || date.compareTo(targetdate) < 0)) continue;
                isOutput = true;
                logList.add(line);
                if (logList.size() <= limitSize) continue;
                break;
            }
        }
    }

    private void readLogFile(File logfilename, SystemlogCondition cond, int limitSize, List<Systemlog> logList) throws IOException {
        int count = cond.getCount();
        SystemlogKindImpl logkind = (SystemlogKindImpl)cond.getLogKind();
        Charset charset = logkind.getCharset();
        if (logger.isDebugEnabled()) {
            logger.debug("reading " + logfilename + ", charset=" + charset + ", cond=" + cond);
        }
        try (InputStream is = this.getInputStreamFromZipFile(logfilename);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));){
            int beginLN = cond.getBeginNumber() - 1;
            int endLN = cond.getEndNumber() - 1;
            String line = null;
            while ((line = reader.readLine()) != null) {
                Systemlog slog = null;
                try {
                    slog = new Systemlog(line);
                }
                catch (IllegalSystemlogFormatException e) {
                    logger.debug("illegal systemlog format", (Throwable)e);
                    continue;
                }
                if (cond.getLogFilter().filter(slog) == null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("SKIP: filter check, " + slog);
                    continue;
                }
                if (slog == null || !slog.match(cond)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("SKIP: not match, " + slog);
                    continue;
                }
                boolean saveFlag = true;
                if (beginLN >= 0 && count < beginLN) {
                    saveFlag = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug("change saveFlag to false, count:" + count + " < beginLN:" + beginLN);
                    }
                }
                if (endLN >= 0 && count > endLN) {
                    saveFlag = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug("change saveFlag to false, count:" + count + " > endLN:" + endLN);
                    }
                }
                if (limitSize > 0) {
                    if (logList.size() >= limitSize) {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug("SKIP: now size=" + logList.size() + ", limitSize=" + limitSize);
                        break;
                    }
                    if (saveFlag) {
                        logList.add(slog);
                        if (logger.isDebugEnabled()) {
                            logger.debug("ADD " + slog);
                        }
                    }
                }
                ++count;
            }
            cond.setCount(count);
        }
    }

    private InputStream getInputStreamFromZipFile(File logfilename) throws IOException {
        FileInputStream fis = new FileInputStream(logfilename);
        Object is = null;
        ZipInputStream zis = null;
        if (logfilename.getName().endsWith(".bz2")) {
            is = new BZip2CompressorInputStream((InputStream)fis);
        } else if (logfilename.getName().endsWith(".gz")) {
            is = new GZIPInputStream(fis);
        } else if (logfilename.getName().endsWith(".zip")) {
            zis = new ZipInputStream(fis);
            ZipEntry entry = zis.getNextEntry();
            if (entry != null) {
                is = zis;
            }
        } else {
            is = fis;
        }
        return is;
    }

    @Override
    public Stream<SystemlogManager.LogEntry> getLogEntry(Date from, Date to, SystemlogKind logkind) {
        Date now = new Date();
        if (from.after(now)) {
            return Stream.empty();
        }
        if (to.after(now)) {
            to = now;
        }
        Date[] days = TimeSpanUtil.getDatesBetween(from, to);
        return Arrays.stream(days).flatMap(day -> this.getLogEntry((Date)day, logkind));
    }

    @Override
    public Stream<SystemlogManager.LogEntry> getLogEntry(Date date, SystemlogKind logkind1) {
        SystemlogKindImpl logkind = (SystemlogKindImpl)logkind1;
        ArrayList<File> logFileNames = new ArrayList<File>();
        this.createLogFileNames(date, logkind, logFileNames);
        File logfilename = logkind.getLogfilename() != null ? new File(logkind.getLogfilename()) : null;
        return logFileNames.stream().map(file -> new LogEntryImpl(date, logkind, (File)file, !file.equals(logfilename)));
    }

    private BufferedReader createLogBufferedReader(File logFileName, Charset charset) throws IOException {
        logger.debug("open " + logFileName);
        InputStreamReader reader = new InputStreamReader(this.getInputStreamFromZipFile(logFileName), charset);
        BufferedReader br = new BufferedReader(reader, 1000000);
        return br;
    }

    private Stream<String> readLogStream(final File logFileName, Charset charset) throws IOException {
        logger.debug("open " + logFileName);
        final BufferedReader br = this.createLogBufferedReader(logFileName, charset);
        try {
            return (Stream)br.lines().onClose(new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.debug("close " + logFileName);
                        br.close();
                    }
                    catch (IOException e) {
                        logger.error("failed close", (Throwable)e);
                    }
                }
            });
        }
        catch (Error | RuntimeException e) {
            br.close();
            throw e;
        }
    }

    private Systemlog createSystemlog(String s) {
        try {
            return new Systemlog(s);
        }
        catch (IllegalSystemlogFormatException e) {
            logger.debug("illegal systemlog format", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<UserAction> getActivities(String userId, LocalDate ld) {
        return this.getLogAnalyzer().getActivities(userId, ld);
    }

    @Override
    public List<String> getUserIds(LocalDate ld) {
        return this.getLogAnalyzer().getUserIds(ld);
    }

    @Override
    public int[] getCountByMonth(Date dateFrom, Date dateTo, LogCodeCondition logCode) {
        return this.getLogAnalyzer().getCountByMonth(dateFrom, dateTo, logCode);
    }

    @Override
    public int[] getCountByDay(Date dateFrom, Date dateTo, LogCodeCondition logCode) {
        return this.getLogAnalyzer().getCountByDay(dateFrom, dateTo, logCode);
    }

    private static boolean compare(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private SystemlogKindImpl[] readLogKinds() {
        ArrayList<SystemlogKindImpl> logkinds = new ArrayList<SystemlogKindImpl>();
        try {
            this.readLogKinds(logkinds);
        }
        catch (IOException e1) {
            logger.error("Failed to parse log4j2.xml", (Throwable)e1);
        }
        if (logkinds.size() == 0) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00105), LogCodeManager.getMessage(LogCode.JFC00105, DEFAULT_APPENDARID, "log4j2.xml"));
            SystemlogKindImpl[] __logKinds = new SystemlogKindImpl[]{DEFAULT_LOG_KIND};
            this.logKinds = __logKinds;
            return __logKinds;
        }
        SystemlogKindImpl[] __logKinds = logkinds.toArray(new SystemlogKindImpl[logkinds.size()]);
        return __logKinds;
    }

    private void readLogKinds(List<SystemlogKindImpl> logkinds) throws IOException {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = ctx.getConfiguration();
        Map map = configuration.getAppenders();
        for (String key : map.keySet()) {
            RollingFileAppender rfappender;
            SystemlogKindImpl logkind;
            Appender appender = (Appender)map.get(key);
            if (logger.isDebugEnabled()) {
                logger.debug("appender " + appender);
                logger.debug("appender.getClass() " + appender.getClass());
            }
            String appenderId = key;
            if (!(appender instanceof RollingFileAppender) || (logkind = this.readLogKind(appenderId, rfappender = (RollingFileAppender)appender)) == null) continue;
            logkinds.add(logkind);
        }
    }

    private SystemlogKindImpl readLogKind(String appenderId, RollingFileAppender rfappender) {
        String filename = rfappender.getFileName();
        logger.debug("filename " + filename);
        String filepattern = rfappender.getFilePattern();
        logger.debug("filepattern " + filepattern);
        Charset charset = null;
        Layout layout = rfappender.getLayout();
        if (layout != null && layout instanceof StringLayout) {
            charset = ((StringLayout)layout).getCharset();
            logger.debug("charset " + charset);
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        SystemlogKindImpl logkind = appenderId.equals(DEFAULT_LOG_KIND.getAppendarId()) ? new SystemlogKindImpl(appenderId, DEFAULT_LOG_KIND.getId(), DEFAULT_LOG_KIND.getLabelrkey(), filename, filepattern, charset) : new SystemlogKindImpl(appenderId, appenderId, null, filename, filepattern, charset);
        return logkind;
    }

    public static class SystemlogKindImpl
    implements Serializable,
    SystemlogKind {
        private static final long serialVersionUID = 1L;
        private String appendarid;
        private String id;
        private String labelrkey;
        private String logfilename;
        private String filepattern;
        private String charset;

        SystemlogKindImpl(String appendarid, String id, String labelrkey, String logfilename, String filepattern, Charset charset) {
            this.appendarid = appendarid;
            this.id = id;
            this.labelrkey = labelrkey;
            this.logfilename = logfilename;
            this.filepattern = filepattern;
            this.charset = charset.toString();
        }

        public String getAppendarId() {
            return this.appendarid;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String getLabelrkey() {
            return this.labelrkey;
        }

        @Override
        public String getLabel(ActionParameter p) {
            if (this.labelrkey != null) {
                return JFCUtils.getRValue(this.labelrkey, p.locale);
            }
            return this.appendarid;
        }

        public String getLogfilename() {
            return this.logfilename;
        }

        public String getFilepattern() {
            return this.filepattern;
        }

        public Charset getCharset() {
            return Charset.forName(this.charset);
        }

        @Override
        public Map<String, String> getParamMap() {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("filename", this.getLogfilename());
            paramMap.put("filepattern", this.getFilepattern());
            paramMap.put("charset", this.getCharset().toString());
            return paramMap;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof SystemlogKindImpl)) {
                return false;
            }
            SystemlogKindImpl o = (SystemlogKindImpl)obj;
            return SystemlogManagerLog4j2Impl.compare(o.getAppendarId(), this.getAppendarId()) && SystemlogManagerLog4j2Impl.compare(o.getId(), this.getId()) && SystemlogManagerLog4j2Impl.compare(o.getLabelrkey(), this.getLabelrkey()) && SystemlogManagerLog4j2Impl.compare(o.getLogfilename(), this.getLogfilename()) && SystemlogManagerLog4j2Impl.compare(o.getFilepattern(), this.getFilepattern()) && SystemlogManagerLog4j2Impl.compare(o.charset, this.charset);
        }
    }

    public class LogEntryImpl
    implements SystemlogManager.LogEntry {
        private Date targetDate;
        private SystemlogKindImpl logkind;
        private File file;
        private boolean useCache;

        private LogEntryImpl(Date targetDate, SystemlogKindImpl logkind, File file, boolean useCache) {
            this.targetDate = targetDate;
            this.logkind = logkind;
            this.file = file;
            this.useCache = useCache;
        }

        @Override
        public Date targetDate() {
            return this.targetDate;
        }

        @Override
        public SystemlogKind systemlogKind() {
            return this.logkind;
        }

        @Override
        public String filename() {
            return this.file.toString();
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public long lastModified() {
            return this.file.lastModified();
        }

        @Override
        public boolean useCache() {
            return this.useCache;
        }

        @Override
        public Stream<Systemlog> stream() throws IOException {
            return SystemlogManagerLog4j2Impl.this.readLogStream(this.file, this.logkind.getCharset()).map(s -> SystemlogManagerLog4j2Impl.this.createSystemlog((String)s)).filter(o -> o != null);
        }

        @Override
        public void forEach(Consumer<Systemlog> c) throws IOException {
            try (InputStream is = SystemlogManagerLog4j2Impl.this.getInputStreamFromZipFile(this.file);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is, this.logkind.getCharset()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Systemlog slog = null;
                    try {
                        slog = new Systemlog(line);
                    }
                    catch (IllegalSystemlogFormatException e) {
                        logger.debug("illegal systemlog format", (Throwable)e);
                        continue;
                    }
                    c.accept(slog);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" targetDate=").append(this.targetDate());
            sb.append(" filename=").append(this.filename());
            sb.append(" length=").append(this.length());
            sb.append(" lastModified=").append(this.lastModified());
            sb.append(" useCache=").append(this.useCache());
            return sb.toString();
        }
    }
}

