/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.analyzer;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import jp.jasminesoft.jfc.model.systemlog.analyzer.UserActionType;

public class LogCodeUserActionTypeMapper {
    private static Map<String, UserActionType> MAP = new HashMap<String, UserActionType>();

    public static Optional<UserActionType> find(String logCode) {
        if (logCode == null || logCode.trim().length() < 1) {
            return Optional.empty();
        }
        return Optional.ofNullable(MAP.get(logCode.trim()));
    }

    static {
        MAP.put("JFC-00001", UserActionType.LOGON);
        MAP.put("JFC-00002", UserActionType.LOGON_FAILURE);
        MAP.put("JFC-00003", UserActionType.LOGON_FAILURE);
        MAP.put("JFC-00004", UserActionType.LOGON_FAILURE);
        MAP.put("JFC-00005", UserActionType.LOGON_FAILURE);
        MAP.put("JFC-00006", UserActionType.LOGON_FAILURE);
        MAP.put("JFC-00008", UserActionType.ACCOUNT_EXPIRED);
        MAP.put("JFC-00010", UserActionType.INVALID_PASSWORD);
        MAP.put("JFC-00015", UserActionType.ACCOUNT_LOCKED);
        MAP.put("JFC-00019", UserActionType.EXCEED_MAX_NUM_USER);
        MAP.put("JFC-00022", UserActionType.EXCEED_MAX_NUM_USER);
        MAP.put("JFC-00028", UserActionType.LOGOFF);
        MAP.put("JFC-00108", UserActionType.ERROR_SECURITY);
        MAP.put("JFC-00207", UserActionType.ERROR_INTERNAL);
        MAP.put("JFC-00601", UserActionType.STATISTIC_DATA_OPENED);
        MAP.put("JFC-00020", UserActionType.IGNORE);
        MAP.put("JFC-00023", UserActionType.IGNORE);
        MAP.put("JFC-00031", UserActionType.IGNORE);
    }
}

