/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.filter;

import java.util.ArrayList;
import java.util.List;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.filter.LogFilter;

public class MessageLogFilter
extends LogFilter {
    private String regex_;
    private List<String> excludeList = new ArrayList<String>();

    public MessageLogFilter(String regex) {
        if (regex == null || regex.trim().length() < 1) {
            throw new IllegalArgumentException("Regex pattern is required.");
        }
        this.regex_ = regex;
    }

    public void addExcludeString(String exclude) {
        this.excludeList.add(exclude);
    }

    @Override
    public boolean accept(Systemlog log) {
        if (log.getMessage() == null) {
            return false;
        }
        boolean accept = log.getMessage().matches(this.regex_);
        if (accept && this.excludeList.size() > 0) {
            for (String str : this.excludeList) {
                if (!log.getMessage().contains(str)) continue;
                accept = false;
                break;
            }
        }
        return accept;
    }
}

