/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;

public class TimeSpanUtil {
    private static DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private TimeSpanUtil() {
    }

    public static Date[] getDatesBetween(Date dateTimeFrom, Date dateTimeTo) {
        if (dateTimeFrom == null || dateTimeTo == null) {
            throw new IllegalArgumentException("Date object should not be empty.");
        }
        if (dateTimeFrom.after(dateTimeTo)) {
            throw new IllegalArgumentException("dateTimeTo should be after dateTimeFrom.");
        }
        LocalDate ld_from = dateTimeFrom.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate ld_to = dateTimeTo.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        ArrayList<LocalDate> results = new ArrayList<LocalDate>();
        LocalDate ld_cur = ld_from;
        while (ld_cur.isBefore(ld_to) || ld_cur.isEqual(ld_to)) {
            results.add(ld_cur);
            ld_cur = ld_cur.plusDays(1L);
        }
        return (Date[])results.stream().map(ld -> Date.from(ld.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant())).toArray(Date[]::new);
    }

    public static boolean isToday(Date date) {
        LocalDate ldate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return LocalDate.now().equals(ldate);
    }

    public static Date[] getDateDurationOfOneDay(String dateStr) {
        LocalDate ld = LocalDate.parse(dateStr, YYYY_MM_DD);
        return TimeSpanUtil.getDateDurationOfOneDay(ld);
    }

    public static Date[] getDateDurationOfOneDay(LocalDate ld) {
        LocalDateTime fromLdt = ld.atTime(0, 0, 0);
        LocalDateTime toLdt = ld.atTime(23, 59, 59);
        return new Date[]{Date.from(fromLdt.atZone(ZoneId.systemDefault()).toInstant()), Date.from(toLdt.atZone(ZoneId.systemDefault()).toInstant())};
    }
}

