/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen;

import jp.jasminesoft.jfc.repgen.ReportGenerator;
import jp.jasminesoft.jfc.repgen.ReportGeneratorException;
import jp.jasminesoft.jfc.repgen.excel.poi.ListReportGeneratorImpl;
import jp.jasminesoft.jfc.repgen.excel.poi.ReportGeneratorImpl;

public class ReportGeneratorBureau {
    public static final int EXCEL_POI = 0;
    public static final int REPORT_LIST = 100;
    public static final int REPORT_DETAIL = 101;

    public static ReportGenerator getGenerator(int generator_type, int report_type) throws ReportGeneratorException {
        ReportType rt;
        if (generator_type != 0) {
            throw new ReportGeneratorException("Not implemented.");
        }
        GeneratorType gt = GeneratorType.EXCEL_POI;
        if (report_type == 100) {
            rt = ReportType.LIST;
        } else if (report_type == 101) {
            rt = ReportType.DETAIL;
        } else {
            throw new ReportGeneratorException("Not implemented.");
        }
        return ReportGeneratorBureau.getGenerator(gt, rt);
    }

    private ReportGeneratorBureau() {
    }

    public static ReportGenerator getGenerator(GeneratorType generator_type, ReportType report_type) throws ReportGeneratorException {
        return generator_type.createReportGenerator(report_type);
    }

    public static enum GeneratorType {
        EXCEL_POI{

            @Override
            ReportGenerator createReportGenerator(ReportType report_type) throws ReportGeneratorException {
                if (report_type == ReportType.DETAIL) {
                    return new ReportGeneratorImpl();
                }
                if (report_type == ReportType.LIST) {
                    return new ListReportGeneratorImpl();
                }
                throw new ReportGeneratorException("Not implemented ReportType " + report_type + ", " + this);
            }
        }
        ,
        EXCEL_JEXCELAPI{

            @Override
            ReportGenerator createReportGenerator(ReportType report_type) throws ReportGeneratorException {
                if (report_type == ReportType.DETAIL) {
                    return new jp.jasminesoft.jfc.repgen.excel.jexcelapi.ReportGeneratorImpl();
                }
                if (report_type == ReportType.LIST) {
                    return new jp.jasminesoft.jfc.repgen.excel.jexcelapi.ListReportGeneratorImpl();
                }
                throw new ReportGeneratorException("Not implemented ReportType " + report_type + ", " + this);
            }
        };


        abstract ReportGenerator createReportGenerator(ReportType var1) throws ReportGeneratorException;
    }

    public static enum ReportType {
        LIST,
        DETAIL;

    }
}

