/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.jexcelapi;

import java.io.IOException;
import java.util.Map;
import jp.jasminesoft.jfc.repgen.ReportWorkbook;
import jp.jasminesoft.jfc.repgen.excel.jexcelapi.ListReportGeneratorImpl;
import jp.jasminesoft.jfc.repgen.excel.jexcelapi.ReportWorkbookImpl;
import jxl.Cell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerReportGeneratorImpl
extends ListReportGeneratorImpl {
    private static final Logger LOGGER = LogManager.getLogger((String)ContainerReportGeneratorImpl.class.getName());
    private String containerName;

    public ContainerReportGeneratorImpl(String containerName) {
        this.containerName = containerName;
    }

    public void generateContainer(ReportWorkbook rw, int sheetNum, Map<String, Object> params, Map<String, String> typeparams) throws IOException {
        WritableWorkbook outWorkbook = ((ReportWorkbookImpl)rw).getWritableWorkbook();
        WritableSheet sheet = outWorkbook.getSheet(sheetNum);
        LOGGER.debug("Report will be created as Excel 'list' report.");
        this.generateContainer(sheet, params, typeparams);
    }

    public void generateContainer(WritableSheet sheet, Map<String, Object> params, Map<String, String> typeparams) throws IOException {
        super.generateList(sheet, params, typeparams);
    }

    @Override
    protected String getMatchPattern() {
        return "\\$\\{" + this.containerName + "\\.([0-9]+)\\.[0-9a-zA-Z\\-_.@\\$]*\\}";
    }

    @Override
    protected boolean isRowPlaceholder(Cell cell) {
        if (cell == null) {
            return false;
        }
        return StringUtils.startsWith((CharSequence)this.getValue(cell), (CharSequence)"${") && StringUtils.endsWith((CharSequence)this.getValue(cell), (CharSequence)"}") && this.getValue(cell).indexOf("${" + this.containerName + ".#.") == 0;
    }

    @Override
    protected boolean isPlaceholder(Cell cell) {
        if (cell == null) {
            return false;
        }
        return StringUtils.startsWith((CharSequence)this.getValue(cell), (CharSequence)"${") && StringUtils.endsWith((CharSequence)this.getValue(cell), (CharSequence)"}") && this.getValue(cell).indexOf("${" + this.containerName + ".#.") < 0;
    }
}

