/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.jexcelapi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.repgen.AbstractReportGenerator;
import jp.jasminesoft.jfc.repgen.ReportGeneratorException;
import jp.jasminesoft.jfc.repgen.ReportWorkbook;
import jp.jasminesoft.jfc.repgen.excel.jexcelapi.CellValueReplacer;
import jp.jasminesoft.jfc.repgen.excel.jexcelapi.ReportWorkbookImpl;
import jp.jasminesoft.jfc.repgen.util.PlaceHolderValueNormalizer;
import jxl.Cell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportGeneratorImpl
extends AbstractReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger((String)ReportGeneratorImpl.class.getName());

    @Override
    public void generate(ReportWorkbook rw, Map<String, Object> params, Map<String, String> typeparams, int sheetnum) throws IOException, ReportGeneratorException {
        if (!(rw instanceof ReportWorkbookImpl)) {
            LOGGER.log(LogCodeManager.getPriority(LogCode.JFC00244), LogCodeManager.getMessage(LogCode.JFC00244, rw.getClass().toString()));
            throw new IllegalArgumentException("Illegal ReportWorkbook class");
        }
        WritableWorkbook outWorkbook = ((ReportWorkbookImpl)rw).getWritableWorkbook();
        WritableSheet sheet = outWorkbook.getSheet(sheetnum);
        LOGGER.debug("Report will be created as Excel 'detail' report.");
        this.replaceParamsOfSheet(sheet, params, typeparams);
    }

    @Override
    public ReportWorkbook createReportWorkbook(File file, OutputStream out) throws IOException {
        return new ReportWorkbookImpl(file, out);
    }

    private void replaceParamsOfSheet(WritableSheet sheet, Map<String, Object> params, Map<String, String> typeparams) {
        PlaceHolderValueNormalizer.splitOverCellSizeValues(params, typeparams);
        CellValueReplacer replacer = new CellValueReplacer(this.isFailedParametersToWhiteSpace(), this.getDateFormat());
        int rowNum = sheet.getRows();
        if (rowNum > 65536) {
            rowNum = 65536;
        }
        int columnNum = sheet.getColumns();
        for (int i = 0; i < rowNum; ++i) {
            for (int j = 0; j < columnNum; ++j) {
                Cell aCell = sheet.getCell(j, i);
                replacer.replaceCellValue(sheet, aCell, params, typeparams);
            }
        }
        replacer = null;
    }
}

