/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.jexcelapi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.repgen.ReportGeneratorException;
import jp.jasminesoft.jfc.repgen.ReportWorkbook;
import jp.jasminesoft.jfc.repgen.excel.util.WorkbookUtil;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class ReportWorkbookImpl
implements ReportWorkbook {
    private WritableWorkbook outWorkbook;
    private int activeSheetIndex;
    private final Pattern pat_sheetname = Pattern.compile("^(.*) \\([1-9][0-9]*\\)$");

    ReportWorkbookImpl(File templateFile, OutputStream out) throws IOException {
        Workbook templateWorkbook;
        WorkbookSettings settings = new WorkbookSettings();
        this.initWorkbookSetting(settings);
        try {
            templateWorkbook = Workbook.getWorkbook((File)templateFile, (WorkbookSettings)settings);
        }
        catch (BiffException be) {
            throw new IOException(be.getMessage());
        }
        settings.setWriteAccess(null);
        this.outWorkbook = Workbook.createWorkbook((OutputStream)out, (Workbook)templateWorkbook, (WorkbookSettings)settings);
        this.activeSheetIndex = WorkbookUtil.getActiveSheetIndex(templateFile);
    }

    protected void initWorkbookSetting(WorkbookSettings settings) {
        settings.setLocale(new Locale("ja", "JP"));
        settings.setEncoding("Windows-31J");
        settings.setGCDisabled(true);
        settings.setNamesDisabled(true);
    }

    @Override
    public void write() throws IOException {
        this.outWorkbook.getSheet(this.activeSheetIndex).getSettings().setSelected(true);
        this.outWorkbook.write();
    }

    @Override
    public void close() throws ReportGeneratorException, IOException {
        try {
            this.outWorkbook.close();
        }
        catch (WriteException e) {
            throw new ReportGeneratorException("close failed", e);
        }
    }

    @Override
    public int cloneSheet(int sheetnum) {
        String dstsheetname;
        int cnt;
        String sheetname_head;
        String[] sheetnames = this.outWorkbook.getSheetNames();
        String srcsheetname = sheetnames[sheetnum];
        HashSet<String> sheetnameSet = new HashSet<String>(Arrays.asList(sheetnames));
        Matcher mat = this.pat_sheetname.matcher(srcsheetname);
        if (mat.matches()) {
            sheetname_head = mat.group(1);
            cnt = Integer.parseInt(mat.group(2));
        } else {
            sheetname_head = srcsheetname;
            cnt = 1;
        }
        while (sheetnameSet.contains(dstsheetname = sheetname_head + " (" + ++cnt + ")")) {
        }
        int index = this.getNumberOfSheets();
        this.outWorkbook.copySheet(sheetnum, dstsheetname, index);
        return index;
    }

    @Override
    public void removeSheet(int sheetnum) {
        this.outWorkbook.removeSheet(sheetnum);
    }

    @Override
    public void moveSheetToLast(int sheetnum) {
    }

    @Override
    public int getNumberOfSheets() {
        return this.outWorkbook.getNumberOfSheets();
    }

    @Override
    public void setSheetName(int sheetnum, String name) {
    }

    WritableWorkbook getWritableWorkbook() {
        return this.outWorkbook;
    }
}

