/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.poi;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import jp.jasminesoft.jfc.repgen.CellValueReplacerBase;
import jp.jasminesoft.jfc.repgen.excel.poi.CellUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;

public class CellValueReplacer
extends CellValueReplacerBase {
    public CellValueReplacer(Boolean failed_params_flag, SimpleDateFormat formatter) {
        super(failed_params_flag, formatter);
    }

    public String[] replaceCellValue(Cell aCell, Map<String, Object> params, Map<String, String> typeparams) {
        return super.replaceCellValue(new CellValueReplacerCell(aCell), params, typeparams);
    }

    public static class CellValueReplacerCell
    implements CellValueReplacerBase.CellValueReplacerBaseCell {
        private Cell aCell;

        CellValueReplacerCell(Cell aCell) {
            this.aCell = aCell;
        }

        @Override
        public String getString() {
            RichTextString rstring;
            if (this.aCell.getCellType() != CellType.STRING) {
                if (this.aCell.getCellType() != CellType.FORMULA) {
                    return null;
                }
                if (this.aCell.getCachedFormulaResultType() != CellType.STRING) {
                    return null;
                }
            }
            if ((rstring = this.aCell.getRichStringCellValue()) == null) {
                return null;
            }
            return rstring.getString();
        }

        @Override
        public void setNumericValue(double value) {
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                this.aCell.setCellValue("");
                this.aCell.setCellType(CellType.STRING);
                return;
            }
            this.aCell.setCellValue(value);
            this.aCell.setCellType(CellType.NUMERIC);
        }

        @Override
        public void setStringValue(String cellValue) {
            CellUtil.setCellValue(this.aCell, cellValue);
        }

        @Override
        public void setDateValue(Date date) {
            this.aCell.setCellValue(date);
        }

        @Override
        public void setEmptyStringValue() {
            this.aCell.setCellType(CellType.STRING);
            CellUtil.setCellValue(this.aCell, "");
        }
    }
}

