/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.poi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.repgen.ReportWorkbook;
import jp.jasminesoft.jfc.repgen.excel.poi.ListReportGeneratorImpl;
import jp.jasminesoft.jfc.repgen.excel.poi.ReportWorkbookImpl;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ContainerReportGeneratorImpl
extends ListReportGeneratorImpl {
    private static final Logger LOGGER = LogManager.getLogger((String)ContainerReportGeneratorImpl.class.getName());
    private String containerName;

    public ContainerReportGeneratorImpl(String containerName) {
        this.containerName = containerName;
    }

    public void generateContainer(ReportWorkbook rw, int sheetNum, Map<String, Object> params, Map<String, String> typeparams) {
        this.generateContainer(rw, sheetNum, params, typeparams, true);
    }

    public void generateContainer(ReportWorkbook rw, int sheetNum, Map<String, Object> params, Map<String, String> typeparams, boolean needsFinishProcess) {
        Workbook workbook = ((ReportWorkbookImpl)rw).getWorkbook();
        Sheet sheet = workbook.getSheetAt(sheetNum);
        this.generateContainer(sheet, params, typeparams, workbook);
        if (needsFinishProcess) {
            this.finish();
        }
    }

    public void generateContainer(Sheet sheet, Map<String, Object> params, Map<String, String> typeparams, Workbook workbook) {
        super.generateList(sheet, params, typeparams, workbook);
    }

    @Override
    protected String getMatchPattern() {
        return "\\$\\{[e:|E:|fmt:]*" + this.containerName + "\\.([0-9]+)\\.[0-9a-zA-Z\\-_.@\\$]*\\}";
    }

    @Override
    protected boolean isPlaceHolderCell(Cell cell) {
        String tmpCellValue = null;
        if (cell != null && cell.getCellType() == CellType.STRING) {
            RichTextString rstring = cell.getRichStringCellValue();
            String string = tmpCellValue = rstring != null ? rstring.getString() : "";
            if (tmpCellValue != null && ((tmpCellValue = tmpCellValue.trim()).indexOf("${" + this.containerName + ".#.") == 0 || tmpCellValue.indexOf("${e:" + this.containerName + ".#.") == 0 || tmpCellValue.indexOf("${E:" + this.containerName + ".#.") == 0 || tmpCellValue.indexOf("${fmt:" + this.containerName + ".#.") == 0)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected SortedSet<Integer> getKeyCountSet(Map<String, Object> params) {
        Set<String> keyset = params.keySet();
        Iterator<String> ite = keyset.iterator();
        String tmp = null;
        TreeMap<Integer, ArrayList<Object>> keyMap = new TreeMap<Integer, ArrayList<Object>>();
        Pattern pat = Pattern.compile(this.getMatchPattern());
        while (ite.hasNext()) {
            Object value;
            tmp = ite.next();
            Matcher matcher = pat.matcher(tmp);
            if (!matcher.matches() || (value = params.get(tmp)) == null) continue;
            String cntstr = matcher.group(1);
            try {
                Integer cntint = Integer.valueOf(cntstr);
                ArrayList<Object> list = (ArrayList<Object>)keyMap.get(cntint);
                if (list == null) {
                    list = new ArrayList<Object>();
                    keyMap.put(cntint, list);
                }
                list.add(value);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("illegal number format " + tmp, (Throwable)e);
                if (!LOGGER.isDebugEnabled()) continue;
                e.printStackTrace();
            }
        }
        ArrayList<Integer> candidates4remove = null;
        for (Integer k : keyMap.keySet()) {
            Object v;
            List list = (List)keyMap.get(k);
            if (list.size() != 1 || !NumberUtils.isCreatable((String)(v = list.get(0)).toString())) continue;
            if (candidates4remove == null) {
                candidates4remove = new ArrayList<Integer>();
            }
            candidates4remove.add(k);
        }
        if (candidates4remove != null) {
            for (Integer k : candidates4remove) {
                keyMap.remove(k);
            }
        }
        SortedSet keycntset = (SortedSet)keyMap.keySet();
        return keycntset;
    }
}

