/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.poi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.repgen.ReportGeneratorException;
import jp.jasminesoft.jfc.repgen.ReportWorkbook;
import jp.jasminesoft.jfc.repgen.excel.poi.HSSFWorkbookUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportWorkbookImpl
implements ReportWorkbook {
    private static final Logger LOGGER = LogManager.getLogger((String)ReportWorkbookImpl.class.getName());
    protected OutputStream out;
    protected Workbook workbook;
    public static final int MAX_DUPLICATE_SHEETNUM = 99;
    public static Map<String, String> invalidCharacterAtSheetNameMap = new HashMap<String, String>();

    public ReportWorkbookImpl(File templateFile, OutputStream out) throws IOException {
        this.out = out;
        ZipSecureFile.setMinInflateRatio((double)0.001);
        this.workbook = WorkbookFactory.create((InputStream)new FileInputStream(templateFile));
        ZipSecureFile.setMinInflateRatio((double)0.01);
    }

    @Override
    public void write() throws IOException {
        if (this.workbook instanceof HSSFWorkbook) {
            HSSFWorkbookUtil.enableFormulaRecalculation((HSSFWorkbook)this.workbook);
        } else if (this.workbook instanceof XSSFWorkbook) {
            XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)((XSSFWorkbook)this.workbook));
        }
        this.workbook.write(this.out);
    }

    @Override
    public void close() throws ReportGeneratorException, IOException {
    }

    @Override
    public int cloneSheet(int sheetnum) {
        String printArea = this.getProperPrintArea(this.workbook.getPrintArea(0));
        int n_sheet = 0;
        try {
            Sheet templateSheet = this.workbook.getSheetAt(sheetnum);
            CellRangeAddress repeatingRows = templateSheet.getRepeatingRows();
            CellRangeAddress repeatingColumns = templateSheet.getRepeatingColumns();
            Sheet sheet = this.workbook.cloneSheet(sheetnum);
            sheet.setForceFormulaRecalculation(true);
            n_sheet = this.workbook.getSheetIndex(sheet);
            if (repeatingRows != null) {
                sheet.setRepeatingRows(repeatingRows);
            } else if (repeatingColumns != null) {
                sheet.setRepeatingColumns(repeatingColumns);
            }
            if (printArea != null) {
                this.workbook.setPrintArea(n_sheet, printArea);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to clone sheet.", (Throwable)e);
        }
        return n_sheet;
    }

    @Override
    public void removeSheet(int sheetnum) {
        this.workbook.removeSheetAt(sheetnum);
    }

    @Override
    public void moveSheetToLast(int sheetnum) {
        String name = this.workbook.getSheetName(sheetnum);
        String printArea = null;
        if (sheetnum == 0) {
            printArea = this.getProperPrintArea(this.workbook.getPrintArea(sheetnum));
        }
        int num = this.workbook.getNumberOfSheets();
        this.workbook.setSheetOrder(name, num - 1);
        if (num >= 2) {
            this.workbook.setActiveSheet(num - 2);
            this.workbook.setSheetHidden(num - 1, true);
            this.workbook.setActiveSheet(sheetnum);
            this.workbook.setSelectedTab(sheetnum);
        }
        if (sheetnum == 0 && printArea != null) {
            int size = this.workbook.getNumberOfSheets();
            for (int k = 0; k < size - 1; ++k) {
                this.workbook.setPrintArea(k, printArea);
            }
        }
    }

    private String getProperPrintArea(String printArea) {
        int ptr;
        if (printArea != null && (ptr = printArea.indexOf("!")) > 0) {
            String before = printArea.substring(0, ptr);
            String after = printArea.substring(ptr + 1);
            if (before.indexOf("(") < 0 && after.indexOf("(") < 0) {
                printArea = printArea.substring(ptr + 1);
            }
        }
        return printArea;
    }

    @Override
    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    @Override
    public void setSheetName(int sheetnum, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        name = StringUtil.replaceAll((String)name, invalidCharacterAtSheetNameMap);
        int suffix = 2;
        Object _name = name;
        while (true) {
            try {
                this.workbook.setSheetName(sheetnum, (String)_name);
            }
            catch (IllegalArgumentException e) {
                _name = name + suffix;
                if (++suffix <= 99) continue;
                LOGGER.error("Failed to set sheet name " + (String)_name + ".", (Throwable)e);
            }
            break;
        }
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    static {
        invalidCharacterAtSheetNameMap.put("'", "");
        invalidCharacterAtSheetNameMap.put("*", "");
        invalidCharacterAtSheetNameMap.put("/", "");
        invalidCharacterAtSheetNameMap.put(":", "");
        invalidCharacterAtSheetNameMap.put("?", "");
        invalidCharacterAtSheetNameMap.put("[", "");
        invalidCharacterAtSheetNameMap.put("\\", "");
        invalidCharacterAtSheetNameMap.put("]", "");
        invalidCharacterAtSheetNameMap.put("\u2019", "");
        invalidCharacterAtSheetNameMap.put("\uff07", "");
        invalidCharacterAtSheetNameMap.put("\uff0a", "");
        invalidCharacterAtSheetNameMap.put("\uff0f", "");
        invalidCharacterAtSheetNameMap.put("\uff1a", "");
        invalidCharacterAtSheetNameMap.put("\uff1f", "");
        invalidCharacterAtSheetNameMap.put("\uff3b", "");
        invalidCharacterAtSheetNameMap.put("\uff3c", "");
        invalidCharacterAtSheetNameMap.put("\uff3d", "");
        invalidCharacterAtSheetNameMap.put("\uffe5", "");
        invalidCharacterAtSheetNameMap.put("(", "");
        invalidCharacterAtSheetNameMap.put(")", "");
    }
}

