/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.util;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import jp.jasminesoft.jfc.repgen.util.StringSplit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PlaceHolderValueNormalizer {
    private static int DEFAULT_MAX_CELL_SIZE;
    private static int MAX_CELL_SIZE;

    private PlaceHolderValueNormalizer() {
    }

    public static void splitOverCellSizeValues(Map params, Map typeparams) {
        if (params == null) {
            throw new IllegalArgumentException("input parameter should not be empty.");
        }
        Set keyvalues = params.entrySet();
        Map.Entry entry2 = null;
        String key = null;
        String value = null;
        String[] splitedValues = null;
        HashMap<String, String[]> newValues = new HashMap<String, String[]>();
        for (Map.Entry entry2 : keyvalues) {
            key = (String)entry2.getKey();
            if (!(entry2.getValue() instanceof String) || !StringSplit.isSizeOver(value = (String)entry2.getValue(), MAX_CELL_SIZE)) continue;
            splitedValues = StringSplit.chop(value, MAX_CELL_SIZE);
            newValues.put(key, splitedValues);
        }
        keyvalues = newValues.entrySet();
        entry2 = null;
        key = null;
        splitedValues = null;
        for (Map.Entry entry2 : keyvalues) {
            key = (String)entry2.getKey();
            splitedValues = (String[])entry2.getValue();
            PlaceHolderValueNormalizer.addDividedParams(key, splitedValues, params, typeparams);
        }
    }

    private static void addDividedParams(String key, String[] splitedValues, Map params, Map typeparams) {
        params.remove(key);
        if (typeparams != null) {
            typeparams.remove(key);
        }
        String keyFormar = key.substring(0, key.length() - 1);
        int num = splitedValues.length;
        for (int i = 0; i < num; ++i) {
            Object tmpKey = i == 0 ? key : keyFormar + "." + i + "}";
            String tmpValue = splitedValues[i];
            params.put(tmpKey, tmpValue);
            if (typeparams == null) continue;
            typeparams.put(tmpKey, "string");
        }
    }

    static {
        MAX_CELL_SIZE = DEFAULT_MAX_CELL_SIZE = Short.MAX_VALUE;
        String StrMaxCellSize = null;
        try {
            ResourceBundle res = ResourceBundle.getBundle("jfcbase");
            StrMaxCellSize = res.getString("jp.jasminesoft.jfc.repgen.util.PlaceHolderValueNormalizer.MAX_CELL_SIZE");
        }
        catch (MissingResourceException res) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(StrMaxCellSize)) {
            int d = NumberUtils.toInt((String)StrMaxCellSize);
            if (d > 0 && d < DEFAULT_MAX_CELL_SIZE) {
                MAX_CELL_SIZE = d;
            } else if (d <= 0 || d > DEFAULT_MAX_CELL_SIZE) {
                MAX_CELL_SIZE = DEFAULT_MAX_CELL_SIZE;
            }
        }
    }
}

