/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.service;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionFactory;
import jp.jasminesoft.jfc.ClusterManagerFactory;
import jp.jasminesoft.jfc.FilenameList;
import jp.jasminesoft.jfc.FilenameListDeleteMode;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.WorkflowSettingUtil;
import jp.jasminesoft.jfc.autoconfiguration.SecurityProperties;
import jp.jasminesoft.jfc.core.charset.Charsets;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.address.AddressResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class JfcConfig {
    private static final Logger logger = LogManager.getLogger((String)JfcConfig.class.getName());
    @Autowired(required=false)
    protected SecurityProperties securityProperties;
    @Autowired(required=false)
    private ServletContext servletContext;
    private String googlemapkey;
    private static String _jsp_encoding;
    private String jsp_encoding;
    private String csv_encoding;
    private Charset download_charset;
    private String encoding_convert;
    private URL security_policy_url;
    private Boolean ignore_securitycheck;
    private static final boolean DEFAULT_IGNORE_SECURITYCHECK = false;
    private String download_dir;
    private String LogonModuleName;
    private int MaxLogon = -1;
    private int MaxMultipleLogon = -1;
    public static final int DEFAULT_MAX_LOGON = -1;
    public static final int DEFAULT_MAX_MULTIPLE_LOGON = -1;
    public Boolean AutoLogoff;
    private String[] IgnorePankuzu;
    private int SessionTimeout = -1;
    private String anorm_horburl;
    private String anorm_url;
    public static final int DEFAULT_SESSION_TIMEOUT = 1200;
    private static final boolean DEFAULT_SAVE_PREFERENCE_AT_LOGOFF = true;
    private Boolean SaveLastAccessTimeAtLogoff;
    private static final boolean DEFAULT_SAVE_LASTACCESSTIME_AT_LOGOFF = false;
    private String userinfo_passwd_digest_algorithm = null;
    private int userinfo_failedpassword_count = Integer.MIN_VALUE;
    private int userinfo_passwd_expire_period = Integer.MIN_VALUE;
    private int userinfo_passwd_change_warn_period = Integer.MIN_VALUE;
    private int userinfo_oldpasswd_save_size = Integer.MIN_VALUE;
    private Boolean ignore_logoncheck = null;
    private String ignore_logoncheckUsername = "";
    private String ignore_logoncheckPassword = "";
    private Boolean isOutputRemoteAddrInLogData = null;
    private FilenameListDeleteMode filenameListDeleteMode;
    private Boolean useSubmenuFlag;
    private Boolean refreshJuserEveryAccess;
    private String[] realip_parameternames;
    private String icsfilename;
    private Boolean opennewtab;
    private static final String BUILD_TIMESTAMP_KEY = "__jfc_buildTimestamp";
    private static final String RELEASE_TIMESTAMP_KEY = "__jfc_releaseTimestamp";
    public static final String REALIP_PARAMETERNAME = "realIP_parameter_name";

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Autowired
    @Qualifier(value="googlemap_key")
    public void setGooglemapKey(String googlemapkey) {
        this.googlemapkey = googlemapkey;
    }

    public boolean isOutputRemoteAddrInLogData() {
        return this.isOutputRemoteAddrInLogData != null && this.isOutputRemoteAddrInLogData != false;
    }

    protected JfcConfig() {
    }

    @PostConstruct
    public synchronized void init() {
        if (this.servletContext == null) {
            return;
        }
        this.init(this.servletContext);
    }

    public synchronized void init(ServletContext sc) {
        String pnamestr;
        this.initBaseService(sc);
        this.initMisc(sc);
        this.initWorkflowSettingUtil(sc);
        this.initGooglemapKey(sc);
        String sidebar_width = sc.getInitParameter("sidebar_width");
        if (sidebar_width == null || sidebar_width.length() == 0) {
            sidebar_width = "8em;";
        }
        sc.setAttribute("__jfc_sidebararea_width", (Object)sidebar_width);
        if (sc.getAttribute(BUILD_TIMESTAMP_KEY) == null || sc.getAttribute(RELEASE_TIMESTAMP_KEY) == null) {
            Map<String, String> timestamp = this.getBuildTimestamp();
            sc.setAttribute(BUILD_TIMESTAMP_KEY, (Object)timestamp.get(BUILD_TIMESTAMP_KEY));
            sc.setAttribute(RELEASE_TIMESTAMP_KEY, (Object)timestamp.get(RELEASE_TIMESTAMP_KEY));
        }
        if (!StringUtils.isBlank((CharSequence)(pnamestr = sc.getInitParameter(REALIP_PARAMETERNAME)))) {
            String[] sa = pnamestr.split(",");
            ArrayList<String> list = new ArrayList<String>();
            for (String s : sa) {
                if (StringUtils.isBlank((CharSequence)(s = s.trim()))) continue;
                list.add(s);
            }
            if (list.size() >= 1) {
                this.realip_parameternames = list.toArray(new String[0]);
            }
        }
        JFCUtils.setJfcConfig(this);
        PankuzuNode.setJfcConfig(this);
        User.setJfcConfig(this);
    }

    public String getLogonModuleName() {
        return this.LogonModuleName;
    }

    public int getMaxLogon() {
        return this.MaxLogon;
    }

    public int getMaxMultipleLogon() {
        return this.MaxMultipleLogon;
    }

    public boolean isAutoLogoff() {
        return this.AutoLogoff;
    }

    public String[] getIgnorePankuzu() {
        if (this.IgnorePankuzu != null) {
            return (String[])this.IgnorePankuzu.clone();
        }
        return null;
    }

    public int getSessionTimeout() {
        return this.SessionTimeout;
    }

    public String getAnormHorbUrl() {
        return this.anorm_horburl;
    }

    public String getAnormUrl() {
        return this.anorm_url;
    }

    public boolean isSaveLastAccessTimeAtLogoff() {
        if (this.SaveLastAccessTimeAtLogoff == null) {
            return false;
        }
        return this.SaveLastAccessTimeAtLogoff;
    }

    public String getUserinfoPasswdDigestAlgorithm() {
        return this.userinfo_passwd_digest_algorithm;
    }

    public int getUserinfoFailedpasswordCount() {
        return this.userinfo_failedpassword_count;
    }

    public int getUserinfoPasswdExpirePeriod() {
        return this.userinfo_passwd_expire_period;
    }

    public int getUserinfoPasswdChangeWarnPeriod() {
        return this.userinfo_passwd_change_warn_period;
    }

    public int getUserinfoOldpasswdSaveSize() {
        return this.userinfo_oldpasswd_save_size;
    }

    public boolean isIgnoreLogoncheck() {
        if (this.ignore_logoncheck == null) {
            return false;
        }
        return this.ignore_logoncheck;
    }

    public String getIgnoreLogoncheckUsername() {
        return this.ignore_logoncheckUsername;
    }

    public String getIgnoreLogoncheckPassword() {
        return this.ignore_logoncheckPassword;
    }

    public static String getStaticJspEncoding() {
        return _jsp_encoding;
    }

    public String getJspEncoding() {
        return this.jsp_encoding;
    }

    public String getCsvEncoding() {
        return this.csv_encoding;
    }

    public Charset getDownloadCharset() {
        return this.download_charset;
    }

    public String getEncodingConvert() {
        return this.encoding_convert;
    }

    public Boolean getIgnoreSecurityCheck() {
        return this.ignore_securitycheck;
    }

    public URL getSecurityPolicyUrl() {
        return this.security_policy_url;
    }

    public String getDownloadDir() {
        return this.download_dir;
    }

    public boolean getUseSubmenuFlag() {
        if (this.useSubmenuFlag == null) {
            return true;
        }
        return this.useSubmenuFlag;
    }

    public boolean getRefreshJuserEveryAccess() {
        if (this.refreshJuserEveryAccess == null) {
            return true;
        }
        return this.refreshJuserEveryAccess;
    }

    public String getICSfilename() {
        return this.icsfilename;
    }

    public void initBaseService(ServletContext sc) {
        String _refreshJuserEveryAccessStr;
        String _useSubmenuFlagStr;
        String jmaster_dir;
        CheckPermission checkPermission;
        String s;
        if (this.jsp_encoding == null) {
            this.jsp_encoding = sc.getInitParameter("jsp_encoding");
            if (this.jsp_encoding == null) {
                this.jsp_encoding = "Shift_JIS";
            }
            _jsp_encoding = this.jsp_encoding;
            logger.info("(admin@localhost) * jsp_encoidng is set to " + this.jsp_encoding);
        }
        if (this.csv_encoding == null) {
            this.csv_encoding = sc.getInitParameter("csv_encoding");
            if (this.csv_encoding == null) {
                this.csv_encoding = "Shift_JIS";
            }
            logger.info("(admin@localhost) * csv_encoidng is set to " + this.csv_encoding);
        }
        if (this.download_charset == null) {
            try {
                this.download_charset = Charset.forName(sc.getInitParameter("download_charset"));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.download_charset == null) {
                this.download_charset = Charsets.Shift_JIS.charset();
            }
            logger.info("(admin@localhost) * download_charset is set to " + this.download_charset.toString());
        }
        if (this.encoding_convert == null) {
            this.encoding_convert = sc.getInitParameter("encoding_convert");
            if (this.encoding_convert == null) {
                this.encoding_convert = "true";
            }
            logger.info("(admin@localhost) * encoidng_convert is set to " + this.encoding_convert);
        }
        if (this.ignore_securitycheck == null) {
            s = sc.getInitParameter("ignore_securitycheck");
            this.ignore_securitycheck = s != null ? Boolean.valueOf(s) : Boolean.valueOf(false);
            logger.info("(admin@localhost) * ignore security check is set to " + this.ignore_securitycheck);
            checkPermission = CheckPermissionFactory.getCheckPermission();
            checkPermission.setDefaultIgnoreSecuritycheck(this.ignore_securitycheck);
        }
        if (this.security_policy_url == null) {
            block35: {
                s = sc.getInitParameter("security_url");
                if (s == null) {
                    s = "file:${DEPLOYHOME}/WEB-INF/lib/jfcapp.jar";
                }
                s = StringUtil.replace((String)s, (String)"${DEPLOYHOME}", (String)JFCUtils.createDeployHomePath(sc));
                try {
                    this.security_policy_url = new URL(s);
                }
                catch (MalformedURLException e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00051), LogCodeManager.getMessage(LogCode.JFC00051, s));
                    logger.debug((Object)e);
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    s = "";
                    try {
                        this.security_policy_url = new URL(s);
                    }
                    catch (MalformedURLException e2) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00052), LogCodeManager.getMessage(LogCode.JFC00052, s));
                        logger.debug((Object)e2);
                        if (!logger.isDebugEnabled()) break block35;
                        e2.printStackTrace();
                    }
                }
            }
            if (this.security_policy_url != null) {
                logger.info("(admin@localhost) * security_policy_url is set to " + this.security_policy_url);
                checkPermission = CheckPermissionFactory.getCheckPermission();
                checkPermission.setDefaultSecurityPolicyUrl(this.security_policy_url);
            }
        }
        if (this.download_dir == null) {
            this.download_dir = sc.getInitParameter("download_dir");
            if (this.download_dir == null) {
                this.download_dir = "${APPHOME}/download_dir";
            }
            this.download_dir = StringUtil.replace((String)this.download_dir, (String)"${APPHOME}", (String)JFCUtils.createAppHomePath(sc));
            if (!this.download_dir.endsWith(File.separator)) {
                this.download_dir = this.download_dir + File.separator;
            }
            logger.info("(admin@localhost) * download_dir is set to " + this.download_dir);
        }
        if (this.anorm_horburl == null) {
            this.anorm_horburl = sc.getInitParameter("anorm_horburl");
            if (this.anorm_horburl != null && this.anorm_horburl.length() > 0) {
                logger.info("(admin@localhost) * Address Normalization request url is set to " + this.anorm_horburl);
            }
        }
        if (this.anorm_url == null) {
            this.anorm_url = sc.getInitParameter("anorm_url");
            if (this.anorm_url != null && this.anorm_url.length() > 0) {
                logger.info("(admin@localhost) * Address Normalizer request url is set to " + this.anorm_url);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(jmaster_dir = sc.getInitParameter("jmaster_dir")))) {
            jmaster_dir = StringUtil.replace((String)jmaster_dir, (String)"${DEPLOYHOME}", (String)JFCUtils.createDeployHomePath(sc));
            String jmaster_file = sc.getInitParameter("jmaster_file");
            if (StringUtils.isBlank((CharSequence)jmaster_file)) {
                jmaster_file = "zipcode.dat";
            }
            AddressResolver.getInstance((String)jmaster_dir, (String)jmaster_file);
            if (AddressResolver.isValid()) {
                logger.info("(admin@localhost) * jmaster " + jmaster_dir + "/" + jmaster_file + " is loaded successfully.");
            } else {
                logger.error("(admin@localhost) * Failed to load jmaster " + jmaster_dir + "/" + jmaster_file + ".");
            }
        }
        ClusterManagerFactory.getClusterManager();
        if (this.useSubmenuFlag == null && (_useSubmenuFlagStr = sc.getInitParameter("useSubmenu")) != null) {
            this.useSubmenuFlag = Boolean.valueOf(_useSubmenuFlagStr);
        }
        if (this.refreshJuserEveryAccess == null && (_refreshJuserEveryAccessStr = sc.getInitParameter("refreshJuserEveryAccess")) != null) {
            this.refreshJuserEveryAccess = Boolean.valueOf(_refreshJuserEveryAccessStr);
        }
        if (this.icsfilename == null) {
            this.icsfilename = sc.getInitParameter("icsfilename");
            if (this.icsfilename != null && this.icsfilename.length() > 0) {
                logger.info("(admin@localhost) * icsfilename is set to " + this.icsfilename);
            }
        }
    }

    private void initMisc(ServletContext sc) {
        String s;
        if (this.MaxLogon < 0) {
            this.MaxLogon = -1;
            s = sc.getInitParameter("max_logon");
            if (s != null) {
                try {
                    this.MaxLogon = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            logger.info("(admin@localhost) * Max Logon Size is set to " + this.MaxLogon);
        }
        if (this.MaxMultipleLogon < 0) {
            this.MaxMultipleLogon = -1;
            s = sc.getInitParameter("max_multiple_logon");
            if (s != null) {
                try {
                    this.MaxMultipleLogon = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            logger.info("(admin@localhost) * Max Multiple Logon Size is set to " + this.MaxMultipleLogon);
        }
        if (this.AutoLogoff == null) {
            this.AutoLogoff = Boolean.FALSE;
            s = sc.getInitParameter("auto_logoff");
            if (s != null) {
                try {
                    this.AutoLogoff = Boolean.valueOf(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            logger.info("(admin@localhost) * Auto Logoff mode is set to " + this.AutoLogoff);
        }
        if (this.IgnorePankuzu == null) {
            ArrayList<String> l = new ArrayList<String>();
            String s2 = sc.getInitParameter("ignore_pankuzu");
            if (s2 != null) {
                StringTokenizer st = new StringTokenizer(s2, ", ");
                while (st.hasMoreTokens()) {
                    l.add(st.nextToken());
                }
            }
            this.IgnorePankuzu = l.toArray(new String[0]);
            logger.info("(admin@localhost) * Ignore Pankuzu List is set to " + l);
        }
        if (this.SessionTimeout < 0) {
            this.SessionTimeout = 1200;
            s = sc.getInitParameter("session_timeout");
            if (s != null) {
                try {
                    this.SessionTimeout = Integer.parseInt(s);
                }
                catch (NumberFormatException s2) {
                    // empty catch block
                }
            }
            logger.info("(admin@localhost) * Session Timeout is set to " + this.SessionTimeout);
        }
        if (this.LogonModuleName == null) {
            this.LogonModuleName = this.springSecurityLogonModule();
            logger.info("(admin@localhost) * LogonModuleName is set to " + this.LogonModuleName);
        }
        if (this.SaveLastAccessTimeAtLogoff == null) {
            s = sc.getInitParameter("save_lastaccesstime_at_logoff");
            this.SaveLastAccessTimeAtLogoff = s != null ? Boolean.valueOf(s) : Boolean.valueOf(false);
            logger.info("(admin@localhost) * save_lastaccesstime_at_logoff is set to " + this.SaveLastAccessTimeAtLogoff);
        }
        if (this.userinfo_passwd_digest_algorithm == null) {
            this.setUserinfoPasswdDigestAlgorithm(sc.getInitParameter("userinfo_passwd_digest_algorithm"));
        }
        if (this.userinfo_failedpassword_count == Integer.MIN_VALUE) {
            this.setUserinfoFailedpasswordCount(sc.getInitParameter("userinfo_failedpassword_count"));
        }
        if (this.userinfo_passwd_expire_period == Integer.MIN_VALUE) {
            this.setUserinfoPasswdExpirePeriod(sc.getInitParameter("userinfo_passwd_expire_period"));
        }
        if (this.userinfo_passwd_change_warn_period == Integer.MIN_VALUE) {
            this.setUserinfoPasswdChangeWarnPeriod(sc.getInitParameter("userinfo_passwd_change_warn_period"));
        }
        if (this.userinfo_oldpasswd_save_size == Integer.MIN_VALUE) {
            this.setUserinfoOldpasswdSaveSize(sc.getInitParameter("userinfo_oldpasswd_save_size"));
        }
        if (this.isOutputRemoteAddrInLogData == null) {
            s = sc.getInitParameter("is_output_remote_addr_in_logdata");
            this.isOutputRemoteAddrInLogData = s != null ? Boolean.valueOf(s) : Boolean.FALSE;
            logger.info("(admin@localhost) * is_output_remote_addr_in_logdata is set to " + this.isOutputRemoteAddrInLogData);
        }
        if (this.filenameListDeleteMode == null) {
            s = sc.getInitParameter("file_delete_mode");
            if (s != null) {
                try {
                    this.filenameListDeleteMode = FilenameListDeleteMode.valueOf(s);
                }
                catch (IllegalArgumentException e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00053), LogCodeManager.getMessage(LogCode.JFC00053, s, String.valueOf((Object)FilenameList.getDefaultDeleteTargetMode())));
                }
            }
            if (this.filenameListDeleteMode != null) {
                FilenameList.setDefaultDeleteTargetMode(this.filenameListDeleteMode);
                logger.info("(admin@localhost) * file delete mode is set to " + this.filenameListDeleteMode);
            } else {
                this.filenameListDeleteMode = FilenameList.getDefaultDeleteTargetMode();
            }
        }
        if (this.ignore_logoncheck == null) {
            this.setIgnoreLogoncheck(sc.getInitParameter("ignore_logoncheck"));
        }
        if ("".equals(this.ignore_logoncheckUsername)) {
            this.setIgnoreLogoncheckUsername(sc.getInitParameter("ignore_logoncheckUsername"));
        }
        if ("".equals(this.ignore_logoncheckPassword)) {
            this.setIgnoreLogoncheckPassword(sc.getInitParameter("ignore_logoncheckPassword"));
        }
        if (this.opennewtab == null) {
            this.setOpennewtab(sc.getInitParameter("opennewtab"));
        }
    }

    private void setUserinfoPasswdDigestAlgorithm(String s) {
        this.userinfo_passwd_digest_algorithm = "raw";
        if (s != null) {
            if (s.equals("md5")) {
                this.userinfo_passwd_digest_algorithm = "md5";
            } else if (s.equals("sha-1")) {
                this.userinfo_passwd_digest_algorithm = "sha-1";
            } else if (s.equals("sha-256")) {
                this.userinfo_passwd_digest_algorithm = "sha-256";
            } else if (s.equals("sha-384")) {
                this.userinfo_passwd_digest_algorithm = "sha-384";
            } else if (s.equals("sha-512")) {
                this.userinfo_passwd_digest_algorithm = "sha-512";
            } else if (s.equals("raw")) {
                this.userinfo_passwd_digest_algorithm = "raw";
            } else {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00054), LogCodeManager.getMessage(LogCode.JFC00054, s));
            }
        }
        logger.info("(admin@localhost) * userinfo_passwd_digest_algorithm is set to \"" + this.userinfo_passwd_digest_algorithm + "\".");
    }

    public void setUserinfoFailedpasswordCount(String s) {
        this.userinfo_failedpassword_count = -1;
        if (s != null) {
            try {
                this.userinfo_failedpassword_count = Integer.parseInt(s);
                if (this.userinfo_failedpassword_count < 1) {
                    this.userinfo_failedpassword_count = -1;
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00055), LogCodeManager.getMessage(LogCode.JFC00055, s));
                }
            }
            catch (NumberFormatException nfe) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00056), LogCodeManager.getMessage(LogCode.JFC00056, s));
            }
        }
        logger.info("(admin@localhost) * userinfo_failedpassword_count is set to \"" + this.userinfo_failedpassword_count + "\".");
    }

    public void setUserinfoPasswdExpirePeriod(String s) {
        this.userinfo_passwd_expire_period = -1;
        if (s != null) {
            try {
                this.userinfo_passwd_expire_period = Integer.parseInt(s);
                if (this.userinfo_passwd_expire_period < 0) {
                    this.userinfo_passwd_expire_period = -1;
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00057), LogCodeManager.getMessage(LogCode.JFC00057, s));
                }
            }
            catch (NumberFormatException nfe) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00058), LogCodeManager.getMessage(LogCode.JFC00058, s));
            }
        }
        logger.info("(admin@localhost) * userinfo_passwd_expire_period is set to \"" + this.userinfo_passwd_expire_period + "\".");
    }

    public void setUserinfoPasswdChangeWarnPeriod(String s) {
        this.userinfo_passwd_change_warn_period = -1;
        if (s != null) {
            try {
                this.userinfo_passwd_change_warn_period = Integer.parseInt(s);
                if (this.userinfo_passwd_change_warn_period < 1 || this.userinfo_passwd_change_warn_period > this.userinfo_passwd_expire_period) {
                    this.userinfo_passwd_change_warn_period = -1;
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00059), LogCodeManager.getMessage(LogCode.JFC00059, s));
                }
            }
            catch (NumberFormatException nfe) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00060), LogCodeManager.getMessage(LogCode.JFC00060, s));
            }
        }
        logger.info("(admin@localhost) * userinfo_passwd_change_warn_period is set to \"" + this.userinfo_passwd_change_warn_period + "\".");
    }

    public void setUserinfoOldpasswdSaveSize(String s) {
        this.userinfo_oldpasswd_save_size = -1;
        if (s != null) {
            try {
                this.userinfo_oldpasswd_save_size = Integer.parseInt(s);
                if (this.userinfo_oldpasswd_save_size < 0) {
                    this.userinfo_oldpasswd_save_size = -1;
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00061), LogCodeManager.getMessage(LogCode.JFC00061, s));
                }
            }
            catch (NumberFormatException nfe) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00062), LogCodeManager.getMessage(LogCode.JFC00062, s));
            }
        }
        logger.info("(admin@localhost) * userinfo_oldpasswd_save_size is set to \"" + this.userinfo_oldpasswd_save_size + "\".");
    }

    private void setIgnoreLogoncheck(String s) {
        this.ignore_logoncheck = Boolean.FALSE;
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            this.ignore_logoncheck = Boolean.valueOf(s);
        }
        logger.info("(admin@localhost) * ignore_logoncheck is set to \"" + this.ignore_logoncheck + "\".");
    }

    private void setIgnoreLogoncheckUsername(String s) {
        this.ignore_logoncheckUsername = null;
        if (StringUtils.isNotBlank((CharSequence)s)) {
            this.ignore_logoncheckUsername = s;
        }
        if (this.isIgnoreLogoncheck()) {
            logger.info("(admin@localhost) * ignore_logoncheckUsername is set to \"" + this.ignore_logoncheckUsername + "\".");
        }
    }

    private void setIgnoreLogoncheckPassword(String s) {
        this.ignore_logoncheckPassword = null;
        if (StringUtils.isNotBlank((CharSequence)s)) {
            this.ignore_logoncheckPassword = s;
        }
    }

    protected String springSecurityLogonModule() {
        if (this.securityProperties != null && this.securityProperties.isValidJdbcAuthentication()) {
            return "JFCAppSpringSecurityJDBC";
        }
        return "JFCAppSpringSecurity";
    }

    private void initWorkflowSettingUtil(ServletContext sc) {
        String flowDefinitionOutputDirectory = sc.getInitParameter("flowDefinitionOutputDirectory");
        String flowDefinitionCustomizeDirectory = sc.getInitParameter("flowDefinitionCustomizeDirectory");
        String participantDefinitionOutputDirectory = sc.getInitParameter("participantDefinitionOutputDirectory");
        if (flowDefinitionOutputDirectory != null) {
            WorkflowSettingUtil.setFlowDefinitionOutputDirectory(StringUtil.replace((String)flowDefinitionOutputDirectory, (String)"${DEPLOYHOME}", (String)JFCUtils.createDeployHomePath(sc)));
        }
        if (flowDefinitionCustomizeDirectory != null) {
            WorkflowSettingUtil.setFlowDefinitionCustomizeDirectory(StringUtil.replace((String)flowDefinitionCustomizeDirectory, (String)"${DEPLOYHOME}", (String)JFCUtils.createDeployHomePath(sc)));
        }
        if (participantDefinitionOutputDirectory != null) {
            WorkflowSettingUtil.setParticipantDefinitionOutputDirectory(StringUtil.replace((String)participantDefinitionOutputDirectory, (String)"${DEPLOYHOME}", (String)JFCUtils.createDeployHomePath(sc)));
        }
    }

    private void initGooglemapKey(ServletContext sc) {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.googlemapkey)) {
                sc.setAttribute("googlemap_key", (Object)this.googlemapkey);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private Map<String, String> getBuildTimestamp() {
        HashMap<String, String> timestamp = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmm");
        timestamp.put(BUILD_TIMESTAMP_KEY, sdf.format(new Date()));
        timestamp.put(RELEASE_TIMESTAMP_KEY, sdf.format(new Date()));
        try {
            ResourceBundle rb = ResourceBundle.getBundle("buildlog");
            if (rb == null) {
                return timestamp;
            }
            Enumeration<String> e = rb.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if ("wagby.version".equals(key)) {
                    String version = rb.getString(key);
                    Matcher m = Pattern.compile(".*\\s(\\d{8}-\\d{4})").matcher(version);
                    if (m.matches()) {
                        timestamp.put(RELEASE_TIMESTAMP_KEY, m.group(1));
                    }
                }
                if (!"build.timestamp".equals(key)) continue;
                String buildTimestamp = rb.getString(key);
                buildTimestamp = StringUtils.replace((String)buildTimestamp, (String)"-", (String)"");
                buildTimestamp = StringUtils.replace((String)buildTimestamp, (String)" ", (String)"");
                buildTimestamp = StringUtils.replace((String)buildTimestamp, (String)":", (String)"");
                timestamp.put(BUILD_TIMESTAMP_KEY, buildTimestamp);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return timestamp;
    }

    public String[] getRealIPParameterNames() {
        return this.realip_parameternames;
    }

    private void setOpennewtab(String s) {
        this.opennewtab = Boolean.FALSE;
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            this.opennewtab = Boolean.valueOf(s);
        }
        logger.info("(admin@localhost) * opennewtab is set to \"" + this.opennewtab + "\".");
    }

    public boolean isOpennewtab() {
        return this.opennewtab;
    }

    public SecurityProperties getSecurityProperties() {
        return this.securityProperties;
    }
}

