/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.service;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.menu.IMenuChoice;
import jp.jasminesoft.jfc.menu.Item;
import jp.jasminesoft.jfc.menu.JFCAppMenu;
import jp.jasminesoft.jfc.menu.Menu;
import jp.jasminesoft.jfc.menu.Menubar;
import jp.jasminesoft.jfc.service.ForwardMenubarException;
import jp.jasminesoft.jfc.service.JfcConfig;
import jp.jasminesoft.jfc.service.NothingMenubarException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class MenuService {
    private static final Logger logger = LogManager.getLogger(MenuService.class);
    private JfcConfig jfcConfig;
    private JFCErrorManager errorManager;
    private LogonStatusManager lsman;
    @Autowired
    private ApplicationContext appctx;

    @Autowired
    public void setJFCConfig(JfcConfig jfcConfig) {
        this.jfcConfig = jfcConfig;
    }

    public JfcConfig getJFCConfig() {
        return this.jfcConfig;
    }

    @Autowired
    public void setJFCErrorManager(JFCErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public JFCErrorManager getJFCErrorManager() {
        return this.errorManager;
    }

    @Autowired
    public void setLogonStatusManager(LogonStatusManager lsman) {
        this.lsman = lsman;
    }

    public LogonStatusManager getLogonStatusManager() {
        return this.lsman;
    }

    public List getRequestScopedInterceptors() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Menubar perform_db(ActionParameter p, URL url, String name) throws IOException, ServletException, ForwardMenubarException {
        Item item;
        Menubar menubar;
        block10: {
            JFCAppMenu ap = JFCAppMenu.getInstance(url);
            menubar = ap.getMenubar(p.user, this.getJFCConfig().getJspEncoding(), p.locale);
            if (menubar.getMenu() == null || menubar.getMenu().length == 0) {
                if (StringUtils.isNotBlank((CharSequence)p.user.getPasswdChangeFlag())) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00048), LogCodeManager.getMessage(LogCode.JFC00048, p.user.getUsername()));
                    Object[] o = new Object[]{p.user.getUsername()};
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.noPasswordChangeAuth", o, p.locale));
                    throw new NothingMenubarException("noPasswordChangeAuth");
                }
                if (BaseController.isMobile(p)) {
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.noMobileModel", p.locale));
                    throw new NothingMenubarException("noMobileModel");
                }
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.noMenuItem", p.locale));
                throw new NothingMenubarException("noMenuItem");
            }
            if (name != null && name.length() > 0) {
                item = this.getItem(menubar, name);
                if (item == null && !"userPreference".equals(name)) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00079), LogCodeManager.getMessage(LogCode.JFC00079, p.user, name));
                    break block10;
                } else {
                    p.appMap.put("__jfc_app_name", name);
                    throw new ForwardMenubarException("mainMenu." + name);
                }
            }
            item = null;
        }
        if (item != null) {
            name = item.getName();
            p.appMap.put("__jfc_app_name", name);
            String forward = item.getForward();
            if (forward == null) {
                forward = name;
            }
            throw new ForwardMenubarException("mainMenu." + forward);
        }
        if (!this.lsman.checkInsertAvailable(p)) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.limitover_count_all_data", p.locale));
        }
        if (JFCUtils.hasPrincipal(p.user, "all") && !this.lsman.checkMaxAccount(p.user)) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.logon.license.max_account.over", p.locale));
        }
        return menubar;
    }

    private Item getItem(Menubar menubar, String name) {
        if (name == null) {
            return null;
        }
        int len = menubar.getMenu() != null ? menubar.getMenu().length : 0;
        for (int i = 0; i < len; ++i) {
            Menu menu = menubar.getMenu(i);
            Item item = this.getItem(menu, name);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private Item getItem(Menu menu, String name) {
        if (name == null) {
            return null;
        }
        int len = menu.getContent() != null ? menu.getContent().length : 0;
        for (int j = 0; j < len; ++j) {
            Item item;
            IMenuChoice iMenuChoice = menu.getContent(j);
            if (iMenuChoice instanceof Menu && (item = this.getItem((Menu)iMenuChoice, name)) != null) {
                return item;
            }
            if (!(iMenuChoice instanceof Item) || !name.equals((item = (Item)iMenuChoice).getName())) continue;
            return item;
        }
        return null;
    }
}

