/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbProcessBean;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.ProcessBean;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.ResultListWrapperImpl_FixedList;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.dao.ForeignKeyCriteriaConverter;
import jp.jasminesoft.jfc.dao.MapBasedCriteriaConverter;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.CriteriaConfigureEntityServiceImpl;
import jp.jasminesoft.jfc.textsearch.app.DummyResultListWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ProcessBeanBasedEntityService<E extends ContainerBase<E>, PK extends Serializable, M extends EntityMeta<E>>
extends CriteriaConfigureEntityServiceImpl<E, PK, M> {
    private static final Logger logger = LogManager.getLogger(ProcessBeanBasedEntityService.class);
    @Autowired
    @Qualifier(value="errorManager")
    JFCErrorManager errorManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> find(FinderContext<?> finderContext) {
        Object op;
        ResultListWrapperImpl_FixedList rlist;
        List results;
        DbProcessBean processBean;
        ActionParameter p;
        block7: {
            if (finderContext.getCriteriaConverter() instanceof ForeignKeyCriteriaConverter || finderContext.getCriteriaConverter() instanceof MapBasedCriteriaConverter) {
                return super.find(finderContext);
            }
            p = this.getActionParameterContainer().get();
            processBean = (DbProcessBean)p.appctx.getBean(this.getShowListProcessBeanClass());
            this.prepare(processBean, finderContext);
            results = null;
            rlist = null;
            try {
                op = processBean.process();
                if (op == null) {
                    throw new RuntimeException(this.errorManager.getJfcerror("error.dbaccess.nodata", p.locale).getContent());
                }
                if (op instanceof String) {
                    Object[] ep = new Object[]{(String)op};
                    throw new RuntimeException(this.errorManager.getJfcerror("error.dbaccess", ep, p.locale).getContent());
                }
                if (!(op instanceof DummyResultListWrapper)) break block7;
                ArrayList ep = new ArrayList();
                this.releaseQuietly(processBean);
                this.releaseQuietly(rlist);
                return ep;
            }
            catch (Throwable throwable) {
                this.releaseQuietly(processBean);
                this.releaseQuietly(rlist);
                throw throwable;
            }
        }
        if (!(op instanceof ResultListWrapperImpl_FixedList)) {
            logger.error("return value must be ResultListWrapperImpl_FixedList.");
            throw new RuntimeException(this.errorManager.getJfcerror("error.dbaccess", (Object[])null, p.locale).getContent());
        }
        rlist = (ResultListWrapperImpl_FixedList)op;
        results = rlist.getResultList((Integer)processBean.getParameter("__jfc_resultbean_start"), (Integer)processBean.getParameter("__jfc_resultbean_end"));
        final int size = rlist.getResultSize();
        finderContext.updateCount(results.size(), new FinderContext.CountUpdator(){

            @Override
            protected int count() {
                return size;
            }
        });
        this.releaseQuietly(processBean);
        this.releaseQuietly(rlist);
        return results;
    }

    private void prepare(DbProcessBean processBean, FinderContext<?> finderContext) {
        ActionParameter p = this.getActionParameterContainer().get();
        processBean.setActionParameter(p);
        processBean.setParameter("condition", finderContext.getCondition());
        processBean.setParameter("sort_key", this.getSortkey(p));
        processBean.setParameter("__jfc_resultbean_start", finderContext.getFirstResult());
        if (finderContext.getPageSize() == 0) {
            processBean.setParameter("__jfc_resultbean_end", Integer.MAX_VALUE);
        } else {
            processBean.setParameter("__jfc_resultbean_end", finderContext.getFirstResult() + finderContext.getPageSize());
        }
        if (finderContext.isProcess()) {
            processBean.setParameter("__jfc_resultbean_size", finderContext.getRowCount());
        } else {
            processBean.setParameter("__jfc_resultbean_size", -1);
        }
        processBean.setParameter("__jfc_return_wrapped_object", true);
        processBean.setParameter("__jfc_showListReturnType", (Object)ProcessBean.ShowListReturnType.ResultListWrapper);
        processBean.setParameter("__jfc_target_item_set", finderContext.getTargetItemSet());
    }

    private String[] getSortkey(ActionParameter p) {
        String sortKey = (String)p.request.getAttribute("__jfc_sortkey");
        if (StringUtils.isBlank((CharSequence)sortKey)) {
            return null;
        }
        return StringUtils.split((String)sortKey, (String)"+");
    }

    protected abstract Class<? extends DbProcessBean> getShowListProcessBeanClass();

    private void releaseQuietly(Releasable target) {
        if (target == null) {
            return;
        }
        try {
            target.release();
        }
        catch (Exception e) {
            logger.warn("Failed to release.", (Throwable)e);
        }
    }
}

