/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.servlet;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeResponseUrl;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.servlet.auth.oauth2.AbstractAuthorizationCodeCallbackServlet;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.servlet.GoogleOAuth2Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class GoogleAuthorizationCodeCallbackServlet
extends AbstractAuthorizationCodeCallbackServlet {
    private static final Logger logger = LogManager.getLogger((String)GoogleAuthorizationCodeCallbackServlet.class.getName());
    @Autowired
    private ApplicationContext appctx;
    @Autowired
    private GoogleOAuth2Util util;

    protected void onSuccess(HttpServletRequest request, HttpServletResponse response, Credential credential) throws ServletException, IOException {
        logger.debug("onSuccess " + credential);
        logger.debug("appctx " + this.appctx);
        this.util.logCredential(credential);
        String redirectUrl = this.util.getWebapiRedirectUri(request);
        response.sendRedirect(redirectUrl);
    }

    protected void onError(HttpServletRequest request, HttpServletResponse response, AuthorizationCodeResponseUrl errorResponse) throws ServletException, IOException {
        logger.debug("onError " + errorResponse);
        String redirectUrl = this.util.getWebapiRedirectUri(request);
        response.sendRedirect(redirectUrl);
    }

    protected String getRedirectUri(HttpServletRequest request) throws ServletException, IOException {
        String redirectUrl = this.util.getRedirectUri(request);
        return redirectUrl;
    }

    protected AuthorizationCodeFlow initializeFlow() throws IOException {
        return this.util.initializeFlow();
    }

    protected String getUserId(HttpServletRequest req) throws ServletException, IOException {
        return this.util.getUserId(req);
    }
}

