/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tag;

import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.Principal;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionFactory;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CheckLogonBase {
    private static final Logger logger = LogManager.getLogger(CheckLogonBase.class);
    private String principals = "";
    private Boolean isnot = Boolean.FALSE;
    private String permclassname = null;
    private String permname = null;
    private String permactions = null;
    private boolean isIgnoreInternetAccount = false;
    private HttpServletRequest request = null;

    public CheckLogonBase() {
    }

    public CheckLogonBase(HttpServletRequest request) {
        this.request = request;
    }

    public String getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(String principals) {
        this.principals = principals;
    }

    public String getNot() {
        return this.isnot.toString();
    }

    public void setNot(String isnot) {
        this.isnot = Boolean.valueOf(isnot);
    }

    public String getPermclassname() {
        return this.permclassname;
    }

    public void setPermclassname(String permclassname) {
        this.permclassname = permclassname;
    }

    public String getPermname() {
        return this.permname;
    }

    public void setPermname(String permname) {
        this.permname = permname;
    }

    public String getPermactions() {
        return this.permactions;
    }

    public void setPermactions(String permactions) {
        this.permactions = permactions;
    }

    public void setIgnoreInternetAccount(String isIgnoreInternetAccount) {
        this.isIgnoreInternetAccount = Boolean.valueOf(isIgnoreInternetAccount);
    }

    public boolean checkLogon(ActionParameter p) {
        return this.checkLogon1(JFCUtils.getUserInSession(p));
    }

    public boolean checkLogon(HttpSession session, HttpServletRequest request) {
        if (session == null || request == null) {
            return false;
        }
        return this.checkLogon1(JFCUtils.getUserInSession(session, request));
    }

    public boolean checkLogon(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        return this.checkLogon1(JFCUtils.getUserInSession(request));
    }

    private boolean checkLogon1(User user) {
        boolean failed = false;
        if (user == null) {
            failed = true;
        } else if (this.isIgnoreInternetAccount && user.isInternetAccount()) {
            failed = true;
        }
        if (failed) {
            boolean valid = false;
            boolean isnot = Boolean.valueOf(this.getNot());
            return !isnot ? valid : !valid;
        }
        return this.checkLogon(user);
    }

    public boolean checkLogon(User user) {
        Boolean ret = null;
        String key = null;
        if (this.request != null) {
            StringBuilder keybuf = new StringBuilder("__jfc_checkLogon_");
            keybuf.append(this.permname).append(":").append(this.permactions);
            key = keybuf.toString();
            ret = (Boolean)this.request.getAttribute(key);
        }
        if (ret == null) {
            boolean valid = this.checkLogonBase(user);
            boolean isnot = Boolean.valueOf(this.getNot());
            ret = new Boolean(!isnot ? valid : !valid);
            if (this.request != null) {
                this.request.setAttribute(key, (Object)ret);
            }
        }
        return ret;
    }

    private boolean checkLogonBase(User user) {
        if (user == null) {
            return false;
        }
        if (this.getPrincipals() != null && this.getPrincipals().length() > 0 && !this.checkPrincipals(user)) {
            return false;
        }
        return this.getPermclassname() == null || this.getPermclassname().length() <= 0 || this.checkPermission(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPrincipals(User user) {
        Principal[] userPrincipals;
        try (UserInfo userinfo = UserInfoFactory.getUserInfo();){
            userPrincipals = userinfo.getPrincipals(user.getUsername());
        }
        StringTokenizer stk = new StringTokenizer(this.getPrincipals());
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            for (int i = 0; i < userPrincipals.length; ++i) {
                if (!userPrincipals[i].getName().equals(token)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkPermission(User user) {
        Permission perm;
        try {
            Object[] arg;
            Class[] argclass;
            if (this.getPermname() != null && this.getPermactions() != null) {
                argclass = new Class[]{String.class, String.class};
                arg = new Object[]{this.getPermname(), this.getPermactions()};
            } else if (this.getPermname() != null) {
                argclass = new Class[]{String.class};
                arg = new Object[]{this.getPermname()};
            } else {
                argclass = new Class[]{};
                arg = new Object[]{};
            }
            Class<?> permclass = Class.forName(this.getPermclassname());
            Constructor<?> constructor = permclass.getConstructor(argclass);
            perm = (Permission)constructor.newInstance(arg);
        }
        catch (Exception e) {
            logger.warn("failed create Permission class " + this.getPermclassname(), (Throwable)e);
            return false;
        }
        CheckPermission checkperm = CheckPermissionFactory.getCheckPermission();
        return checkperm.process(user, perm);
    }

    public void release() {
        this.principals = "";
        this.isnot = Boolean.FALSE;
        this.permclassname = null;
        this.permname = null;
        this.permactions = null;
    }
}

