/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.textsearch.IndexerDefinition;
import jp.jasminesoft.jfc.textsearch.IndexerException;
import jp.jasminesoft.jfc.textsearch.IndexerUser;
import jp.jasminesoft.jfc.textsearch.IndexerUtil;
import jp.jasminesoft.jfc.textsearch.RepconFileStringUtil;
import jp.jasminesoft.jfc.textsearch.TwoGramAnalyzer;
import jp.jasminesoft.util.StringCommonFilter;
import jp.jasminesoft.util.StringFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class Indexer
implements IndexerDefinition {
    private static final Logger logger = LogManager.getLogger((String)Indexer.class.getName());
    public static final String URLENCODED_HEADER = "__jfc_urlencoded_";
    public static final String UNIQUE_KEY = "__jfc_uniqueKey";
    private boolean newindex = false;
    private String indexDir;
    IndexWriter idxWriter;
    public static final int SUGGEST_MAX_LENGTH = 64;
    private static final StringFilter filter4suggest;
    private int resultSize = -1;
    private int maxResultSize = 1000;

    public Indexer() {
    }

    public Indexer(String indexDir) {
        this.setIndexDir(indexDir);
    }

    public Indexer(String indexDir, boolean newindex) {
        this.setIndexDir(indexDir);
        this.setNewindex(newindex);
    }

    public void setNewindex(boolean newindex) {
        this.newindex = newindex;
    }

    public boolean isNewindex() {
        return this.newindex;
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(String indexDir) {
        this.indexDir = indexDir;
    }

    public int getMaxDoc() throws IndexerException {
        IndexSearcher is = null;
        FSDirectory d = null;
        try {
            d = FSDirectory.open((File)new File(this.indexDir));
            is = new IndexSearcher((Directory)d);
            int n = is.maxDoc();
            return n;
        }
        catch (Exception e) {
            throw new IndexerException(e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    throw new IndexerException(ioe.getMessage(), ioe);
                }
            }
            if (d != null) {
                try {
                    d.close();
                }
                catch (IOException ioe) {
                    throw new IndexerException(ioe.getMessage(), ioe);
                }
            }
        }
    }

    public Analyzer getAnalyzer() {
        return new TwoGramAnalyzer();
    }

    IndexWriter getIndexWriter() throws IndexerException {
        try {
            FSDirectory d = FSDirectory.open((File)new File(this.indexDir));
            if (this.idxWriter == null) {
                boolean create = !IndexReader.indexExists((Directory)d) || this.newindex;
                this.idxWriter = new IndexWriter((Directory)d, this.getAnalyzer(), create, IndexWriter.MaxFieldLength.UNLIMITED);
            }
            return this.idxWriter;
        }
        catch (CorruptIndexException cie) {
            throw new IndexerException(cie.getMessage(), cie);
        }
        catch (Exception e) {
            throw new IndexerException(e.getMessage(), e);
        }
    }

    public boolean isIndexWriter() {
        return this.idxWriter != null;
    }

    public void addWithLock(String key, Map<String, String> content) throws IndexerException {
        try {
            this.add(key, content);
        }
        finally {
            this.close();
        }
    }

    public void updateWithLock(String key, Map<String, String> content) throws IndexerException {
        try {
            this.update(key, content);
        }
        finally {
            this.close();
        }
    }

    public void deleteWithLock(String key, Map<String, String> content) throws IndexerException {
        try {
            this.delete(key, content);
        }
        finally {
            this.close();
        }
    }

    public void optimizeWithLock() throws IndexerException {
        try {
            this.optimize();
        }
        finally {
            this.close();
        }
    }

    public void add(String key, Map<String, String> content) throws IndexerException {
        logger.debug("content:" + content);
        try {
            this.getIndexWriter().addDocument(Indexer.createDocument(key, content));
        }
        catch (Exception e) {
            throw new IndexerException(e.getMessage(), e);
        }
    }

    public void update(String key, Map<String, String> content) throws IndexerException {
        try {
            this.getIndexWriter().updateDocument(new Term(key, content.get(key)), Indexer.createDocument(key, content));
        }
        catch (Exception e) {
            throw new IndexerException(e.getMessage(), e);
        }
    }

    public void delete(String key, Map<String, String> content) throws IndexerException {
        try {
            this.getIndexWriter().deleteDocuments(new Term(key, content.get(key)));
        }
        catch (Exception e) {
            throw new IndexerException(e.getMessage(), e);
        }
    }

    public void optimize() throws IndexerException {
        try {
            this.getIndexWriter().optimize();
        }
        catch (Exception e) {
            throw new IndexerException("failed to optimize because of " + e.getMessage(), e);
        }
    }

    public void close() throws IndexerException {
        try {
            if (this.isIndexWriter()) {
                this.getIndexWriter().close();
                this.idxWriter = null;
            }
        }
        catch (Exception e) {
            throw new IndexerException("failed to close because of " + e.getMessage(), e);
        }
    }

    static Document createDocument(String key, Map<String, String> content) {
        Document document = new Document();
        for (Map.Entry<String, String> entry : content.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("key=\"" + entry.getKey() + "\" value=\"" + entry.getValue() + "\"");
            }
            if (UNIQUE_KEY.equals(entry.getKey())) {
                document.add((Fieldable)new Field(entry.getKey(), entry.getValue(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                continue;
            }
            if (Indexer.isUrlEncoded(entry.getKey())) {
                try {
                    document.add((Fieldable)new Field(entry.getKey(), URLEncoder.encode(entry.getValue(), "UTF-8"), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                continue;
            }
            document.add((Fieldable)new Field(entry.getKey(), entry.getValue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            if (!(Indexer.isKeyJshfilename(entry.getKey()) || Indexer.isUseridjshparam(entry.getKey()) || Indexer.isJgroupidjshparam(entry.getKey()))) {
                document.add((Fieldable)new Field("00SG_" + entry.getKey(), QueryParser.escape((String)Indexer.createStringForSuggest(entry.getValue())), Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
            if (Indexer.isUseridjshparam(entry.getKey()) || Indexer.isJgroupidjshparam(entry.getKey())) continue;
            String value = entry.getValue();
            if (Indexer.isKeyJshfilename(entry.getKey())) {
                value = RepconFileStringUtil.getStringFilenameRemoved(value);
            }
            document.add((Fieldable)new Field("00TS_" + entry.getKey(), value, Field.Store.YES, Field.Index.ANALYZED));
        }
        return document;
    }

    public static boolean isJgroupidjshparam(String key) {
        if (key == null) {
            return false;
        }
        return key.equals("jgroupidjshparam");
    }

    public static boolean isUseridjshparam(String key) {
        if (key == null) {
            return false;
        }
        return key.equals("useridjshparam");
    }

    public static boolean isKeyJshfilename(String key) {
        if (key == null) {
            return false;
        }
        return key.endsWith("_jshfilename");
    }

    public static boolean isUrlEncoded(String key) {
        if (key == null) {
            return false;
        }
        return key.startsWith(URLENCODED_HEADER);
    }

    public static String createStringForSuggest(String s) {
        if (s == null) {
            return null;
        }
        s = filter4suggest.filter(s);
        if ((s = s.toLowerCase()).length() > 64) {
            s = s.substring(0, 64);
        }
        return s;
    }

    public int getResultSize() {
        return this.resultSize;
    }

    public void setMaxResultSize(int maxResultSize) {
        this.maxResultSize = maxResultSize;
    }

    public Map[] queryReturnMap(String defaultField, String query) throws IndexerException {
        return this.queryReturnMap(defaultField, null, query);
    }

    public Map[] queryReturnMap(String defaultField, String[] sort_key, String query) throws IndexerException {
        if (query == null || query.length() == 0) {
            logger.warn("No query. The suggest field may not set as a condition rule.");
            return new Map[0];
        }
        logger.debug("query :" + query);
        try {
            Query qObj = new QueryParser(Version.LUCENE_24, defaultField, this.getAnalyzer()).parse(query);
            return this.queryReturnMap(sort_key, qObj);
        }
        catch (Exception e) {
            throw new IndexerException(e.getMessage(), e);
        }
    }

    public Map[] queryReturnMap(String defaultField, String[] sort_key, String query, List<IndexerUser> users) throws IndexerException {
        if (query == null || query.length() == 0) {
            logger.warn("No query. The suggest field may not set as a condition rule.");
            return new Map[0];
        }
        logger.debug("query :" + query);
        try {
            Query qObj = new QueryParser(Version.LUCENE_24, defaultField, this.getAnalyzer()).parse(query);
            return this.queryReturnMap(sort_key, qObj, users);
        }
        catch (Exception e) {
            throw new IndexerException(e.getMessage(), e);
        }
    }

    public Query getQuery(String defaultField, String query) throws ParseException {
        Query qObj = new QueryParser(Version.LUCENE_24, defaultField, this.getAnalyzer()).parse(query);
        return qObj;
    }

    public Map[] queryReturnMap(Query qObj) throws IndexerException {
        return this.queryReturnMap(null, qObj);
    }

    public Map[] queryReturnMap(String[] sort_key, Query qObj) throws IndexerException {
        return this.queryReturnMap(sort_key, qObj, null);
    }

    public Map[] queryReturnMap(String[] sort_key, Query qObj, List<IndexerUser> users) throws IndexerException {
        IndexSearcher is = null;
        List<Object> ret = null;
        FSDirectory d = null;
        try {
            d = FSDirectory.open((File)new File(this.indexDir));
            if (!IndexReader.indexExists((Directory)d)) {
                Map[] mapArray = new Map[]{};
                return mapArray;
            }
            is = new IndexSearcher((Directory)d);
            logger.debug("Query:" + qObj);
            if (is.maxDoc() > 0) {
                ret = this.getResultListInternal(sort_key, qObj, is, users);
            } else {
                ret = new ArrayList();
                this.resultSize = 0;
            }
        }
        catch (Exception e) {
            throw new IndexerException(e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    throw new IndexerException(ioe.getMessage(), ioe);
                }
            }
            if (d != null) {
                try {
                    d.close();
                }
                catch (IOException ioe) {
                    throw new IndexerException(ioe.getMessage(), ioe);
                }
            }
        }
        return ret.toArray(new Map[0]);
    }

    private List<Map> getResultListInternal(String[] sort_key, Query qObj, IndexSearcher is, List<IndexerUser> users) throws Exception {
        ArrayList<Map> ret = new ArrayList<Map>();
        logger.debug("is :" + is);
        logger.debug("qObj:" + qObj);
        logger.debug("maxResultSize:" + this.maxResultSize);
        logger.debug("IndexerUtil.getSort(sort_key)):" + IndexerUtil.getSort(sort_key));
        logger.debug("Users:" + users);
        TopFieldDocs result = is.search(qObj, null, this.maxResultSize, IndexerUtil.getSort(sort_key));
        if (result != null && result.scoreDocs != null) {
            for (int idx = 0; idx < Math.min(result.scoreDocs.length, this.maxResultSize); ++idx) {
                HashMap<String, String> rs = new HashMap<String, String>();
                for (Object o : is.doc(result.scoreDocs[idx].doc).getFields()) {
                    Field field = (Field)o;
                    if (field.name().indexOf("00SG_") == 0 || field.name().indexOf("00TS_") == 0) continue;
                    rs.put(field.name(), field.stringValue());
                }
                if (!this.isOwnerOk(rs, users)) continue;
                rs.remove("useridjshparam");
                rs.remove("jgroupidjshparam");
                ret.add(rs);
            }
            this.resultSize = ret.size();
        }
        logger.debug("ret.size:" + ret.size());
        return ret;
    }

    boolean isOwnerOk(Map rs, List<IndexerUser> users) {
        if (users == null || users.size() == 0) {
            return true;
        }
        if (!rs.containsKey("useridjshparam") && !rs.containsKey("jgroupidjshparam")) {
            return true;
        }
        boolean ret = true;
        for (IndexerUser user : users) {
            if (user.getUserid() == null && !user.checkGroupid()) continue;
            ret = false;
            boolean isUseridOk = true;
            if (user.getUserid() != null) {
                isUseridOk = user.getUserid().equals((String)rs.get("useridjshparam"));
            }
            boolean isGroupidOk = true;
            if (user.checkGroupid()) {
                isGroupidOk = false;
                String jgroupid = (String)rs.get("jgroupidjshparam");
                for (int id : user.getGroupid()) {
                    if (!jgroupid.contains("," + Integer.toString(id) + ",")) continue;
                    isGroupidOk = true;
                    break;
                }
            }
            if (!isUseridOk || !isGroupidOk) continue;
            return true;
        }
        return ret;
    }

    public boolean isIndexingNeeded() throws Exception {
        try {
            return this.getMaxDoc() == 0;
        }
        catch (IndexerException e) {
            logger.warn(e.getMessage());
            return true;
        }
    }

    public boolean isIndexAvailable() throws Exception {
        try {
            if (!new File(this.indexDir).isDirectory()) {
                return false;
            }
            this.getMaxDoc();
            return true;
        }
        catch (IndexerException e) {
            logger.warn(e.getMessage());
            return false;
        }
    }

    static {
        String key = "Indexer_DefaultWriteLockTimeout";
        long timeout = Long.MAX_VALUE;
        String s = System.getProperty("Indexer_DefaultWriteLockTimeout");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            if (s.equalsIgnoreCase("none")) {
                timeout = -2L;
                logger.info("use DefaultWriteLockTimeout is library default value");
            } else {
                try {
                    timeout = Long.parseLong(s);
                    logger.info("use DefaultWriteLockTimeout " + timeout);
                }
                catch (NumberFormatException e) {
                    logger.error("Illegal system property Indexer_DefaultWriteLockTimeout value " + s);
                }
            }
        }
        if (timeout >= -1L) {
            IndexWriter.setDefaultWriteLockTimeout((long)timeout);
        }
        filter4suggest = new StringCommonFilter("RemoveSpace NormalizeZenkakuMinus ConvAlphabetZ2H ConvKanaH2Z ConvKigouZ2H ConvMinusZ2H ConvNumZ2H");
    }
}

