/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import jp.jasminesoft.jfc.textsearch.Indexer;
import jp.jasminesoft.jfc.textsearch.IndexerDefinition;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.collections.bag.TreeBag;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Version;

public class IndexerUtil
implements IndexerDefinition {
    private static Logger logger = LogManager.getLogger(IndexerUtil.class);
    static final DecimalFormat FORMAT = new DecimalFormat("0000000000000000000");

    public static String double2LongStr(double value, long valueBias, int shift) {
        double result = value + (double)valueBias;
        for (int i = 0; i < shift; ++i) {
            result *= 10.0;
        }
        return FORMAT.format((long)result);
    }

    public static String getItemSpecificQueryString(String itemName, String query) {
        if (query == null) {
            return null;
        }
        String[] elems = query.split("[ ]+");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elems.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(itemName);
            sb.append(":");
            if (elems[i].indexOf(":") < 0) {
                sb.append(elems[i]);
                continue;
            }
            sb.append(elems[i].substring(elems[i].indexOf(":") + 1));
        }
        return sb.toString();
    }

    public static String getQueryString(Map paramMap, String[] items, boolean prefixMatch) {
        ArrayList<String> queryList = new ArrayList<String>();
        for (int idx = 0; idx < items.length; ++idx) {
            if (!IndexerUtil.isAvailable(paramMap.get(items[idx]))) continue;
            String s = null;
            s = prefixMatch ? IndexerUtil.getQueryString4Field4PrefixMatch(items[idx], paramMap.get(items[idx]).toString()) : IndexerUtil.getQueryString4Field4PartialMatch(items[idx], IndexerUtil.removeLastAsterisk(paramMap.get(items[idx]).toString()));
            if ("".equals(s)) continue;
            queryList.add(s);
        }
        StringBuilder sb = new StringBuilder();
        if (queryList.size() == 1) {
            sb.append((String)queryList.get(0));
        } else if (queryList.size() > 1) {
            for (int idx = 0; idx < queryList.size(); ++idx) {
                if (idx > 0) {
                    sb.append(" ");
                    sb.append("AND");
                    sb.append(" ");
                }
                sb.append("(");
                sb.append((String)queryList.get(idx));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public static boolean isPrefixQuery(Map paramMap, String[] items) {
        for (int idx = 0; idx < items.length; ++idx) {
            if (paramMap.get(items[idx]) == null || !IndexerUtil.isPrefixQuery(paramMap, items[idx])) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrefixQuery(Map paramMap, String item) {
        if (IndexerUtil.isAvailable(paramMap.get(item))) {
            return paramMap.get(item).toString().endsWith("*");
        }
        return false;
    }

    public static boolean isPerfectMatchQuery(Map paramMap, String[] items) {
        if (ArrayUtils.isEmpty((Object[])items)) {
            return false;
        }
        for (int idx = 0; idx < items.length; ++idx) {
            if (paramMap.get(items[idx]) == null || IndexerUtil.isPerfectMatchQuery(paramMap, items[idx])) continue;
            logger.debug("false");
            return false;
        }
        logger.debug("true");
        return true;
    }

    public static boolean isPerfectMatchQuery(Map paramMap, String item) {
        if (paramMap == null) {
            return false;
        }
        if (IndexerUtil.isAvailable(paramMap.get(item))) {
            return !paramMap.get(item).toString().endsWith("*");
        }
        return false;
    }

    public static Map[] findPerfectMatchFromPrefixQuery(Map paramMap, String[] items, Map[] results) {
        if (paramMap == null) {
            return new Map[0];
        }
        String targetItem = null;
        if (ArrayUtils.isNotEmpty((Object[])items)) {
            for (String item : items) {
                if (!IndexerUtil.isPerfectMatchQuery(paramMap, item)) continue;
                targetItem = item;
                break;
            }
        }
        String queryStr = targetItem != null ? (String)paramMap.get(targetItem) : null;
        ArrayList<Integer> idxList = null;
        if (queryStr != null && ArrayUtils.isNotEmpty((Object[])results)) {
            for (int idx = 0; idx < results.length; ++idx) {
                String s;
                Map result = results[idx];
                if (result != null && result.get(targetItem) == null || !StringUtils.isNotBlank((CharSequence)(s = result.get(targetItem).toString())) || !s.equals(queryStr)) continue;
                if (idxList == null) {
                    idxList = new ArrayList<Integer>();
                }
                idxList.add(idx);
            }
        }
        if (idxList != null) {
            ArrayList<Map> mlist = new ArrayList<Map>();
            Iterator iterator = idxList.iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                mlist.add(results[idx]);
            }
            return mlist.toArray(new Map[0]);
        }
        return new Map[0];
    }

    public static Map[] findShortestMatchFromPrefixQuery(Map paramMap, String[] items, Map[] results) {
        String targetItem = null;
        for (String item : items) {
            if (!IndexerUtil.isPerfectMatchQuery(paramMap, item)) continue;
            targetItem = item;
            break;
        }
        int retIdx = Integer.MIN_VALUE;
        int minLength = Integer.MAX_VALUE;
        for (int idx = 0; idx < results.length; ++idx) {
            String s;
            Map result = results[idx];
            if (result.get(targetItem) == null || !StringUtils.isNotBlank((CharSequence)result.get(targetItem).toString()) || (s = result.get(targetItem).toString()).length() >= minLength) continue;
            retIdx = idx;
            minLength = s.length();
        }
        if (retIdx != Integer.MIN_VALUE) {
            return new Map[]{results[retIdx]};
        }
        return new Map[0];
    }

    public static String getQueryString4Cross(String value, String[] items) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        ArrayList<String> queryList = new ArrayList<String>();
        for (int idx = 0; idx < items.length; ++idx) {
            String s = IndexerUtil.getQueryString4Field4PartialMatch(items[idx], value);
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            queryList.add(s);
        }
        logger.debug("** querList is " + queryList);
        StringBuilder sb = new StringBuilder();
        if (queryList.size() == 1) {
            sb.append((String)queryList.get(0));
        } else if (queryList.size() > 1) {
            for (int idx = 0; idx < queryList.size(); ++idx) {
                if (idx > 0) {
                    sb.append(" ");
                    sb.append("OR");
                    sb.append(" ");
                }
                sb.append("(");
                sb.append((String)queryList.get(idx));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public static String getQueryString4CrossBR5273(String value, String[] items) {
        String ret = "";
        logger.debug("value:" + value);
        logger.debug("items:" + (items != null ? Arrays.asList(items) : ""));
        ret = StringUtils.isBlank((CharSequence)value) || items == null ? "" : IndexerUtil.mergePartial(IndexerUtil.getQueryPartial(value, items), IndexerUtil.getOperator(value));
        logger.debug(ret);
        return ret;
    }

    static String mergePartial(List<String> partial, String operator) {
        logger.debug("** partial is " + partial);
        StringBuilder sb = new StringBuilder();
        if (partial.size() == 1) {
            sb.append(partial.get(0));
        } else if (partial.size() > 1) {
            for (int idx = 0; idx < partial.size(); ++idx) {
                if (idx > 0) {
                    sb.append(" ");
                    sb.append(operator);
                    sb.append(" ");
                }
                sb.append("(");
                sb.append(partial.get(idx));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    static List<String> getQueryPartial(String value, String[] items) {
        ArrayList<String> partial = new ArrayList<String>();
        for (String term : IndexerUtil.getTerms(value)) {
            List<String> fragments = IndexerUtil.getQueryFragments(items, term);
            if (fragments.size() == 1) {
                partial.add(fragments.get(0));
                continue;
            }
            if (fragments.size() <= 1) continue;
            StringBuilder sb = new StringBuilder();
            for (int idx = 0; idx < fragments.size(); ++idx) {
                if (idx > 0) {
                    sb.append(" ");
                    sb.append("OR");
                    sb.append(" ");
                }
                sb.append("(");
                sb.append(fragments.get(idx));
                sb.append(")");
            }
            partial.add(sb.toString());
        }
        return partial;
    }

    static List<String> getQueryFragments(String[] items, String term) {
        ArrayList<String> fragments = new ArrayList<String>();
        for (int idx = 0; idx < items.length; ++idx) {
            StringBuilder sb = new StringBuilder();
            sb.append("00TS_" + items[idx]);
            sb.append(":");
            sb.append(term);
            fragments.add(sb.toString());
        }
        return fragments;
    }

    public static String getOperator(String fieldValue) {
        String[] elems;
        for (String elem : elems = IndexerUtil.splitTokens(fieldValue)) {
            if ("OR".equals(elem)) {
                return "OR";
            }
            if (!"AND".equals(elem)) continue;
            return "AND";
        }
        return "AND";
    }

    public static List<String> getTerms(String fieldValue) {
        ArrayList<String> ret = new ArrayList<String>();
        if (fieldValue != null) {
            for (String elem : IndexerUtil.splitTokens(fieldValue)) {
                if ("OR".equals(elem) || "AND".equals(elem)) continue;
                ret.add(elem);
            }
        }
        return ret;
    }

    static String getQueryString4Field4PartialMatch(String item, String fieldValue) {
        String[] elems = IndexerUtil.splitTokens(fieldValue);
        String operator = null;
        ArrayList<String> termList = new ArrayList<String>();
        for (String elem : elems) {
            StringBuilder sb = new StringBuilder();
            if (operator == null && "OR".equals(elem)) {
                operator = "OR";
                continue;
            }
            if (operator == null && "AND".equals(elem)) {
                operator = "AND";
                continue;
            }
            sb.append("00TS_" + item);
            sb.append(":");
            if (elem.matches("\".*\"")) {
                sb.append(elem);
            } else {
                sb.append(QueryParser.escape((String)elem));
            }
            termList.add(sb.toString());
        }
        StringBuilder sb = new StringBuilder();
        if (termList.size() == 1) {
            sb.append((String)termList.get(0));
        } else if (termList.size() > 1) {
            for (int tidx = 0; tidx < termList.size(); ++tidx) {
                if (tidx > 0) {
                    if ("OR".equals(operator)) {
                        sb.append(" ");
                        sb.append("OR");
                        sb.append(" ");
                    } else {
                        sb.append(" ");
                        sb.append("AND");
                        sb.append(" ");
                    }
                }
                sb.append("(");
                sb.append((String)termList.get(tidx));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    static String getQueryString4Field4PrefixMatch(String item, String fieldValue) {
        logger.debug("fieldValue:" + fieldValue);
        StringBuilder sb = new StringBuilder();
        fieldValue = fieldValue.replaceAll(" ", "");
        sb.append("00SG_" + item);
        sb.append(":");
        if (fieldValue.endsWith("*")) {
            sb.append(QueryParser.escape((String)fieldValue.substring(0, fieldValue.length() - 1)));
            sb.append("*");
        } else {
            sb.append(QueryParser.escape((String)fieldValue));
            sb.append("*");
        }
        logger.debug("sb.toString():" + sb.toString());
        return sb.toString();
    }

    public static Query getQuery(Map paramMap, String[] items, boolean prefixSearch) {
        ArrayList<Object> qList = new ArrayList<Object>();
        for (int idx = 0; idx < items.length; ++idx) {
            if (!IndexerUtil.isAvailable(paramMap.get(items[idx]))) continue;
            String s = paramMap.get(items[idx]).toString();
            if (prefixSearch) {
                qList.add(new PrefixQuery(new Term(items[idx], s)));
                continue;
            }
            PhraseQuery pq = new PhraseQuery();
            pq.add(new Term(items[idx], s));
            qList.add(pq);
        }
        if (qList.size() == 1) {
            return (Query)qList.get(0);
        }
        BooleanQuery ret = new BooleanQuery();
        for (int idx = 0; idx < qList.size(); ++idx) {
            ret.add((Query)qList.get(idx), BooleanClause.Occur.MUST);
        }
        return ret;
    }

    public static String[] splitTokens(String src) {
        if (src == null) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        boolean isQuoted = false;
        StringBuilder currToken = null;
        for (int idx = 0; idx < src.length(); ++idx) {
            if (Character.isWhitespace(src.charAt(idx))) {
                if (isQuoted) {
                    currToken.append(src.charAt(idx));
                    continue;
                }
                if (currToken == null) continue;
                ret.add(currToken.toString());
                currToken = null;
                continue;
            }
            if (src.charAt(idx) == '\"') {
                if (isQuoted) {
                    if (currToken == null) continue;
                    currToken.append('\"');
                    ret.add(currToken.toString());
                    currToken = null;
                    isQuoted = false;
                    continue;
                }
                if (currToken == null) {
                    isQuoted = true;
                    currToken = new StringBuilder();
                    currToken.append('\"');
                    continue;
                }
                throw new IllegalArgumentException("void query:" + src);
            }
            if (src.charAt(idx) == '\\') {
                if (currToken == null) {
                    currToken = new StringBuilder();
                }
                if (idx + 1 >= src.length()) continue;
                currToken.append('\\');
                currToken.append(src.charAt(idx + 1));
                ++idx;
                continue;
            }
            if (currToken == null) {
                currToken = new StringBuilder();
            }
            currToken.append(src.charAt(idx));
        }
        if (currToken != null) {
            if (isQuoted) {
                throw new IllegalArgumentException("void query:" + src);
            }
            ret.add(currToken.toString());
        }
        return ret.toArray(new String[0]);
    }

    public static boolean isEnableSplitToken(String src) {
        try {
            IndexerUtil.splitTokens(src);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAvailable(Object o) {
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            return StringUtils.isNotBlank((CharSequence)((String)o));
        }
        return false;
    }

    public static Sort getSort(String[] sort_key) {
        if (sort_key == null) {
            return Sort.RELEVANCE;
        }
        ArrayList<SortField> sfList = new ArrayList<SortField>();
        for (String s : sort_key) {
            if (s.endsWith(":DESC")) {
                sfList.add(new SortField(s.substring(0, s.length() - ":DESC".length()), 3, true));
                continue;
            }
            sfList.add(new SortField(s, 3));
        }
        return new Sort(sfList.toArray(new SortField[0]));
    }

    public static String arrayToString(Object[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < array.length; ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(array[idx]);
        }
        return sb.toString();
    }

    public static String arrayToString(byte[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < array.length; ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(array[idx]);
        }
        return sb.toString();
    }

    public static String arrayToString(short[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < array.length; ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(array[idx]);
        }
        return sb.toString();
    }

    public static String arrayToString(int[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < array.length; ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(array[idx]);
        }
        return sb.toString();
    }

    public static String arrayToString(long[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < array.length; ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(array[idx]);
        }
        return sb.toString();
    }

    public static String arrayToString(float[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < array.length; ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(array[idx]);
        }
        return sb.toString();
    }

    public static String arrayToString(double[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < array.length; ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(array[idx]);
        }
        return sb.toString();
    }

    public static Integer[] stringToIntegerArray(String src) {
        String[] elems = src.split(",");
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (String elem : elems) {
            if (elem == null || "".equals(elem.trim())) continue;
            ret.add(Integer.valueOf(elem));
        }
        return ret.toArray(new Integer[0]);
    }

    public static String[] getHighlightWords(String queryString) {
        String[] tokens;
        ArrayList<String> hlwordList = new ArrayList<String>();
        if (queryString == null) {
            queryString = "";
        }
        for (String token : tokens = IndexerUtil.splitTokens(queryString)) {
            if ("".equals(token) || "AND".equals(token) || "OR".equals(token)) continue;
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1);
                token = token.substring(0, token.length() - 1);
            }
            hlwordList.add(token);
        }
        return hlwordList.toArray(new String[0]);
    }

    public static String[] getHighlightWords(Map paramMap, String[] items) {
        ArrayList<String> hlwordList = new ArrayList<String>();
        for (int idx = 0; idx < items.length; ++idx) {
            String[] tokens;
            if (!IndexerUtil.isAvailable(paramMap.get(items[idx]))) continue;
            String s = paramMap.get(items[idx]).toString();
            for (String token : tokens = IndexerUtil.splitTokens(s)) {
                if ("".equals(token) || "AND".equals(token) || "OR".equals(token)) continue;
                if (token.startsWith("\"") && token.endsWith("\"")) {
                    token = token.substring(1);
                    token = token.substring(0, token.length() - 1);
                }
                hlwordList.add(token);
            }
        }
        return hlwordList.toArray(new String[0]);
    }

    public static String getHighlight(String target, String[] hlwords) {
        List<WordLength> hlwordsList = IndexerUtil.sortHighlightWordListByLength(hlwords);
        List<WordPiece> pieceList = IndexerUtil.getWordPieceList(target, hlwordsList);
        StringBuilder sb = new StringBuilder();
        for (WordPiece piece : pieceList) {
            if (piece.isHighlight) {
                sb.append("<b>");
            }
            sb.append(StringUtil.escapeStringForXML((String)piece.word));
            if (!piece.isHighlight) continue;
            sb.append("</b>");
        }
        return sb.toString();
    }

    static List<WordPiece> getWordPieceList(String target, List<WordLength> hlwordsList) {
        ArrayList<WordPiece> pieceList = new ArrayList<WordPiece>();
        int noHlIdx = 0;
        String targetLowerCase = target.toLowerCase();
        block0: for (int idx = 0; idx < target.length(); ++idx) {
            for (int hlidx = 0; hlidx < hlwordsList.size(); ++hlidx) {
                WordLength hlword = hlwordsList.get(hlidx);
                if (targetLowerCase.substring(idx).indexOf(hlword.word.toLowerCase()) != 0) continue;
                if (noHlIdx < idx) {
                    pieceList.add(new WordPiece(target.substring(noHlIdx, idx), false));
                }
                pieceList.add(new WordPiece(target.substring(idx, idx + hlword.word.length()), true));
                noHlIdx = idx + hlword.word.length();
                idx = noHlIdx - 1;
                continue block0;
            }
        }
        if (noHlIdx < target.length()) {
            pieceList.add(new WordPiece(target.substring(noHlIdx, target.length()), false));
        }
        return pieceList;
    }

    static List<WordLength> sortHighlightWordListByLength(String[] hlwords) {
        TreeBag hlwordsBag = new TreeBag();
        for (String hlword : hlwords) {
            hlwordsBag.add((Object)new WordLength(hlword));
        }
        WordLength[] hlwordsArray = (WordLength[])hlwordsBag.toArray((Object[])new WordLength[0]);
        ArrayList<WordLength> hlwordsList = new ArrayList<WordLength>();
        for (int idx = hlwordsArray.length - 1; idx >= 0; --idx) {
            hlwordsList.add(hlwordsArray[idx]);
        }
        return hlwordsList;
    }

    public static void makeHighlight(Map[] results, String[] items, String[] hlwords) {
        if (results == null || items == null || hlwords == null) {
            return;
        }
        for (Map result : results) {
            for (String item : items) {
                if (!result.containsKey(item) || result.get(item) == null) continue;
                String value = result.get(item).toString();
                value = IndexerUtil.snippedString(value, hlwords, 200);
                result.put(item, IndexerUtil.getHighlight(value, hlwords));
            }
        }
    }

    public static String snippedString(String target, String[] hlwords, int maxLength) {
        if (target == null || target.length() < maxLength) {
            return target;
        }
        List<ClipRange> list0 = IndexerUtil.snippedStringGetClipRangeList(target, hlwords);
        List<ClipRange> list1 = IndexerUtil.snippedStringMergeRange(list0, maxLength);
        int lgstIdx = IndexerUtil.snippedStringGetLongestRangeIndex(list1);
        if (lgstIdx < 0) {
            return target.substring(0, Math.min(target.length(), maxLength)) + "...";
        }
        List<ClipRange> list2 = IndexerUtil.snippedStringArrangeRange(list1, lgstIdx);
        return IndexerUtil.snippedStringMakeString(list2, target, maxLength);
    }

    static List<ClipRange> snippedStringGetClipRangeList(String target, String[] hlwords) {
        TreeSet<ClipRange> st = new TreeSet<ClipRange>();
        for (String hlword : hlwords) {
            int ptr = -1;
            while ((ptr = target.indexOf(hlword, ptr)) >= 0) {
                ClipRange cr = new ClipRange(ptr, ptr + hlword.length());
                st.add(cr);
                ptr += hlword.length();
            }
        }
        ArrayList<ClipRange> list0 = new ArrayList<ClipRange>();
        list0.addAll(st);
        return list0;
    }

    static List<ClipRange> snippedStringMergeRange(List<ClipRange> list0, int maxLength) {
        ArrayList<ClipRange> list1 = new ArrayList<ClipRange>();
        for (int idx = 0; idx < list0.size(); ++idx) {
            ClipRange cr = list0.get(idx);
            if (idx + 1 >= list0.size()) {
                list1.add(cr);
                continue;
            }
            ClipRange follower = list0.get(idx + 1);
            if (follower.end - cr.start < maxLength / 4) {
                list1.add(new ClipRange(cr.start, follower.end));
                idx += 2;
                continue;
            }
            list1.add(cr);
        }
        return list1;
    }

    static int snippedStringGetLongestRangeIndex(List<ClipRange> list1) {
        int lgstLength = -1;
        int lgstIdx = -1;
        for (int idx = 0; idx < list1.size(); ++idx) {
            ClipRange cr = list1.get(idx);
            if (cr.length() <= lgstLength) continue;
            lgstLength = cr.length();
            lgstIdx = idx;
        }
        return lgstIdx;
    }

    static List<ClipRange> snippedStringArrangeRange(List<ClipRange> list1, int lgstIdx) {
        ArrayList<ClipRange> list2 = new ArrayList<ClipRange>();
        list2.add(list1.get(lgstIdx));
        int n = 0;
        while (true) {
            int idx;
            if ((idx = lgstIdx + (n + 2) / 2 * (1 - 2 * ((n + 1) % 2))) >= 0) {
                if (idx >= list1.size()) break;
                list2.add(list1.get(idx));
            }
            ++n;
        }
        Collections.sort(list2);
        return list2;
    }

    static String snippedStringMakeString(List<ClipRange> list2, String target, int maxLength) {
        StringBuilder sb = null;
        int start = -1;
        int end = -1;
        for (int presufLngth = 5; presufLngth < maxLength; presufLngth += 5) {
            int clippedCharSize = 0;
            sb = new StringBuilder();
            for (int idx = 0; idx < list2.size(); ++idx) {
                ClipRange cr = list2.get(idx);
                start = cr.start - presufLngth;
                end = cr.end + presufLngth;
                if (start > 0) {
                    sb.append("...");
                } else if (start < 0) {
                    start = 0;
                }
                if (end > target.length()) {
                    end = target.length();
                }
                sb.append(target.substring(start, end));
                if ((clippedCharSize += end - start) >= maxLength || clippedCharSize >= target.length()) break;
            }
            if (clippedCharSize >= maxLength || clippedCharSize >= target.length()) break;
        }
        if (end >= 0 && end < target.length()) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static String escapeLuceneSpecialChar(String value) {
        return value != null ? value.replaceAll("([+&|!()\\[\\]{}^~*?:\\\\-])", "\\\\$1") : null;
    }

    public static String putAsteriskExceptCJToken(String query) throws IOException {
        StandardAnalyzer sa = new StandardAnalyzer(Version.LUCENE_24, Collections.EMPTY_SET);
        StringReader sr = new StringReader(query);
        TokenStream ts = sa.tokenStream(null, (Reader)sr);
        StringBuilder ret = new StringBuilder();
        String prevType = null;
        int prevEndOffset = -1;
        ts.reset();
        while (ts.incrementToken()) {
            OffsetAttribute offset = (OffsetAttribute)ts.getAttribute(OffsetAttribute.class);
            TermAttribute term = (TermAttribute)ts.getAttribute(TermAttribute.class);
            TypeAttribute type = (TypeAttribute)ts.getAttribute(TypeAttribute.class);
            logger.debug("term:>" + new String(term.termBuffer(), 0, term.termLength()) + "< length:" + term.termLength() + " type:" + type.type() + " startOffset():" + offset.startOffset() + " endOffset():" + offset.endOffset());
            IndexerUtil.putAsteriskExceptCJTokenAppendToken(type.type(), offset.startOffset(), query, ret, new String(term.termBuffer(), 0, term.termLength()), prevType, prevEndOffset);
            prevType = type.type();
            prevEndOffset = offset.endOffset();
        }
        logger.debug((CharSequence)ret);
        return ret.toString();
    }

    static void putAsteriskExceptCJTokenAppendToken(String currentType, int currentStartOffset, String query, StringBuilder ret, String term, String prevType, int prevEndOffset) {
        if (currentType.equals(StandardTokenizer.TOKEN_TYPES[7])) {
            if (prevType != null) {
                if (!StandardTokenizer.TOKEN_TYPES[7].equals(prevType)) {
                    ret.append(" ");
                } else if (prevEndOffset < currentStartOffset) {
                    ret.append(" ");
                }
            }
            ret.append(term);
        } else if ("or".equals(term) || "and".equals(term)) {
            if (ret.length() > 0) {
                ret.append(" ");
            }
            ret.append(term.toUpperCase());
        } else {
            if (ret.length() > 0) {
                ret.append(" ");
            }
            ret.append(term);
            ret.append("*");
        }
    }

    public static int countQueryClause(Query query) {
        int count = 1;
        if (query instanceof BooleanQuery) {
            for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
                count += IndexerUtil.countQueryClause(clause.getQuery());
            }
        }
        return count;
    }

    public static Query getWildcardQuery(Map paramMap, String[] items) {
        ArrayList<WildcardQuery> queryList = new ArrayList<WildcardQuery>();
        for (int idx = 0; idx < items.length; ++idx) {
            if (!IndexerUtil.isAvailable(paramMap.get(items[idx]))) continue;
            Object fieldValue = paramMap.get(items[idx]).toString();
            logger.debug("fieldValue:" + (String)fieldValue);
            fieldValue = Indexer.createStringForSuggest((String)fieldValue);
            fieldValue = ((String)fieldValue).endsWith("*") ? QueryParser.escape((String)((String)fieldValue).substring(0, ((String)fieldValue).length() - 1)) + "*" : QueryParser.escape((String)fieldValue) + "*";
            queryList.add(new WildcardQuery(new Term("00SG_" + items[idx], (String)fieldValue)));
        }
        Query ret = null;
        if (queryList.size() == 1) {
            ret = (Query)queryList.get(0);
        } else if (queryList.size() > 1) {
            BooleanQuery bQuery = new BooleanQuery();
            bQuery.setMinimumNumberShouldMatch(1);
            for (int idx = 0; idx < queryList.size(); ++idx) {
                bQuery.add((Query)queryList.get(idx), BooleanClause.Occur.SHOULD);
            }
            ret = bQuery;
        }
        return ret;
    }

    public static String removeLastAsterisk(String value) {
        if (value == null) {
            return "";
        }
        if (value.endsWith("*")) {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static Map[] findPerfectMatch(Map paramMap, String[] items, Map[] results) {
        Map[] perfectMatch = IndexerUtil.findPerfectMatchFromPrefixQuery(paramMap, items, results);
        results = perfectMatch != null && perfectMatch.length > 0 ? perfectMatch : IndexerUtil.findShortestMatchFromPrefixQuery(paramMap, items, results);
        return results;
    }

    static class WordPiece {
        String word;
        boolean isHighlight;

        public WordPiece(String word, boolean isHighlight) {
            this.word = word;
            this.isHighlight = isHighlight;
        }
    }

    static class WordLength
    implements Comparable<WordLength> {
        String word;

        public WordLength(String word) {
            this.word = word;
        }

        public boolean equals(Object o) {
            if (!(o instanceof WordLength)) {
                return false;
            }
            return this.word.equals(((WordLength)o).word);
        }

        public int hashCode() {
            return this.word.hashCode();
        }

        @Override
        public int compareTo(WordLength o) {
            if (this.word.length() - o.word.length() == 0) {
                return this.word.compareTo(o.word);
            }
            return this.word.length() - o.word.length();
        }

        public String toString() {
            return this.word;
        }
    }

    static class ClipRange
    implements Comparable {
        int start = -1;
        int end = -1;

        ClipRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int length() {
            if (this.start < 0 || this.end < 0) {
                throw new IllegalStateException("start is " + this.start + ". end is " + this.end);
            }
            return this.end - this.start;
        }

        public int compareTo(Object o) {
            ClipRange hr = (ClipRange)o;
            if (this.start < hr.start) {
                return -1;
            }
            if (this.start == hr.start) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClipRange)) {
                return false;
            }
            ClipRange cr = (ClipRange)o;
            return cr.start == this.start && cr.end == this.end;
        }

        public int hashCode() {
            return this.start * 13 + this.end * 17;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + "]";
        }
    }
}

