/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.util.RandomString;

public class RepconFileStringUtil {
    public static final String DELIMITA_REGEX = "<#[0-9a-zA-Z]{8}#>";

    public static String getDelimita() {
        return "<#" + RandomString.createRandomString((int)8) + "#>";
    }

    public static String getFilenameAttachedString(String filename, String filepath, String extracted) {
        String delimita = RepconFileStringUtil.getDelimita();
        return delimita + (filename == null ? "" : filename) + delimita + (filepath == null ? "" : filepath) + delimita + (extracted == null ? "" : extracted) + delimita;
    }

    public static String getStringFilenameRemoved(String markedStr) {
        List<FileRange> ranges = RepconFileStringUtil.getFileRangeList(markedStr);
        if (ranges.size() == 0) {
            return markedStr;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ranges.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            FileRange range = ranges.get(i);
            sb.append(markedStr.substring(range.getStart(), range.getEnd()));
        }
        return sb.toString();
    }

    public static String[] getStringFilenameRemovedArray(String markedStr) {
        List<FileRange> ranges = RepconFileStringUtil.getFileRangeList(markedStr);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < ranges.size(); ++i) {
            FileRange range = ranges.get(i);
            ret.add(markedStr.substring(range.getStart(), range.getEnd()));
        }
        return ret.toArray(new String[0]);
    }

    public static List<FileRange> getFileRangeList(String markedStr) {
        if (markedStr == null) {
            markedStr = "";
        }
        Pattern p = Pattern.compile(DELIMITA_REGEX);
        Matcher m = p.matcher(markedStr);
        ArrayList<String> delimitas = new ArrayList<String>();
        while (m.find()) {
            if (delimitas.contains(m.group())) continue;
            delimitas.add(m.group());
        }
        ArrayList<FileRange> ret = new ArrayList<FileRange>();
        for (String d : delimitas) {
            int fstIdx = markedStr.indexOf(d);
            int sndIdx = -1;
            if (fstIdx >= 0) {
                sndIdx = markedStr.indexOf(d, fstIdx + d.length());
            }
            int thdIdx = -1;
            if (sndIdx >= 0) {
                thdIdx = markedStr.indexOf(d, sndIdx + d.length());
            }
            int fthIdx = -1;
            if (thdIdx >= 0) {
                fthIdx = markedStr.indexOf(d, thdIdx + d.length());
            }
            String filename = null;
            if (fstIdx >= 0 && sndIdx >= 0) {
                filename = markedStr.substring(fstIdx + d.length(), sndIdx);
            }
            String filepath = null;
            if (sndIdx >= 0 && thdIdx >= 0) {
                filepath = markedStr.substring(sndIdx + d.length(), thdIdx);
            }
            int rangeStart = -1;
            if (thdIdx >= 0) {
                rangeStart = thdIdx + d.length();
            }
            int rangeEnd = -1;
            if (fthIdx >= 0) {
                rangeEnd = fthIdx;
            } else if (d.equals(delimitas.get(delimitas.size() - 1))) {
                rangeEnd = markedStr.length();
            }
            if (filename == null || filepath == null || rangeStart < 0 || rangeEnd < 0) continue;
            ret.add(new FileRange(filename, filepath, rangeStart, rangeEnd));
        }
        return ret;
    }

    public static String getFilenameAt(String markedStr, int index) {
        List<FileRange> ranges = RepconFileStringUtil.getFileRangeList(markedStr);
        for (FileRange range : ranges) {
            if (!range.isIn(index)) continue;
            return range.getFilename();
        }
        return "";
    }

    public static class FileRange
    implements Comparable<FileRange> {
        private String filename;
        private String filepath;
        private int start;
        private int end;

        public String getFilename() {
            return this.filename;
        }

        public String getFilepath() {
            return this.filepath;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        FileRange(String filename, String filepath, int start, int end) {
            if (filename == null) {
                filename = "";
            }
            if (filepath == null) {
                filepath = "";
            }
            this.filename = filename;
            this.filepath = filepath;
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(FileRange other) {
            return other.start - this.start;
        }

        public boolean isIn(int idx) {
            return this.start <= idx && idx < this.end;
        }

        public boolean equals(Object o) {
            if (o instanceof FileRange) {
                FileRange other = (FileRange)o;
                return this.filename.equals(other.filename) && this.filepath.equals(other.filepath) && this.start == other.start && this.end == other.end;
            }
            return false;
        }
    }
}

