/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import jp.jasminesoft.jfc.textsearch.CharCounter;
import jp.jasminesoft.jfc.textsearch.TextExtractor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SampleTextExtractor
extends TextExtractor {
    private static final Logger logger = LogManager.getLogger((String)SampleTextExtractor.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String extract(CharCounter cc, String filename, File f) throws Exception {
        if (cc.isOverLimit()) {
            return "";
        }
        try {
            TextExtractor.isExtractable(f);
        }
        catch (Exception e) {
            logger.warn("filename:" + f.getAbsolutePath());
            return "";
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "JISAutoDetect"));
            String s = br.readLine();
            while (s != null && !cc.isOverLimit()) {
                sb.append(cc.countChar(s));
                s = br.readLine();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return sb.toString();
    }
}

