/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.JFCControlUtil;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.textsearch.IndexerUtil;
import jp.jasminesoft.jfc.textsearch.RepconFileStringUtil;
import jp.jasminesoft.util.StringUtil;

public class TextsearchPageUtil {
    private static final String BEGIN = "<b>";
    private static final String FILENAME_FOOTER = "_jshfilename";
    private static final String UNKNOWN_ICON = "unknownicon.png";
    private static final Map<String, String> fileIconMap = new HashMap<String, String>();
    private HttpServletRequest request;
    private HttpSession session;
    private ResourceBundle rb;

    private static String getFileIconPath(String filename) {
        String ret = UNKNOWN_ICON;
        if (filename == null) {
            filename = "";
        }
        filename = filename.toLowerCase();
        for (Map.Entry<String, String> entry : fileIconMap.entrySet()) {
            if (!filename.endsWith(entry.getKey())) continue;
            ret = entry.getValue();
            break;
        }
        return ret;
    }

    public TextsearchPageUtil(HttpServletRequest request, HttpSession session) {
        this.request = request;
        this.session = session;
        String locale_str = (String)session.getAttribute("__jfc_locale");
        this.rb = JFCUtils.getResourceBundleInLocaleStrings(locale_str, "jfcapp");
        this.clearDownloadInfoParam(session);
    }

    private String[] getHilightWords() {
        String[] hiwords = (String[])this.request.getAttribute("TEXTSEARCH_HIGHLIGHT_WORDS");
        if (hiwords == null) {
            hiwords = new String[]{};
        }
        return hiwords;
    }

    private List<String> getTitleItems() {
        String[] titems = (String[])this.request.getAttribute("TEXTSEARCH_TITLE_ITEMS");
        if (titems == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(titems);
    }

    private String getSid() {
        return (String)this.request.getAttribute("SID");
    }

    private String getPid() {
        return (String)this.request.getAttribute("PID");
    }

    private String getResourceString(String rheader, String itemname, ResourceBundle rb) {
        String ret;
        if (itemname.endsWith(FILENAME_FOOTER)) {
            itemname = itemname.replaceAll(FILENAME_FOOTER, "");
        }
        if ((ret = JFCUtils.getRValue(rheader + itemname, rb)) == null) {
            ret = itemname;
        }
        return ret;
    }

    private String getSessionParamNameFilename(String sid, Integer positionIndex, String itemname, int idx) {
        return "TEXTSEARCH_DOWNLOAD_" + sid + "_" + positionIndex + "_" + itemname + "_" + idx;
    }

    private String getSessionParamNameJshfilename(String sid, Integer positionIndex, String itemname, int idx) {
        return this.getSessionParamNameFilename(sid, positionIndex, itemname, idx) + FILENAME_FOOTER;
    }

    private List<DetailItem> createPrintString(Map<Iteminfo, String> map, boolean skipIfContentNull) {
        ArrayList<DetailItem> items = new ArrayList<DetailItem>();
        for (Map.Entry<Iteminfo, String> entry : map.entrySet()) {
            Iteminfo label = entry.getKey();
            String content = entry.getValue();
            if (skipIfContentNull && (content == null || content.trim().length() == 0)) continue;
            items.add(new DetailItem(StringUtil.removeCR((String)label.getDisplaynameAtDetail()), StringUtil.removeCR((String)content)));
        }
        return items;
    }

    public TextsearchResult createTextsearchResult(Map<String, String> map, Integer positionIndex) {
        return new TextsearchResult(map, positionIndex);
    }

    public void clearDownloadInfoParam(HttpSession session) {
        ArrayList<String> toRemove = new ArrayList<String>();
        Enumeration enu = session.getAttributeNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (name == null || !name.startsWith("TEXTSEARCH_DOWNLOAD")) continue;
            toRemove.add(name);
        }
        for (String name : toRemove) {
            session.removeAttribute(name);
        }
    }

    static {
        fileIconMap.put("doc", "wordicon.png");
        fileIconMap.put("docx", "wordicon.png");
        fileIconMap.put("pdf", "pdficon.png");
        fileIconMap.put("ppt", "ppticon.png");
        fileIconMap.put("pptx", "ppticon.png");
        fileIconMap.put("xls", "excelicon.png");
        fileIconMap.put("xlsx", "excelicon.png");
        fileIconMap.put("zip", "archiveicon.png");
    }

    public class Iteminfo {
        private String itemname;
        private String displayname;
        private String filename;
        private String filepath;
        private int positionIdx;
        private int repconIdx;

        Iteminfo(String itemname, String sid, String filename, String filepath, int positionIdx, int repconIdx) {
            this(itemname, sid);
            this.filename = filename;
            this.filepath = filepath;
            this.positionIdx = positionIdx;
            this.repconIdx = repconIdx;
        }

        Iteminfo(String itemname, String sid) {
            this.itemname = itemname;
            Object rheader = new String(sid);
            if (rheader != null && ((String)rheader).length() > 0) {
                rheader = (String)rheader + ".";
            }
            this.displayname = TextsearchPageUtil.this.getResourceString((String)rheader, itemname, TextsearchPageUtil.this.rb);
        }

        public String getDisplaynameAtDetail() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.displayname);
            if (this.filename != null && this.filename.length() > 0) {
                sb.append("( ").append(this.filename).append(" )");
            }
            return sb.toString();
        }

        public String getFilename() {
            return this.filename;
        }

        public String getFileIconPath() {
            return TextsearchPageUtil.getFileIconPath(this.filename);
        }

        public String getFileUrl() {
            String sid = TextsearchPageUtil.this.getSid();
            return "wagbyDownload.do?path=" + TextsearchPageUtil.this.getSessionParamNameJshfilename(sid, this.positionIdx, this.itemname, this.repconIdx) + "&fname=" + TextsearchPageUtil.this.getSessionParamNameFilename(sid, this.positionIdx, this.itemname, this.repconIdx);
        }

        public int hashCode() {
            return ((this.itemname != null ? this.itemname.hashCode() : 0) + (this.displayname != null ? this.displayname.hashCode() : 0) + (this.filename != null ? this.filename.hashCode() : 0) + (this.filepath != null ? this.filepath.hashCode() : 0) + this.positionIdx + this.repconIdx) % 47;
        }

        public boolean equals(Object o) {
            boolean result = true;
            if (o instanceof Iteminfo) {
                Iteminfo other = (Iteminfo)o;
                result &= this.itemname != null ? this.itemname.equals(other.itemname) : other.itemname == null;
                result &= this.displayname != null ? this.displayname.equals(other.displayname) : other.displayname == null;
                result &= this.filename != null ? this.filename.equals(other.filename) : other.filename == null;
                result &= this.filepath != null ? this.filepath.equals(other.filepath) : other.filepath == null;
                result &= this.positionIdx == other.positionIdx;
                result &= this.repconIdx == other.repconIdx;
            }
            return result;
        }
    }

    public static class DetailItem {
        private String label;
        private String content;

        DetailItem(String label, String content) {
            this.label = label;
            this.content = content;
        }

        public String getLabel() {
            return this.label;
        }

        public String getContent() {
            return this.content;
        }
    }

    public class TextsearchResult {
        private String digest;
        private String title;
        private List<DetailItem> detail;
        private Collection<Iteminfo> filecontent;

        public TextsearchResult(Map<String, String> map, Integer positionIndex) {
            LinkedHashMap<Iteminfo, String> smap = new LinkedHashMap<Iteminfo, String>();
            LinkedHashMap<Iteminfo, String> fmap = new LinkedHashMap<Iteminfo, String>();
            LinkedHashMap<Iteminfo, String> r_map = new LinkedHashMap<Iteminfo, String>();
            this.createMaps(map, positionIndex, fmap, smap, r_map);
            this.digest = this.createDigest(map);
            this.title = this.decideTitle(r_map);
            this.detail = this.createDetail(smap, fmap);
            this.filecontent = fmap.keySet();
            this.prepareDownloadFileInfo(map, positionIndex);
        }

        public String getDigest() {
            return StringUtil.removeCR((String)this.digest);
        }

        public String getTitle() {
            return this.title;
        }

        public List<DetailItem> getDetail() {
            return this.detail;
        }

        public Collection<Iteminfo> getFilecontent() {
            return this.filecontent;
        }

        private List<DetailItem> createDetail(Map<Iteminfo, String> smap, Map<Iteminfo, String> fmap) {
            LinkedHashMap<Iteminfo, String> imap = new LinkedHashMap<Iteminfo, String>();
            imap.putAll(smap);
            imap.putAll(fmap);
            return TextsearchPageUtil.this.createPrintString(imap, true);
        }

        private void createMaps(Map<String, String> map, Integer positionIndex, Map<Iteminfo, String> fmap, Map<Iteminfo, String> smap, Map<Iteminfo, String> r_map) {
            String sid = TextsearchPageUtil.this.getSid();
            String pid = TextsearchPageUtil.this.getPid();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String itemname = entry.getKey();
                JFCControlUtil.ControlType control = JFCControlUtil.getControlType(TextsearchPageUtil.this.request, sid, pid, itemname);
                if (control == JFCControlUtil.ControlType.Hidden) continue;
                String content = entry.getValue();
                if (itemname.endsWith(TextsearchPageUtil.FILENAME_FOOTER)) {
                    this.prepareContentNLabel4File(content, itemname, positionIndex, fmap, r_map);
                    continue;
                }
                this.prepareContentNLabel(content, itemname, smap, r_map);
            }
        }

        private String createDigest(Map<String, String> map) {
            StringBuilder sb = new StringBuilder();
            String sid = TextsearchPageUtil.this.getSid();
            String pid = TextsearchPageUtil.this.getPid();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                JFCControlUtil.ControlType control;
                String itemname = entry.getKey();
                if (itemname.startsWith("__jfc_urlencoded_") || (control = JFCControlUtil.getControlType(TextsearchPageUtil.this.request, sid, pid, itemname)) == JFCControlUtil.ControlType.Hidden) continue;
                String content = entry.getValue();
                if (itemname.endsWith(TextsearchPageUtil.FILENAME_FOOTER)) {
                    for (String fcontent : RepconFileStringUtil.getStringFilenameRemovedArray(content)) {
                        if (fcontent.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(fcontent);
                    }
                    continue;
                }
                if (content.length() > 0) {
                    sb.append(",");
                }
                sb.append(content);
            }
            String[] hiwords = TextsearchPageUtil.this.getHilightWords();
            String digest1 = IndexerUtil.snippedString(sb.toString(), hiwords, 100);
            return IndexerUtil.getHighlight(digest1, hiwords);
        }

        private String decideTitle(Map<Iteminfo, String> r_map) {
            StringBuilder sb = new StringBuilder();
            List<String> titleitems = TextsearchPageUtil.this.getTitleItems();
            block0: for (String titleitem : titleitems) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                for (Map.Entry<Iteminfo, String> entry : r_map.entrySet()) {
                    Iteminfo ii = entry.getKey();
                    String content = entry.getValue();
                    if (!titleitem.equals(ii.itemname)) continue;
                    sb.append(content);
                    continue block0;
                }
            }
            if (sb.length() == 0) {
                sb.append(JFCUtils.getRValue("__jfc_common.textsearch.no_title", TextsearchPageUtil.this.rb));
            }
            return sb.toString();
        }

        private void prepareDownloadFileInfo(Map<String, String> map, Integer positionIndex) {
            String sid = TextsearchPageUtil.this.getSid();
            String pid = TextsearchPageUtil.this.getPid();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String itemname = entry.getKey();
                JFCControlUtil.ControlType control = JFCControlUtil.getControlType(TextsearchPageUtil.this.request, sid, pid, itemname);
                if (control == JFCControlUtil.ControlType.Hidden || !itemname.endsWith(TextsearchPageUtil.FILENAME_FOOTER)) continue;
                String content = entry.getValue();
                List<RepconFileStringUtil.FileRange> ranges = RepconFileStringUtil.getFileRangeList(content);
                for (int i = 0; i < ranges.size(); ++i) {
                    String fname = TextsearchPageUtil.this.getSessionParamNameFilename(sid, positionIndex, itemname, i);
                    TextsearchPageUtil.this.session.setAttribute(fname, (Object)ranges.get(i).getFilename());
                    TextsearchPageUtil.this.session.setAttribute("__jfc_DownloadFileController_modelId_" + fname, (Object)sid);
                    String pkey = map != null ? map.get("__jfc_uniqueKey") : "";
                    TextsearchPageUtil.this.session.setAttribute("__jfc_DownloadFileController_pkey_" + fname, (Object)pkey);
                    String itemname2 = itemname.substring(0, itemname.length() - TextsearchPageUtil.FILENAME_FOOTER.length());
                    TextsearchPageUtil.this.session.setAttribute("__jfc_DownloadFileController_modelitemName_" + fname, (Object)itemname2);
                    TextsearchPageUtil.this.session.setAttribute(TextsearchPageUtil.this.getSessionParamNameJshfilename(sid, positionIndex, itemname, i), (Object)ranges.get(i).getFilepath());
                }
            }
        }

        private void prepareContentNLabel4File(String content, String itemname, Integer positionIndex, Map<Iteminfo, String> fmap, Map<Iteminfo, String> r_map) {
            List<RepconFileStringUtil.FileRange> ranges = RepconFileStringUtil.getFileRangeList(content);
            String[] fcontents = RepconFileStringUtil.getStringFilenameRemovedArray(content);
            if (fcontents.length > 0) {
                String[] hiwords = TextsearchPageUtil.this.getHilightWords();
                List<String> titleitems = TextsearchPageUtil.this.getTitleItems();
                String sid = TextsearchPageUtil.this.getSid();
                for (int i = 0; i < fcontents.length; ++i) {
                    String s = fcontents[i];
                    if (s == null || s.trim().length() == 0) continue;
                    s = IndexerUtil.snippedString(s, hiwords, 100);
                    if ((s = IndexerUtil.getHighlight(s, hiwords)) == null || s.indexOf(TextsearchPageUtil.BEGIN) < 0 && !titleitems.contains(itemname) || ranges.get(i).getFilename() == null || ranges.get(i).getFilename().length() <= 0) continue;
                    Iteminfo ii = new Iteminfo(itemname, sid, ranges.get(i).getFilename(), ranges.get(i).getFilepath(), positionIndex, i);
                    fmap.put(ii, s);
                    r_map.put(ii, s);
                }
            }
        }

        private void prepareContentNLabel(String content, String itemname, Map<Iteminfo, String> smap, Map<Iteminfo, String> r_map) {
            String[] hiwords = TextsearchPageUtil.this.getHilightWords();
            content = IndexerUtil.snippedString(content, hiwords, 100);
            content = IndexerUtil.getHighlight(content, hiwords);
            List<String> titleitems = TextsearchPageUtil.this.getTitleItems();
            String sid = TextsearchPageUtil.this.getSid();
            if (content != null && (content.indexOf(TextsearchPageUtil.BEGIN) >= 0 || titleitems.contains(itemname))) {
                Iteminfo ii = new Iteminfo(itemname, sid);
                smap.put(ii, content);
                r_map.put(ii, content);
            }
        }
    }
}

