/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jp.jasminesoft.jfc.textsearch.CharCounter;
import jp.jasminesoft.jfc.textsearch.TextExtractor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;

public class TikaTextExtractor
extends TextExtractor {
    private static final Logger logger = LogManager.getLogger((String)TikaTextExtractor.class.getName());
    private static final String TIKA_CONFIG_STR = "<properties><service-loader initializableProblemHandler=\"ignore\"/></properties>";
    private static final TikaConfig DEFAULT_TIKA_CONFIG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String extract(CharCounter cc, String filename, File f) {
        if (cc.isOverLimit()) {
            return "";
        }
        logger.debug("extract " + f + " as " + filename);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        StringBuilder sb = new StringBuilder(1024);
        Future<?> future = executor.submit(new ExtractRunnable(f, filename, sb, cc));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            executor.shutdown();
        }
        return sb.toString();
    }

    private static boolean isUseDefaultConfig() {
        String config = System.getProperty("tika.config");
        if (config == null) {
            config = System.getenv("TIKA_CONFIG");
        }
        if (config != null) {
            return true;
        }
        return logger.isDebugEnabled();
    }

    static {
        TikaConfig config = null;
        if (!TikaTextExtractor.isUseDefaultConfig()) {
            try {
                config = new TikaConfig((InputStream)new ByteArrayInputStream(TIKA_CONFIG_STR.getBytes(StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                logger.error("Failed create TikaConfig", (Throwable)e);
            }
        }
        DEFAULT_TIKA_CONFIG = config;
    }

    class ExtractRunnable
    implements Runnable {
        File f;
        String filename;
        StringBuilder sb;
        CharCounter cc;

        ExtractRunnable(File f, String filename, StringBuilder sb, CharCounter cc) {
            this.f = f;
            this.filename = filename;
            this.sb = sb;
            this.cc = cc;
        }

        @Override
        public void run() {
            try {
                String s;
                int len;
                TikaConfig config = DEFAULT_TIKA_CONFIG;
                if (config == null) {
                    config = TikaConfig.getDefaultConfig();
                }
                Metadata metadata = new Metadata();
                metadata.set("resourceName", this.filename);
                if (this.cc.getLimit() == -1) {
                    len = -1;
                } else {
                    len = this.cc.getLimit() - this.cc.getCount();
                    if (len <= 0) {
                        return;
                    }
                }
                Tika tika = new Tika(config);
                try (FileInputStream stream = new FileInputStream(this.f);){
                    s = tika.parseToString((InputStream)stream, metadata, len);
                }
                this.sb.append(this.cc.countChar(s));
            }
            catch (LinkageError e) {
                logger.error("LinkageError " + e.getMessage() + ". if NoClassDefFoundError occured,please check if bcmail-jdk15.jar and bcprov-jdk15.jar are in $(APPNAME)/WEB-INF/lib ", (Throwable)e);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

